/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.consumer.AcknowledgeType;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.tools.ToolsTestUtils;
import org.apache.kafka.tools.consumer.ConsoleShareConsumerOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsoleShareConsumerOptionsTest {
    @Test
    public void shouldParseValidConsumerValidConfig() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test"};
        ConsoleShareConsumerOptions config = new ConsoleShareConsumerOptions(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertFalse((boolean)config.rejectMessageOnError());
        Assertions.assertEquals((int)-1, (int)config.maxMessages());
        Assertions.assertEquals((int)-1, (int)config.timeoutMs());
    }

    @Test
    public void shouldExitOnUnrecognizedNewConsumerOption() {
        Exit.setExitProcedure((code, message) -> {
            throw new IllegalArgumentException(message);
        });
        String[] args = new String[]{"--new-consumer", "--bootstrap-server", "localhost:9092", "--topic", "test"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleShareConsumerOptions(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldParseValidConsumerConfigWithSessionTimeout() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "session.timeout.ms=10000"};
        ConsoleShareConsumerOptions config = new ConsoleShareConsumerOptions(args);
        Properties consumerProperties = config.consumerProps();
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg());
        Assertions.assertEquals((Object)"10000", (Object)consumerProperties.getProperty("session.timeout.ms"));
    }

    @Test
    public void shouldParseConfigsFromFile() throws IOException {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("request.timeout.ms", "1000");
        configs.put("group.id", "group1");
        File propsFile = ToolsTestUtils.tempPropertiesFile(configs);
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-config", propsFile.getAbsolutePath()};
        ConsoleShareConsumerOptions config = new ConsoleShareConsumerOptions(args);
        Map configMap = Utils.propsToMap((Properties)config.consumerProps());
        Assertions.assertEquals((Object)"1000", configMap.get("request.timeout.ms"));
        Assertions.assertEquals((Object)"group1", configMap.get("group.id"));
    }

    @Test
    public void groupIdsProvidedInDifferentPlacesMustMatch() throws IOException {
        Exit.setExitProcedure((code, message) -> {
            throw new IllegalArgumentException(message);
        });
        File propsFile = ToolsTestUtils.tempPropertiesFile(Collections.singletonMap("group.id", "group-from-file"));
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties", "--consumer-config", propsFile.getAbsolutePath()};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleShareConsumerOptions(args));
        propsFile = ToolsTestUtils.tempPropertiesFile(Collections.singletonMap("group.id", "test-group"));
        String[] args1 = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--consumer-property", "group.id=test-group", "--consumer-config", propsFile.getAbsolutePath()};
        ConsoleShareConsumerOptions config = new ConsoleShareConsumerOptions(args1);
        Properties props = config.consumerProps();
        Assertions.assertEquals((Object)"test-group", (Object)props.getProperty("group.id"));
        propsFile = ToolsTestUtils.tempPropertiesFile(Collections.singletonMap("group.id", "group-from-file"));
        String[] args2 = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "group.id=group-from-properties", "--consumer-config", propsFile.getAbsolutePath()};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleShareConsumerOptions(args2));
        String[] args3 = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties"};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleShareConsumerOptions(args3));
        propsFile = ToolsTestUtils.tempPropertiesFile(Collections.singletonMap("group.id", "group-from-file"));
        String[] args4 = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-config", propsFile.getAbsolutePath()};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleShareConsumerOptions(args4));
        String[] args5 = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments"};
        config = new ConsoleShareConsumerOptions(args5);
        props = config.consumerProps();
        Assertions.assertEquals((Object)"group-from-arguments", (Object)props.getProperty("group.id"));
        Exit.resetExitProcedure();
    }

    @Test
    public void shouldExitIfNoTopicSpecified() {
        Exit.setExitProcedure((code, message) -> {
            throw new IllegalArgumentException(message);
        });
        String[] args = new String[]{"--bootstrap-server", "localhost:9092"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleShareConsumerOptions(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testClientIdOverride() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "client.id=consumer-1"};
        ConsoleShareConsumerOptions config = new ConsoleShareConsumerOptions(args);
        Properties consumerProperties = config.consumerProps();
        Assertions.assertEquals((Object)"consumer-1", (Object)consumerProperties.getProperty("client.id"));
    }

    @Test
    public void testDefaultClientId() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test"};
        ConsoleShareConsumerOptions config = new ConsoleShareConsumerOptions(args);
        Properties consumerProperties = config.consumerProps();
        Assertions.assertEquals((Object)"console-share-consumer", (Object)consumerProperties.getProperty("client.id"));
    }

    @Test
    public void testRejectOption() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--reject"};
        ConsoleShareConsumerOptions config = new ConsoleShareConsumerOptions(args);
        Assertions.assertEquals((Object)AcknowledgeType.REJECT, (Object)config.acknowledgeType());
    }

    @Test
    public void testReleaseOption() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--release"};
        ConsoleShareConsumerOptions config = new ConsoleShareConsumerOptions(args);
        Assertions.assertEquals((Object)AcknowledgeType.RELEASE, (Object)config.acknowledgeType());
    }

    @Test
    public void testRejectAndReleaseOption() throws IOException {
        Exit.setExitProcedure((code, message) -> {
            throw new IllegalArgumentException(message);
        });
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--reject", "--release"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleShareConsumerOptions(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }
}

