/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools.consumer;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.test.MockDeserializer;
import org.apache.kafka.tools.ToolsTestUtils;
import org.apache.kafka.tools.consumer.ConsoleConsumerOptions;
import org.apache.kafka.tools.consumer.DefaultMessageFormatter;
import org.apache.kafka.tools.consumer.LoggingMessageFormatter;
import org.apache.kafka.tools.consumer.NoOpMessageFormatter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConsoleConsumerOptionsTest {
    @Test
    public void shouldParseValidConsumerValidConfig() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg().orElse(""));
        Assertions.assertTrue((boolean)config.fromBeginning());
        Assertions.assertFalse((boolean)config.enableSystestEventsLogging());
        Assertions.assertFalse((boolean)config.skipMessageOnError());
        Assertions.assertEquals((int)-1, (int)config.maxMessages());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)config.timeoutMs());
    }

    @Test
    public void shouldParseIncludeArgument() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--include", "includeTest*", "--from-beginning"};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"includeTest*", (Object)config.includedTopicsArg().orElse(""));
        Assertions.assertTrue((boolean)config.fromBeginning());
    }

    @Test
    public void shouldParseValidSimpleConsumerValidConfigWithNumericOffset() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "3"};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg().orElse(""));
        Assertions.assertTrue((boolean)config.partitionArg().isPresent());
        Assertions.assertEquals((int)0, (int)config.partitionArg().getAsInt());
        Assertions.assertEquals((long)3L, (long)config.offsetArg());
        Assertions.assertFalse((boolean)config.fromBeginning());
    }

    @Test
    public void shouldExitOnUnrecognizedNewConsumerOption() {
        Exit.setExitProcedure((code, message) -> {
            throw new IllegalArgumentException(message);
        });
        String[] args = new String[]{"--new-consumer", "--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumerOptions(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldExitIfPartitionButNoTopic() {
        Exit.setExitProcedure((code, message) -> {
            throw new IllegalArgumentException(message);
        });
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--include", "test.*", "--partition", "0"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumerOptions(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldExitIfFromBeginningAndOffset() {
        Exit.setExitProcedure((code, message) -> {
            throw new IllegalArgumentException(message);
        });
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--from-beginning", "--offset", "123"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumerOptions(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldParseValidSimpleConsumerValidConfigWithStringOffset() throws Exception {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "LatEst", "--property", "print.value=false"};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg().orElse(""));
        Assertions.assertTrue((boolean)config.partitionArg().isPresent());
        Assertions.assertEquals((int)0, (int)config.partitionArg().getAsInt());
        Assertions.assertEquals((long)-1L, (long)config.offsetArg());
        Assertions.assertFalse((boolean)config.fromBeginning());
        Assertions.assertFalse((boolean)((DefaultMessageFormatter)config.formatter()).printValue());
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetLatest() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=latest"};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args);
        Properties consumerProperties = config.consumerProps();
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg().orElse(""));
        Assertions.assertFalse((boolean)config.fromBeginning());
        Assertions.assertEquals((Object)"latest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetEarliest() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=earliest"};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args);
        Properties consumerProperties = config.consumerProps();
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg().orElse(""));
        Assertions.assertFalse((boolean)config.fromBeginning());
        Assertions.assertEquals((Object)"earliest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithAutoOffsetResetAndMatchingFromBeginning() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=earliest", "--from-beginning"};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args);
        Properties consumerProperties = config.consumerProps();
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg().orElse(""));
        Assertions.assertTrue((boolean)config.fromBeginning());
        Assertions.assertEquals((Object)"earliest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldParseValidConsumerConfigWithNoOffsetReset() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test"};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args);
        Properties consumerProperties = config.consumerProps();
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg().orElse(""));
        Assertions.assertFalse((boolean)config.fromBeginning());
        Assertions.assertEquals((Object)"latest", (Object)consumerProperties.getProperty("auto.offset.reset"));
    }

    @Test
    public void shouldExitOnInvalidConfigWithAutoOffsetResetAndConflictingFromBeginning() {
        Exit.setExitProcedure((code, message) -> {
            throw new IllegalArgumentException(message);
        });
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "auto.offset.reset=latest", "--from-beginning"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumerOptions(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldParseConfigsFromFile() throws IOException {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("request.timeout.ms", "1000");
        configs.put("group.id", "group1");
        File propsFile = ToolsTestUtils.tempPropertiesFile(configs);
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer.config", propsFile.getAbsolutePath()};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args);
        Assertions.assertEquals((Object)"1000", (Object)config.consumerProps().get("request.timeout.ms"));
        Assertions.assertEquals((Object)"group1", (Object)config.consumerProps().get("group.id"));
    }

    @Test
    public void groupIdsProvidedInDifferentPlacesMustMatch() throws IOException {
        Exit.setExitProcedure((code, message) -> {
            throw new IllegalArgumentException(message);
        });
        File propsFile = ToolsTestUtils.tempPropertiesFile(Collections.singletonMap("group.id", "group-from-file"));
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties", "--consumer.config", propsFile.getAbsolutePath()};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumerOptions(args));
        propsFile = ToolsTestUtils.tempPropertiesFile(Collections.singletonMap("group.id", "test-group"));
        String[] args1 = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--consumer-property", "group.id=test-group", "--consumer.config", propsFile.getAbsolutePath()};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args1);
        Properties props = config.consumerProps();
        Assertions.assertEquals((Object)"test-group", (Object)props.getProperty("group.id"));
        propsFile = ToolsTestUtils.tempPropertiesFile(Collections.singletonMap("group.id", "group-from-file"));
        String[] args2 = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--consumer-property", "group.id=group-from-properties", "--consumer.config", propsFile.getAbsolutePath()};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumerOptions(args2));
        String[] args3 = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer-property", "group.id=group-from-properties"};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumerOptions(args3));
        propsFile = ToolsTestUtils.tempPropertiesFile(Collections.singletonMap("group.id", "group-from-file"));
        String[] args4 = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments", "--consumer.config", propsFile.getAbsolutePath()};
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumerOptions(args4));
        String[] args5 = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "group-from-arguments"};
        config = new ConsoleConsumerOptions(args5);
        props = config.consumerProps();
        Assertions.assertEquals((Object)"group-from-arguments", (Object)props.getProperty("group.id"));
        Exit.resetExitProcedure();
    }

    @Test
    public void testCustomPropertyShouldBePassedToConfigureMethod() throws Exception {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--property", "print.key=true", "--property", "key.deserializer=org.apache.kafka.test.MockDeserializer", "--property", "key.deserializer.my-props=abc"};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args);
        Assertions.assertInstanceOf(DefaultMessageFormatter.class, (Object)config.formatter());
        Assertions.assertTrue((boolean)config.formatterArgs().containsKey("key.deserializer.my-props"));
        DefaultMessageFormatter formatter = (DefaultMessageFormatter)config.formatter();
        Assertions.assertTrue((boolean)formatter.keyDeserializer().isPresent());
        Assertions.assertInstanceOf(MockDeserializer.class, formatter.keyDeserializer().get());
        MockDeserializer keyDeserializer = (MockDeserializer)formatter.keyDeserializer().get();
        Assertions.assertEquals((int)1, (int)keyDeserializer.configs.size());
        Assertions.assertEquals((Object)"abc", keyDeserializer.configs.get("my-props"));
        Assertions.assertTrue((boolean)keyDeserializer.isKey);
    }

    @Test
    public void testCustomConfigShouldBePassedToConfigureMethod() throws Exception {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("key.deserializer.my-props", "abc");
        configs.put("print.key", "false");
        File propsFile = ToolsTestUtils.tempPropertiesFile(configs);
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--property", "print.key=true", "--property", "key.deserializer=org.apache.kafka.test.MockDeserializer", "--formatter-config", propsFile.getAbsolutePath()};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args);
        Assertions.assertInstanceOf(DefaultMessageFormatter.class, (Object)config.formatter());
        Assertions.assertTrue((boolean)config.formatterArgs().containsKey("key.deserializer.my-props"));
        DefaultMessageFormatter formatter = (DefaultMessageFormatter)config.formatter();
        Assertions.assertTrue((boolean)formatter.keyDeserializer().isPresent());
        Assertions.assertInstanceOf(MockDeserializer.class, formatter.keyDeserializer().get());
        MockDeserializer keyDeserializer = (MockDeserializer)formatter.keyDeserializer().get();
        Assertions.assertEquals((int)1, (int)keyDeserializer.configs.size());
        Assertions.assertEquals((Object)"abc", keyDeserializer.configs.get("my-props"));
        Assertions.assertTrue((boolean)keyDeserializer.isKey);
    }

    @Test
    public void shouldParseGroupIdFromBeginningGivenTogether() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--from-beginning"};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg().orElse(""));
        Assertions.assertEquals((long)-2L, (long)config.offsetArg());
        Assertions.assertTrue((boolean)config.fromBeginning());
        args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group"};
        config = new ConsoleConsumerOptions(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.bootstrapServer());
        Assertions.assertEquals((Object)"test", (Object)config.topicArg().orElse(""));
        Assertions.assertEquals((long)-1L, (long)config.offsetArg());
        Assertions.assertFalse((boolean)config.fromBeginning());
    }

    @Test
    public void shouldExitOnGroupIdAndPartitionGivenTogether() {
        Exit.setExitProcedure((code, message) -> {
            throw new IllegalArgumentException(message);
        });
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--group", "test-group", "--partition", "0"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumerOptions(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldExitOnOffsetWithoutPartition() {
        Exit.setExitProcedure((code, message) -> {
            throw new IllegalArgumentException(message);
        });
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--offset", "10"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumerOptions(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldExitIfNoTopicOrFilterSpecified() {
        Exit.setExitProcedure((code, message) -> {
            throw new IllegalArgumentException(message);
        });
        String[] args = new String[]{"--bootstrap-server", "localhost:9092"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumerOptions(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void shouldExitIfTopicAndIncludeSpecified() {
        Exit.setExitProcedure((code, message) -> {
            throw new IllegalArgumentException(message);
        });
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--include", "includeTest*"};
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumerOptions(args));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testClientIdOverride() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning", "--consumer-property", "client.id=consumer-1"};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args);
        Properties consumerProperties = config.consumerProps();
        Assertions.assertEquals((Object)"consumer-1", (Object)consumerProperties.getProperty("client.id"));
    }

    @Test
    public void testDefaultClientId() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--from-beginning"};
        ConsoleConsumerOptions config = new ConsoleConsumerOptions(args);
        Properties consumerProperties = config.consumerProps();
        Assertions.assertEquals((Object)"console-consumer", (Object)consumerProperties.getProperty("client.id"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParseOffset() throws Exception {
        Exit.setExitProcedure((code, message) -> {
            throw new IllegalArgumentException(message);
        });
        try {
            String[] badOffset = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "bad"};
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumerOptions(badOffset));
            String[] negativeOffset = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "-100"};
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleConsumerOptions(negativeOffset));
            String[] earliestOffset = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--offset", "earliest"};
            ConsoleConsumerOptions config = new ConsoleConsumerOptions(earliestOffset);
            Assertions.assertEquals((long)-2L, (long)config.offsetArg());
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testParseTimeoutMs() throws Exception {
        String[] withoutTimeoutMs = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0"};
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)new ConsoleConsumerOptions(withoutTimeoutMs).timeoutMs());
        String[] negativeTimeoutMs = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--timeout-ms", "-100"};
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)new ConsoleConsumerOptions(negativeTimeoutMs).timeoutMs());
        String[] validTimeoutMs = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--timeout-ms", "100"};
        Assertions.assertEquals((long)100L, (long)new ConsoleConsumerOptions(validTimeoutMs).timeoutMs());
    }

    @Test
    public void testParseFormatter() throws Exception {
        String[] defaultMessageFormatter = this.generateArgsForFormatter("org.apache.kafka.tools.consumer.DefaultMessageFormatter");
        Assertions.assertInstanceOf(DefaultMessageFormatter.class, (Object)new ConsoleConsumerOptions(defaultMessageFormatter).formatter());
        String[] loggingMessageFormatter = this.generateArgsForFormatter("org.apache.kafka.tools.consumer.LoggingMessageFormatter");
        Assertions.assertInstanceOf(LoggingMessageFormatter.class, (Object)new ConsoleConsumerOptions(loggingMessageFormatter).formatter());
        String[] noOpMessageFormatter = this.generateArgsForFormatter("org.apache.kafka.tools.consumer.NoOpMessageFormatter");
        Assertions.assertInstanceOf(NoOpMessageFormatter.class, (Object)new ConsoleConsumerOptions(noOpMessageFormatter).formatter());
    }

    private String[] generateArgsForFormatter(String formatter) {
        return new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--partition", "0", "--formatter", formatter};
    }
}

