/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.test.TestUtils;

public class ToolsTestUtils {
    public static String captureStandardOut(Runnable runnable) {
        return ToolsTestUtils.captureStandardStream(false, runnable);
    }

    public static String captureStandardErr(Runnable runnable) {
        return ToolsTestUtils.captureStandardStream(true, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String captureStandardStream(boolean isErr, Runnable runnable) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintStream currentStream = isErr ? System.err : System.out;
        PrintStream tempStream = new PrintStream(outputStream);
        if (isErr) {
            System.setErr(tempStream);
        } else {
            System.setOut(tempStream);
        }
        try {
            runnable.run();
            String string = outputStream.toString().trim();
            return string;
        }
        finally {
            if (isErr) {
                System.setErr(currentStream);
            } else {
                System.setOut(currentStream);
            }
            tempStream.close();
        }
    }

    public static void setReplicationThrottleForPartitions(Admin admin, List<Integer> brokerIds, Set<TopicPartition> partitions, int throttleBytes) throws ExecutionException, InterruptedException {
        ToolsTestUtils.throttleAllBrokersReplication(admin, brokerIds, throttleBytes);
        ToolsTestUtils.assignThrottledPartitionReplicas(admin, partitions.stream().collect(Collectors.toMap(p -> p, p -> brokerIds)));
    }

    public static void throttleAllBrokersReplication(Admin adminClient, List<Integer> brokerIds, int throttleBytes) throws ExecutionException, InterruptedException {
        ArrayList<AlterConfigOp> throttleConfigs = new ArrayList<AlterConfigOp>();
        throttleConfigs.add(new AlterConfigOp(new ConfigEntry("leader.replication.throttled.rate", Integer.toString(throttleBytes)), AlterConfigOp.OpType.SET));
        throttleConfigs.add(new AlterConfigOp(new ConfigEntry("follower.replication.throttled.rate", Integer.toString(throttleBytes)), AlterConfigOp.OpType.SET));
        HashMap<ConfigResource, ArrayList<AlterConfigOp>> configs = new HashMap<ConfigResource, ArrayList<AlterConfigOp>>();
        for (int brokerId : brokerIds) {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(brokerId));
            configs.put(configResource, throttleConfigs);
        }
        adminClient.incrementalAlterConfigs(configs).all().get();
    }

    public static void removeReplicationThrottleForPartitions(Admin admin, List<Integer> brokerIds, Set<TopicPartition> partitions) throws ExecutionException, InterruptedException {
        ToolsTestUtils.removePartitionReplicaThrottles(admin, partitions);
        ToolsTestUtils.resetBrokersThrottle(admin, brokerIds);
    }

    public static void assignThrottledPartitionReplicas(Admin adminClient, Map<TopicPartition, List<Integer>> allReplicasByPartition) throws InterruptedException, ExecutionException {
        Map<ConfigResource, List<Map.Entry>> configResourceToPartitionReplicas = allReplicasByPartition.entrySet().stream().collect(Collectors.groupingBy(topicPartitionListEntry -> new ConfigResource(ConfigResource.Type.TOPIC, ((TopicPartition)topicPartitionListEntry.getKey()).topic())));
        Map<ConfigResource, List> throttles = configResourceToPartitionReplicas.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            ArrayList<AlterConfigOp> alterConfigOps = new ArrayList<AlterConfigOp>();
            Map<TopicPartition, List<Integer>> replicaThrottle = ((List)entry.getValue()).stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            alterConfigOps.add(new AlterConfigOp(new ConfigEntry("leader.replication.throttled.replicas", ToolsTestUtils.formatReplicaThrottles(replicaThrottle)), AlterConfigOp.OpType.SET));
            alterConfigOps.add(new AlterConfigOp(new ConfigEntry("follower.replication.throttled.replicas", ToolsTestUtils.formatReplicaThrottles(replicaThrottle)), AlterConfigOp.OpType.SET));
            return alterConfigOps;
        }));
        adminClient.incrementalAlterConfigs(new HashMap<ConfigResource, List>(throttles)).all().get();
    }

    public static void resetBrokersThrottle(Admin adminClient, List<Integer> brokerIds) throws ExecutionException, InterruptedException {
        ToolsTestUtils.throttleAllBrokersReplication(adminClient, brokerIds, Integer.MAX_VALUE);
    }

    public static void removePartitionReplicaThrottles(Admin adminClient, Set<TopicPartition> partitions) throws ExecutionException, InterruptedException {
        Map<ConfigResource, Collection> throttles = partitions.stream().collect(Collectors.toMap(tp -> new ConfigResource(ConfigResource.Type.TOPIC, tp.topic()), tp -> Arrays.asList(new AlterConfigOp(new ConfigEntry("leader.replication.throttled.replicas", ""), AlterConfigOp.OpType.DELETE), new AlterConfigOp(new ConfigEntry("follower.replication.throttled.replicas", ""), AlterConfigOp.OpType.DELETE))));
        adminClient.incrementalAlterConfigs(throttles).all().get();
    }

    public static String formatReplicaThrottles(Map<TopicPartition, List<Integer>> moves) {
        return moves.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(replicaId -> ((TopicPartition)entry.getKey()).partition() + ":" + replicaId)).collect(Collectors.joining(","));
    }

    public static File tempPropertiesFile(Map<String, String> properties) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue() + System.lineSeparator());
        }
        return TestUtils.tempFile((String)sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String grabConsoleOutput(Runnable f) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(buf);
        PrintStream out0 = System.out;
        System.setOut(out);
        try {
            f.run();
        }
        finally {
            System.setOut(out0);
        }
        out.flush();
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String grabConsoleError(Runnable f) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        PrintStream err = new PrintStream(buf);
        PrintStream err0 = System.err;
        System.setErr(err);
        try {
            f.run();
        }
        finally {
            System.setErr(err0);
        }
        err.flush();
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map.Entry<String, String> grabConsoleOutputAndError(Runnable f) {
        ByteArrayOutputStream outBuf = new ByteArrayOutputStream();
        ByteArrayOutputStream errBuf = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(outBuf);
        PrintStream err = new PrintStream(errBuf);
        PrintStream out0 = System.out;
        PrintStream err0 = System.err;
        System.setOut(out);
        System.setErr(err);
        try {
            f.run();
        }
        finally {
            System.setOut(out0);
            System.setErr(err0);
        }
        out.flush();
        err.flush();
        return new AbstractMap.SimpleImmutableEntry<String, String>(outBuf.toString(), errBuf.toString());
    }

    public static class MockExitProcedure
    implements Exit.Procedure {
        private boolean hasExited = false;
        private int statusCode;

        public void execute(int statusCode, String message) {
            if (!this.hasExited) {
                this.hasExited = true;
                this.statusCode = statusCode;
            }
        }

        public boolean hasExited() {
            return this.hasExited;
        }

        public int statusCode() {
            return this.statusCode;
        }
    }
}

