/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.consumer.internals.AutoOffsetResetStrategy;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.tools.StreamsResetter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=600L)
public class StreamsResetterTest {
    private static final String TOPIC = "topic1";
    private final StreamsResetter streamsResetter = new StreamsResetter();
    private final MockConsumer<byte[], byte[]> consumer = new MockConsumer(AutoOffsetResetStrategy.EARLIEST.name());
    private final TopicPartition topicPartition = new TopicPartition("topic1", 0);
    private final Set<TopicPartition> inputTopicPartitions = new HashSet<TopicPartition>(Collections.singletonList(this.topicPartition));

    @BeforeEach
    public void beforeEach() {
        this.consumer.assign(Collections.singletonList(this.topicPartition));
        this.consumer.addRecord(new ConsumerRecord(TOPIC, 0, 0L, (Object)new byte[0], (Object)new byte[0]));
        this.consumer.addRecord(new ConsumerRecord(TOPIC, 0, 1L, (Object)new byte[0], (Object)new byte[0]));
        this.consumer.addRecord(new ConsumerRecord(TOPIC, 0, 2L, (Object)new byte[0], (Object)new byte[0]));
        this.consumer.addRecord(new ConsumerRecord(TOPIC, 0, 3L, (Object)new byte[0], (Object)new byte[0]));
        this.consumer.addRecord(new ConsumerRecord(TOPIC, 0, 4L, (Object)new byte[0], (Object)new byte[0]));
    }

    @Test
    public void testResetToSpecificOffsetWhenBetweenBeginningAndEndOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 4L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.streamsResetter.resetOffsetsTo(this.consumer, this.inputTopicPartitions, Long.valueOf(2L));
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assertions.assertEquals((int)3, (int)records.count());
    }

    @Test
    public void testResetOffsetToSpecificOffsetWhenAfterEndOffset() {
        long beginningOffset = 5L;
        long endOffset = 10L;
        MockConsumer emptyConsumer = new MockConsumer(AutoOffsetResetStrategy.EARLIEST.name());
        emptyConsumer.assign(Collections.singletonList(this.topicPartition));
        HashMap<TopicPartition, Long> beginningOffsetsMap = new HashMap<TopicPartition, Long>();
        beginningOffsetsMap.put(this.topicPartition, 5L);
        emptyConsumer.updateBeginningOffsets(beginningOffsetsMap);
        HashMap<TopicPartition, Long> endOffsetsMap = new HashMap<TopicPartition, Long>();
        endOffsetsMap.put(this.topicPartition, 10L);
        emptyConsumer.updateEndOffsets(endOffsetsMap);
        this.streamsResetter.resetOffsetsTo((Consumer)emptyConsumer, this.inputTopicPartitions, Long.valueOf(12L));
        long position = emptyConsumer.position(this.topicPartition);
        Assertions.assertEquals((long)10L, (long)position);
    }

    @Test
    public void testResetToSpecificOffsetWhenBeforeBeginningOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 4L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 3L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.streamsResetter.resetOffsetsTo(this.consumer, this.inputTopicPartitions, Long.valueOf(2L));
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assertions.assertEquals((int)2, (int)records.count());
    }

    @Test
    public void testResetToSpecificOffsetWhenAfterEndOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 3L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.streamsResetter.resetOffsetsTo(this.consumer, this.inputTopicPartitions, Long.valueOf(4L));
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assertions.assertEquals((int)2, (int)records.count());
    }

    @Test
    public void testShiftOffsetByWhenBetweenBeginningAndEndOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 4L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.streamsResetter.shiftOffsetsBy(this.consumer, this.inputTopicPartitions, 3L);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assertions.assertEquals((int)2, (int)records.count());
    }

    @Test
    public void testShiftOffsetByWhenBeforeBeginningOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 4L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.streamsResetter.shiftOffsetsBy(this.consumer, this.inputTopicPartitions, -3L);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assertions.assertEquals((int)5, (int)records.count());
    }

    @Test
    public void testShiftOffsetByWhenAfterEndOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 3L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        this.streamsResetter.shiftOffsetsBy(this.consumer, this.inputTopicPartitions, 5L);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assertions.assertEquals((int)2, (int)records.count());
    }

    @Test
    public void testResetUsingPlanWhenBetweenBeginningAndEndOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 4L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        HashMap<TopicPartition, Long> topicPartitionsAndOffset = new HashMap<TopicPartition, Long>();
        topicPartitionsAndOffset.put(this.topicPartition, 3L);
        this.streamsResetter.resetOffsetsFromResetPlan(this.consumer, this.inputTopicPartitions, topicPartitionsAndOffset);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assertions.assertEquals((int)2, (int)records.count());
    }

    @Test
    public void testResetUsingPlanWhenBeforeBeginningOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 4L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 3L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        HashMap<TopicPartition, Long> topicPartitionsAndOffset = new HashMap<TopicPartition, Long>();
        topicPartitionsAndOffset.put(this.topicPartition, 1L);
        this.streamsResetter.resetOffsetsFromResetPlan(this.consumer, this.inputTopicPartitions, topicPartitionsAndOffset);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assertions.assertEquals((int)2, (int)records.count());
    }

    @Test
    public void testResetUsingPlanWhenAfterEndOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 3L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        HashMap<TopicPartition, Long> topicPartitionsAndOffset = new HashMap<TopicPartition, Long>();
        topicPartitionsAndOffset.put(this.topicPartition, 5L);
        this.streamsResetter.resetOffsetsFromResetPlan(this.consumer, this.inputTopicPartitions, topicPartitionsAndOffset);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assertions.assertEquals((int)2, (int)records.count());
    }

    @Test
    public void shouldSeekToEndOffset() {
        HashMap<TopicPartition, Long> endOffsets = new HashMap<TopicPartition, Long>();
        endOffsets.put(this.topicPartition, 3L);
        this.consumer.updateEndOffsets(endOffsets);
        HashMap<TopicPartition, Long> beginningOffsets = new HashMap<TopicPartition, Long>();
        beginningOffsets.put(this.topicPartition, 0L);
        this.consumer.updateBeginningOffsets(beginningOffsets);
        HashSet<TopicPartition> intermediateTopicPartitions = new HashSet<TopicPartition>();
        intermediateTopicPartitions.add(this.topicPartition);
        this.streamsResetter.maybeSeekToEnd("g1", this.consumer, intermediateTopicPartitions);
        ConsumerRecords records = this.consumer.poll(Duration.ofMillis(500L));
        Assertions.assertEquals((int)2, (int)records.count());
    }

    @Test
    public void shouldDeleteTopic() throws InterruptedException, ExecutionException {
        Cluster cluster = this.createCluster(1);
        try (MockAdminClient adminClient = new MockAdminClient(cluster.nodes(), cluster.nodeById(0));){
            TopicPartitionInfo topicPartitionInfo = new TopicPartitionInfo(0, cluster.nodeById(0), cluster.nodes(), Collections.emptyList());
            adminClient.addTopic(false, TOPIC, Collections.singletonList(topicPartitionInfo), null);
            this.streamsResetter.doDelete(Collections.singletonList(TOPIC), (Admin)adminClient);
            Assertions.assertEquals(Collections.emptySet(), (Object)adminClient.listTopics().names().get());
        }
    }

    @Test
    public void shouldDetermineInternalTopicBasedOnTopicName1() {
        Assertions.assertTrue((boolean)StreamsResetter.matchesInternalTopicFormat((String)"appId-named-subscription-response-topic"));
        Assertions.assertTrue((boolean)StreamsResetter.matchesInternalTopicFormat((String)"appId-named-subscription-registration-topic"));
        Assertions.assertTrue((boolean)StreamsResetter.matchesInternalTopicFormat((String)"appId-KTABLE-FK-JOIN-SUBSCRIPTION-RESPONSE-12323232-topic"));
        Assertions.assertTrue((boolean)StreamsResetter.matchesInternalTopicFormat((String)"appId-KTABLE-FK-JOIN-SUBSCRIPTION-REGISTRATION-12323232-topic"));
    }

    @Test
    public void testResetToDatetimeWhenPartitionIsEmptyResetsToLatestOffset() {
        long beginningAndEndOffset = 5L;
        EmptyPartitionConsumer emptyConsumer = new EmptyPartitionConsumer(AutoOffsetResetStrategy.EARLIEST.name());
        emptyConsumer.assign(Collections.singletonList(this.topicPartition));
        HashMap<TopicPartition, Long> beginningOffsetsMap = new HashMap<TopicPartition, Long>();
        beginningOffsetsMap.put(this.topicPartition, 5L);
        emptyConsumer.updateBeginningOffsets(beginningOffsetsMap);
        HashMap<TopicPartition, Long> endOffsetsMap = new HashMap<TopicPartition, Long>();
        endOffsetsMap.put(this.topicPartition, 5L);
        emptyConsumer.updateEndOffsets(endOffsetsMap);
        long yesterdayTimestamp = Instant.now().minus(Duration.ofDays(1L)).toEpochMilli();
        this.streamsResetter.resetToDatetime(emptyConsumer, this.inputTopicPartitions, Long.valueOf(yesterdayTimestamp));
        long position = emptyConsumer.position(this.topicPartition);
        Assertions.assertEquals((long)5L, (long)position);
    }

    private Cluster createCluster(int numNodes) {
        HashMap<Integer, Node> nodes = new HashMap<Integer, Node>();
        for (int i = 0; i < numNodes; ++i) {
            nodes.put(i, new Node(i, "localhost", 8121 + i));
        }
        return new Cluster("mockClusterId", nodes.values(), Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), (Node)nodes.get(0));
    }

    private static class EmptyPartitionConsumer<K, V>
    extends MockConsumer<K, V> {
        public EmptyPartitionConsumer(String offsetResetStrategy) {
            super(offsetResetStrategy);
        }

        public synchronized Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map<TopicPartition, Long> timestampsToSearch) {
            HashMap<TopicPartition, OffsetAndTimestamp> topicPartitionToOffsetAndTimestamp = new HashMap<TopicPartition, OffsetAndTimestamp>();
            timestampsToSearch.keySet().forEach(k -> topicPartitionToOffsetAndTimestamp.put((TopicPartition)k, (OffsetAndTimestamp)null));
            return topicPartitionToOffsetAndTimestamp;
        }
    }
}

