/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.tools.ShareConsumerPerformance;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ShareConsumerPerformanceTest {
    private final ToolsTestUtils.MockExitProcedure exitProcedure = new ToolsTestUtils.MockExitProcedure();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
    @TempDir
    static Path tempDir;

    @BeforeEach
    public void beforeEach() {
        Exit.setExitProcedure((Exit.Procedure)this.exitProcedure);
    }

    @AfterEach
    public void afterEach() {
        Exit.resetExitProcedure();
    }

    @Test
    public void testHeaderMatchBody() {
        this.testHeaderMatchContent(2, () -> ShareConsumerPerformance.printShareConsumerProgress((long)0x100000L, (long)0L, (long)1L, (long)0L, (long)0L, (long)1L, (SimpleDateFormat)this.dateFormat, (int)1));
    }

    @Test
    public void testConfigBootStrapServer() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--messages", "10", "--print-metrics"};
        ShareConsumerPerformance.ShareConsumerPerfOptions config = new ShareConsumerPerformance.ShareConsumerPerfOptions(args);
        Assertions.assertEquals((Object)"localhost:9092", (Object)config.brokerHostsAndPorts());
        Assertions.assertTrue((boolean)config.topic().contains("test"));
        Assertions.assertEquals((long)10L, (long)config.numMessages());
    }

    @Test
    public void testConfigWithUnrecognizedOption() {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--messages", "10", "--new-share-consumer"};
        String err = ToolsTestUtils.captureStandardErr(() -> new ShareConsumerPerformance.ShareConsumerPerfOptions(args));
        Assertions.assertTrue((boolean)err.contains("new-share-consumer is not a recognized option"));
    }

    @Test
    public void testClientIdOverride() throws IOException {
        File tempFile = Files.createFile(tempDir.resolve("test_share_consumer_config.conf"), new FileAttribute[0]).toFile();
        try (PrintWriter output = new PrintWriter(Files.newOutputStream(tempFile.toPath(), new OpenOption[0]));){
            output.println("client.id=share-consumer-1");
            output.flush();
        }
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--messages", "10", "--consumer.config", tempFile.getAbsolutePath()};
        ShareConsumerPerformance.ShareConsumerPerfOptions config = new ShareConsumerPerformance.ShareConsumerPerfOptions(args);
        Assertions.assertEquals((Object)"share-consumer-1", (Object)config.props().getProperty("client.id"));
    }

    @Test
    public void testDefaultClientId() throws IOException {
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--messages", "10"};
        ShareConsumerPerformance.ShareConsumerPerfOptions config = new ShareConsumerPerformance.ShareConsumerPerfOptions(args);
        Assertions.assertEquals((Object)"perf-share-consumer-client", (Object)config.props().getProperty("client.id"));
    }

    private void testHeaderMatchContent(int expectedOutputLineCount, Runnable runnable) {
        String out = ToolsTestUtils.captureStandardOut(() -> {
            ShareConsumerPerformance.printHeader();
            runnable.run();
        });
        String[] contents = out.split("\n");
        Assertions.assertEquals((int)expectedOutputLineCount, (int)contents.length);
        String header = contents[0];
        String body = contents[1];
        Assertions.assertEquals((int)header.split(",\\s").length, (int)body.split(",\\s").length);
    }
}

