/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.SplittableRandom;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.tools.ProducerPerformance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.STRICT_STUBS)
public class ProducerPerformanceTest {
    @Mock
    KafkaProducer<byte[], byte[]> producerMock;
    @Spy
    ProducerPerformance producerPerformanceSpy;

    private File createTempFile(String contents) throws IOException {
        File file = File.createTempFile("ProducerPerformanceTest", ".tmp");
        file.deleteOnExit();
        Files.write(file.toPath(), contents.getBytes(), new OpenOption[0]);
        return file;
    }

    @Test
    public void testReadPayloadFile() throws Exception {
        File payloadFile = this.createTempFile("Hello\nKafka");
        String payloadFilePath = payloadFile.getAbsolutePath();
        String payloadDelimiter = "\n";
        List payloadByteList = ProducerPerformance.readPayloadFile((String)payloadFilePath, (String)payloadDelimiter);
        Assertions.assertEquals((int)2, (int)payloadByteList.size());
        Assertions.assertEquals((Object)"Hello", (Object)new String((byte[])payloadByteList.get(0)));
        Assertions.assertEquals((Object)"Kafka", (Object)new String((byte[])payloadByteList.get(1)));
        Utils.delete((File)payloadFile);
    }

    @Test
    public void testReadProps() throws Exception {
        List<String> producerProps = Collections.singletonList("bootstrap.servers=localhost:9000");
        File producerConfig = this.createTempFile("acks=1");
        Properties prop = ProducerPerformance.readProps(producerProps, (String)producerConfig.getAbsolutePath());
        Assertions.assertNotNull((Object)prop);
        Assertions.assertEquals((int)5, (int)prop.size());
        Utils.delete((File)producerConfig);
    }

    @Test
    public void testReadPayloadFileWithAlternateDelimiters() throws Exception {
        List<byte[]> payloadByteList = this.generateListFromFileUsingDelimiter("Hello~~Kafka", "~~");
        Assertions.assertEquals((int)2, (int)payloadByteList.size());
        Assertions.assertEquals((Object)"Hello", (Object)new String(payloadByteList.get(0)));
        Assertions.assertEquals((Object)"Kafka", (Object)new String(payloadByteList.get(1)));
        payloadByteList = this.generateListFromFileUsingDelimiter("Hello,Kafka,", ",");
        Assertions.assertEquals((int)2, (int)payloadByteList.size());
        Assertions.assertEquals((Object)"Hello", (Object)new String(payloadByteList.get(0)));
        Assertions.assertEquals((Object)"Kafka", (Object)new String(payloadByteList.get(1)));
        payloadByteList = this.generateListFromFileUsingDelimiter("Hello\t\tKafka", "\t");
        Assertions.assertEquals((int)3, (int)payloadByteList.size());
        Assertions.assertEquals((Object)"Hello", (Object)new String(payloadByteList.get(0)));
        Assertions.assertEquals((Object)"Kafka", (Object)new String(payloadByteList.get(2)));
        payloadByteList = this.generateListFromFileUsingDelimiter("Hello\n\nKafka\n", "\n");
        Assertions.assertEquals((int)3, (int)payloadByteList.size());
        Assertions.assertEquals((Object)"Hello", (Object)new String(payloadByteList.get(0)));
        Assertions.assertEquals((Object)"Kafka", (Object)new String(payloadByteList.get(2)));
        payloadByteList = this.generateListFromFileUsingDelimiter("Hello::Kafka::World", "\\s*::\\s*");
        Assertions.assertEquals((int)3, (int)payloadByteList.size());
        Assertions.assertEquals((Object)"Hello", (Object)new String(payloadByteList.get(0)));
        Assertions.assertEquals((Object)"Kafka", (Object)new String(payloadByteList.get(1)));
    }

    @Test
    public void testCompareStringSplitWithScannerDelimiter() throws Exception {
        String contents = "Hello~~Kafka";
        String payloadDelimiter = "~~";
        this.compareList(this.generateListFromFileUsingDelimiter(contents, payloadDelimiter), contents.split(payloadDelimiter));
        contents = "Hello,Kafka,";
        payloadDelimiter = ",";
        this.compareList(this.generateListFromFileUsingDelimiter(contents, payloadDelimiter), contents.split(payloadDelimiter));
        contents = "Hello\t\tKafka";
        payloadDelimiter = "\t";
        this.compareList(this.generateListFromFileUsingDelimiter(contents, payloadDelimiter), contents.split(payloadDelimiter));
        contents = "Hello\n\nKafka\n";
        payloadDelimiter = "\n";
        this.compareList(this.generateListFromFileUsingDelimiter(contents, payloadDelimiter), contents.split(payloadDelimiter));
        contents = "Hello::Kafka::World";
        payloadDelimiter = "\\s*::\\s*";
        this.compareList(this.generateListFromFileUsingDelimiter(contents, payloadDelimiter), contents.split(payloadDelimiter));
    }

    private void compareList(List<byte[]> payloadByteList, String[] payloadByteListFromSplit) {
        Assertions.assertEquals((int)payloadByteListFromSplit.length, (int)payloadByteList.size());
        for (int i = 0; i < payloadByteListFromSplit.length; ++i) {
            Assertions.assertEquals((Object)payloadByteListFromSplit[i], (Object)new String(payloadByteList.get(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<byte[]> generateListFromFileUsingDelimiter(String fileContent, String payloadDelimiter) throws Exception {
        List payloadByteList;
        File payloadFile = null;
        try {
            payloadFile = this.createTempFile(fileContent);
            payloadByteList = ProducerPerformance.readPayloadFile((String)payloadFile.getAbsolutePath(), (String)payloadDelimiter);
        }
        finally {
            Utils.delete((File)payloadFile);
        }
        return payloadByteList;
    }

    @Test
    public void testNumberOfCallsForSendAndClose() throws IOException {
        ((KafkaProducer)Mockito.doReturn(null).when(this.producerMock)).send((ProducerRecord)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
        ((ProducerPerformance)Mockito.doReturn(this.producerMock).when((Object)this.producerPerformanceSpy)).createKafkaProducer((Properties)ArgumentMatchers.any(Properties.class));
        String[] args = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100", "--producer-props", "bootstrap.servers=localhost:9000"};
        this.producerPerformanceSpy.start(args);
        ((KafkaProducer)Mockito.verify(this.producerMock, (VerificationMode)Mockito.times((int)5))).send((ProducerRecord)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
        ((KafkaProducer)Mockito.verify(this.producerMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testEnableTransaction() throws IOException {
        ((KafkaProducer)Mockito.doReturn(null).when(this.producerMock)).send((ProducerRecord)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
        ((ProducerPerformance)Mockito.doReturn(this.producerMock).when((Object)this.producerPerformanceSpy)).createKafkaProducer((Properties)ArgumentMatchers.any(Properties.class));
        String[] args = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100", "--transactional-id", "foobar", "--producer-props", "bootstrap.servers=localhost:9000"};
        this.producerPerformanceSpy.start(args);
        ((KafkaProducer)Mockito.verify(this.producerMock, (VerificationMode)Mockito.times((int)1))).beginTransaction();
        ((KafkaProducer)Mockito.verify(this.producerMock, (VerificationMode)Mockito.times((int)1))).commitTransaction();
        ((KafkaProducer)Mockito.verify(this.producerMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testNumberOfSuccessfulSendAndClose() throws IOException {
        ((ProducerPerformance)Mockito.doReturn(this.producerMock).when((Object)this.producerPerformanceSpy)).createKafkaProducer((Properties)ArgumentMatchers.any(Properties.class));
        ((KafkaProducer)Mockito.doAnswer(invocation -> {
            this.producerPerformanceSpy.cb.onCompletion(null, null);
            return null;
        }).when(this.producerMock)).send((ProducerRecord)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
        String[] args = new String[]{"--topic", "Hello-Kafka", "--num-records", "10", "--throughput", "1", "--record-size", "100", "--producer-props", "bootstrap.servers=localhost:9000"};
        this.producerPerformanceSpy.start(args);
        ((KafkaProducer)Mockito.verify(this.producerMock, (VerificationMode)Mockito.times((int)10))).send((ProducerRecord)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
        Assertions.assertEquals((long)10L, (long)this.producerPerformanceSpy.stats.totalCount());
        ((KafkaProducer)Mockito.verify(this.producerMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testNumberOfFailedSendAndClose() throws IOException {
        ((ProducerPerformance)Mockito.doReturn(this.producerMock).when((Object)this.producerPerformanceSpy)).createKafkaProducer((Properties)ArgumentMatchers.any(Properties.class));
        ((KafkaProducer)Mockito.doAnswer(invocation -> {
            this.producerPerformanceSpy.cb.onCompletion(null, (Exception)new AuthorizationException("not authorized."));
            return null;
        }).when(this.producerMock)).send((ProducerRecord)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
        String[] args = new String[]{"--topic", "Hello-Kafka", "--num-records", "10", "--throughput", "1", "--record-size", "100", "--producer-props", "bootstrap.servers=localhost:9000"};
        this.producerPerformanceSpy.start(args);
        ((KafkaProducer)Mockito.verify(this.producerMock, (VerificationMode)Mockito.times((int)10))).send((ProducerRecord)ArgumentMatchers.any(), (Callback)ArgumentMatchers.any());
        Assertions.assertEquals((long)0L, (long)this.producerPerformanceSpy.stats.currentWindowCount());
        Assertions.assertEquals((long)0L, (long)this.producerPerformanceSpy.stats.totalCount());
        ((KafkaProducer)Mockito.verify(this.producerMock, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testMutuallyExclusiveGroup() {
        String[] args1 = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100", "--payload-monotonic", "--producer-props", "bootstrap.servers=localhost:9000"};
        ArgumentParser parser1 = ProducerPerformance.argParser();
        ArgumentParserException thrown = (ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> parser1.parseArgs(args1));
        Assertions.assertEquals((Object)"argument --payload-monotonic: not allowed with argument --record-size", (Object)thrown.getMessage());
        String[] args2 = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--payload-file", "abc.txt", "--payload-monotonic", "--producer-props", "bootstrap.servers=localhost:9000"};
        ArgumentParser parser2 = ProducerPerformance.argParser();
        thrown = (ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> parser2.parseArgs(args2));
        Assertions.assertEquals((Object)"argument --payload-monotonic: not allowed with argument --payload-file", (Object)thrown.getMessage());
    }

    @Test
    public void testUnexpectedArg() {
        String[] args = new String[]{"--test", "test", "--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100", "--producer-props", "bootstrap.servers=localhost:9000"};
        ArgumentParser parser = ProducerPerformance.argParser();
        ArgumentParserException thrown = (ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> parser.parseArgs(args));
        Assertions.assertEquals((Object)"unrecognized arguments: '--test'", (Object)thrown.getMessage());
    }

    @Test
    public void testFractionalThroughput() {
        String[] args = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "1.25", "--record-size", "100", "--producer-props", "bootstrap.servers=localhost:9000"};
        ArgumentParser parser = ProducerPerformance.argParser();
        Assertions.assertDoesNotThrow(() -> parser.parseArgs(args));
    }

    @Test
    public void testGenerateRandomPayloadByPayloadFile() {
        Integer recordSize = null;
        String inputString = "Hello Kafka";
        byte[] byteArray = inputString.getBytes(StandardCharsets.UTF_8);
        ArrayList<byte[]> payloadByteList = new ArrayList<byte[]>();
        payloadByteList.add(byteArray);
        byte[] payload = null;
        SplittableRandom random = new SplittableRandom(0L);
        payload = ProducerPerformance.generateRandomPayload(recordSize, payloadByteList, payload, (SplittableRandom)random, (boolean)false, (long)0L);
        Assertions.assertEquals((Object)inputString, (Object)new String(payload));
    }

    @Test
    public void testGenerateRandomPayloadByRecordSize() {
        Integer recordSize = 100;
        byte[] payload = new byte[recordSize.intValue()];
        ArrayList payloadByteList = new ArrayList();
        SplittableRandom random = new SplittableRandom(0L);
        for (byte b : payload = ProducerPerformance.generateRandomPayload((Integer)recordSize, payloadByteList, (byte[])payload, (SplittableRandom)random, (boolean)false, (long)0L)) {
            Assertions.assertNotEquals((int)0, (int)b);
        }
    }

    @Test
    public void testGenerateMonotonicPayload() {
        byte[] payload = null;
        ArrayList payloadByteList = new ArrayList();
        SplittableRandom random = new SplittableRandom(0L);
        for (int i = 0; i < 10; ++i) {
            payload = ProducerPerformance.generateRandomPayload(null, payloadByteList, payload, (SplittableRandom)random, (boolean)true, (long)i);
            Assertions.assertEquals((int)1, (int)payload.length);
            Assertions.assertEquals((int)(i + 48), (int)payload[0]);
        }
    }

    @Test
    public void testGenerateRandomPayloadException() {
        Integer recordSize = null;
        byte[] payload = null;
        ArrayList payloadByteList = new ArrayList();
        SplittableRandom random = new SplittableRandom(0L);
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ProducerPerformance.generateRandomPayload((Integer)recordSize, (List)payloadByteList, (byte[])payload, (SplittableRandom)random, (boolean)false, (long)0L));
        Assertions.assertEquals((Object)"no payload File Path or record Size or payload-monotonic option provided", (Object)thrown.getMessage());
    }

    @Test
    public void testClientIdOverride() throws Exception {
        List<String> producerProps = Collections.singletonList("client.id=producer-1");
        Properties prop = ProducerPerformance.readProps(producerProps, null);
        Assertions.assertNotNull((Object)prop);
        Assertions.assertEquals((Object)"producer-1", (Object)prop.getProperty("client.id"));
    }

    @Test
    public void testDefaultClientId() throws Exception {
        List<String> producerProps = Collections.singletonList("acks=1");
        Properties prop = ProducerPerformance.readProps(producerProps, null);
        Assertions.assertNotNull((Object)prop);
        Assertions.assertEquals((Object)"perf-producer-client", (Object)prop.getProperty("client.id"));
    }

    @Test
    public void testStatsInitializationWithLargeNumRecords() {
        long numRecords = Long.MAX_VALUE;
        Assertions.assertDoesNotThrow(() -> new ProducerPerformance.Stats(numRecords, 5000));
    }

    @Test
    public void testStatsCorrectness() throws Exception {
        ExecutorService singleThreaded = Executors.newSingleThreadExecutor();
        long numRecords = 1000000L;
        ProducerPerformance.Stats stats = new ProducerPerformance.Stats(1000000L, 5000);
        for (long i = 0L; i < 1000000L; ++i) {
            ProducerPerformance.PerfCallback callback = new ProducerPerformance.PerfCallback(0L, 100, stats);
            CompletableFuture.runAsync(() -> ProducerPerformanceTest.lambda$testStatsCorrectness$8((Callback)callback), singleThreaded);
        }
        singleThreaded.shutdown();
        boolean success = singleThreaded.awaitTermination(60L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)success, (String)"should have terminated");
        Assertions.assertEquals((long)1000000L, (long)stats.totalCount());
        Assertions.assertEquals((long)1000000L, (long)stats.iteration());
        Assertions.assertEquals((int)500000, (int)stats.index());
        Assertions.assertEquals((long)100000000L, (long)stats.bytes());
    }

    @Test
    public void testConfigPostProcessor() throws IOException, ArgumentParserException {
        ArgumentParser parser = ProducerPerformance.argParser();
        String[] args = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100", "--print-metrics", "--producer-props", "bootstrap.servers=localhost:9000", "--transactional-id", "foobar", "--transaction-duration-ms", "5000"};
        ProducerPerformance.ConfigPostProcessor configs = new ProducerPerformance.ConfigPostProcessor(parser, args);
        Assertions.assertEquals((Object)"Hello-Kafka", (Object)configs.topicName);
        Assertions.assertEquals((long)5L, (Long)configs.numRecords);
        Assertions.assertEquals((double)100.0, (double)configs.throughput);
        Assertions.assertEquals((int)100, (Integer)configs.recordSize);
        Assertions.assertFalse((boolean)configs.payloadMonotonic);
        Assertions.assertTrue((boolean)configs.shouldPrintMetrics);
        Assertions.assertTrue((boolean)configs.payloadByteList.isEmpty());
        Properties props = configs.producerProps;
        Assertions.assertEquals((int)5, (int)props.size());
        Assertions.assertTrue((boolean)configs.transactionsEnabled);
        Assertions.assertEquals((long)5000L, (Long)configs.transactionDurationMs);
    }

    @Test
    public void testInvalidConfigPostProcessor() {
        ArgumentParser parser = ProducerPerformance.argParser();
        String[] invalidProducerProps = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100"};
        Assertions.assertEquals((Object)"Either --producer-props or --producer.config must be specified.", (Object)((ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> new ProducerPerformance.ConfigPostProcessor(parser, invalidProducerProps))).getMessage());
        String[] invalidTransactionDurationMs = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100", "--producer-props", "bootstrap.servers=localhost:9000", "--transaction-duration-ms", "0"};
        Assertions.assertEquals((Object)"--transaction-duration-ms should be greater than zero", (Object)((ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> new ProducerPerformance.ConfigPostProcessor(parser, invalidTransactionDurationMs))).getMessage());
        String[] invalidNumRecords = new String[]{"--topic", "Hello-Kafka", "--num-records", "-5", "--throughput", "100", "--record-size", "100", "--producer-props", "bootstrap.servers=localhost:9000"};
        Assertions.assertEquals((Object)"--num-records should be greater than zero", (Object)((ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> new ProducerPerformance.ConfigPostProcessor(parser, invalidNumRecords))).getMessage());
        String[] invalidRecordSize = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "-100", "--producer-props", "bootstrap.servers=localhost:9000"};
        Assertions.assertEquals((Object)"--record-size should be greater than zero", (Object)((ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> new ProducerPerformance.ConfigPostProcessor(parser, invalidRecordSize))).getMessage());
    }

    @Test
    public void testNoTransactionRelatedConfigs() throws IOException, ArgumentParserException {
        ArgumentParser parser = ProducerPerformance.argParser();
        String[] args = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100", "--producer-props", "bootstrap.servers=localhost:9000"};
        ProducerPerformance.ConfigPostProcessor configs = new ProducerPerformance.ConfigPostProcessor(parser, args);
        Assertions.assertFalse((boolean)configs.transactionsEnabled);
        Assertions.assertNull((Object)configs.transactionDurationMs);
        Assertions.assertFalse((boolean)configs.producerProps.contains("transactional.id"));
    }

    @Test
    public void testEnableTransactionByProducerProps() throws IOException, ArgumentParserException {
        ArgumentParser parser = ProducerPerformance.argParser();
        String[] args = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100", "--producer-props", "bootstrap.servers=localhost:9000", "transactional.id=foobar"};
        ProducerPerformance.ConfigPostProcessor configs = new ProducerPerformance.ConfigPostProcessor(parser, args);
        Assertions.assertTrue((boolean)configs.transactionsEnabled);
        Assertions.assertEquals((long)3000L, (Long)configs.transactionDurationMs);
        Assertions.assertEquals((Object)"foobar", (Object)configs.producerProps.get("transactional.id"));
    }

    @Test
    public void testEnableTransactionByTransactionId() throws IOException, ArgumentParserException {
        File producerConfigFile = this.createTempFile("transactional.id=foobar");
        ArgumentParser parser = ProducerPerformance.argParser();
        String[] args = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100", "--producer.config", producerConfigFile.getAbsolutePath(), "--producer-props", "bootstrap.servers=localhost:9000"};
        ProducerPerformance.ConfigPostProcessor configs = new ProducerPerformance.ConfigPostProcessor(parser, args);
        Assertions.assertTrue((boolean)configs.transactionsEnabled);
        Assertions.assertEquals((long)3000L, (Long)configs.transactionDurationMs);
        Assertions.assertEquals((Object)"foobar", (Object)configs.producerProps.get("transactional.id"));
        args = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100", "--producer.config", producerConfigFile.getAbsolutePath(), "--producer-props", "bootstrap.servers=localhost:9000", "transactional.id=hello_kafka"};
        configs = new ProducerPerformance.ConfigPostProcessor(parser, args);
        Assertions.assertTrue((boolean)configs.transactionsEnabled);
        Assertions.assertEquals((long)3000L, (Long)configs.transactionDurationMs);
        Assertions.assertEquals((Object)"hello_kafka", (Object)configs.producerProps.get("transactional.id"));
        args = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100", "--transactional-id", "kafka_hello", "--producer.config", producerConfigFile.getAbsolutePath(), "--producer-props", "bootstrap.servers=localhost:9000", "transactional.id=hello_kafka"};
        configs = new ProducerPerformance.ConfigPostProcessor(parser, args);
        Assertions.assertTrue((boolean)configs.transactionsEnabled);
        Assertions.assertEquals((long)3000L, (Long)configs.transactionDurationMs);
        Assertions.assertEquals((Object)"kafka_hello", (Object)configs.producerProps.get("transactional.id"));
        Utils.delete((File)producerConfigFile);
    }

    @Test
    public void testEnableTransactionByTransactionDurationMs() throws IOException, ArgumentParserException {
        ArgumentParser parser = ProducerPerformance.argParser();
        String[] args = new String[]{"--topic", "Hello-Kafka", "--num-records", "5", "--throughput", "100", "--record-size", "100", "--transaction-duration-ms", "5000", "--producer-props", "bootstrap.servers=localhost:9000"};
        ProducerPerformance.ConfigPostProcessor configs = new ProducerPerformance.ConfigPostProcessor(parser, args);
        Assertions.assertTrue((boolean)configs.transactionsEnabled);
        Assertions.assertEquals((long)5000L, (Long)configs.transactionDurationMs);
        Assertions.assertTrue((boolean)configs.producerProps.get("transactional.id").toString().startsWith("performance-producer-"));
    }

    private static /* synthetic */ void lambda$testStatsCorrectness$8(Callback callback) {
        callback.onCompletion(null, null);
    }
}

