/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.kafka.clients.admin.RaftVoterEndpoint;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tools.MetadataQuorumCommand;
import org.apache.kafka.tools.TerseException;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MetadataQuorumCommandUnitTest {
    @Test
    public void testRemoveControllerDryRun() {
        List<String> outputs = Arrays.asList(ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)0, (int)MetadataQuorumCommand.mainNoExit((String[])new String[]{"--bootstrap-server", "localhost:9092", "remove-controller", "--controller-id", "2", "--controller-directory-id", "_KWDkTahTVaiVVVTaugNew", "--dry-run"}))).split("\n"));
        Assertions.assertTrue((boolean)outputs.contains("DRY RUN of removing  KRaft controller 2 with directory id _KWDkTahTVaiVVVTaugNew"), (String)("Failed to find expected output in stdout: " + String.valueOf(outputs)));
    }

    @Test
    public void testGetControllerIdWithoutId() {
        Properties props = new Properties();
        props.setProperty("process.roles", "controller");
        Assertions.assertEquals((Object)"node.id not found in configuration file. Is this a valid controller configuration file?", (Object)((TerseException)Assertions.assertThrows(TerseException.class, () -> Assertions.assertEquals((int)4, (int)MetadataQuorumCommand.getControllerId((Properties)props)))).getMessage());
    }

    @Test
    public void testGetControllerId() throws Exception {
        Properties props = new Properties();
        props.setProperty("node.id", "4");
        props.setProperty("process.roles", "controller");
        Assertions.assertEquals((int)4, (int)MetadataQuorumCommand.getControllerId((Properties)props));
    }

    @Test
    public void testGetNegativeControllerId() {
        Properties props = new Properties();
        props.setProperty("node.id", "-4");
        props.setProperty("process.roles", "controller");
        Assertions.assertEquals((Object)"node.id was negative in configuration file. Is this a valid controller configuration file?", (Object)((TerseException)Assertions.assertThrows(TerseException.class, () -> Assertions.assertEquals((int)4, (int)MetadataQuorumCommand.getControllerId((Properties)props)))).getMessage());
    }

    @Test
    public void testGetControllerIdWithoutProcessRoles() {
        Properties props = new Properties();
        props.setProperty("node.id", "4");
        Assertions.assertEquals((Object)"process.roles did not contain 'controller' in configuration file. Is this a valid controller configuration file?", (Object)((TerseException)Assertions.assertThrows(TerseException.class, () -> Assertions.assertEquals((int)4, (int)MetadataQuorumCommand.getControllerId((Properties)props)))).getMessage());
    }

    @Test
    public void testGetControllerIdWithBrokerProcessRoles() {
        Properties props = new Properties();
        props.setProperty("node.id", "4");
        props.setProperty("process.roles", "broker");
        Assertions.assertEquals((Object)"process.roles did not contain 'controller' in configuration file. Is this a valid controller configuration file?", (Object)((TerseException)Assertions.assertThrows(TerseException.class, () -> Assertions.assertEquals((int)4, (int)MetadataQuorumCommand.getControllerId((Properties)props)))).getMessage());
    }

    @Test
    public void testGetMetadataDirectory() throws Exception {
        Properties props = new Properties();
        props.setProperty("metadata.log.dir", "/tmp/meta");
        props.setProperty("log.dirs", "/tmp/log,/tmp/log2");
        Assertions.assertEquals((Object)"/tmp/meta", (Object)MetadataQuorumCommand.getMetadataDirectory((Properties)props));
    }

    @Test
    public void testGetMetadataDirectoryFromLogDirs() throws Exception {
        Properties props = new Properties();
        props.setProperty("log.dirs", "/tmp/log");
        Assertions.assertEquals((Object)"/tmp/log", (Object)MetadataQuorumCommand.getMetadataDirectory((Properties)props));
    }

    @Test
    public void testGetMetadataDirectoryFromMultipleLogDirs() throws Exception {
        Properties props = new Properties();
        props.setProperty("log.dirs", "/tmp/log,/tmp/log2");
        Assertions.assertEquals((Object)"/tmp/log", (Object)MetadataQuorumCommand.getMetadataDirectory((Properties)props));
    }

    @Test
    public void testGetMetadataDirectoryFailure() {
        Properties props = new Properties();
        Assertions.assertEquals((Object)"Neither metadata.log.dir nor log.dirs were found. Is this a valid controller configuration file?", (Object)((TerseException)Assertions.assertThrows(TerseException.class, () -> MetadataQuorumCommand.getMetadataDirectory((Properties)props))).getMessage());
    }

    @Test
    public void testGetMetadataDirectoryId() throws Exception {
        try (MetadataQuorumCommandUnitTestEnv testEnv = new MetadataQuorumCommandUnitTestEnv(Optional.of(Uuid.fromString((String)"wZoXPqWoSu6F6c8MkmdyAg")));){
            Assertions.assertEquals((Object)Uuid.fromString((String)"wZoXPqWoSu6F6c8MkmdyAg"), (Object)MetadataQuorumCommand.getMetadataDirectoryId((String)testEnv.metadataDir.getAbsolutePath()));
        }
    }

    @Test
    public void testGetMetadataDirectoryIdWhenThereIsNoId() throws Exception {
        try (MetadataQuorumCommandUnitTestEnv testEnv = new MetadataQuorumCommandUnitTestEnv(Optional.empty());){
            Assertions.assertEquals((Object)("No directory id found in " + testEnv.metadataDir.getAbsolutePath()), (Object)((TerseException)Assertions.assertThrows(TerseException.class, () -> MetadataQuorumCommand.getMetadataDirectoryId((String)testEnv.metadataDir.getAbsolutePath()))).getMessage());
        }
    }

    @Test
    public void testGetMetadataDirectoryIdWhenThereIsNoDirectory() throws Exception {
        try (MetadataQuorumCommandUnitTestEnv testEnv = new MetadataQuorumCommandUnitTestEnv(Optional.empty());){
            testEnv.close();
            Assertions.assertEquals((Object)("Unable to read meta.properties from " + testEnv.metadataDir.getAbsolutePath()), (Object)((TerseException)Assertions.assertThrows(TerseException.class, () -> MetadataQuorumCommand.getMetadataDirectoryId((String)testEnv.metadataDir.getAbsolutePath()))).getMessage());
        }
    }

    @Test
    public void testGetControllerAdvertisedListenersWithNoControllerListenerNames() {
        Properties props = new Properties();
        Assertions.assertEquals((Object)"controller.listener.names was not found. Is this a valid controller configuration file?", (Object)((TerseException)Assertions.assertThrows(TerseException.class, () -> MetadataQuorumCommand.getControllerAdvertisedListeners((Properties)props))).getMessage());
    }

    @Test
    public void testGetControllerAdvertisedListenersWithNoControllerListenerInformation() {
        Properties props = new Properties();
        props.setProperty("controller.listener.names", "CONTROLLER,CONTROLLER2");
        Assertions.assertEquals((Object)"Cannot find information about controller listener name: CONTROLLER", (Object)((TerseException)Assertions.assertThrows(TerseException.class, () -> MetadataQuorumCommand.getControllerAdvertisedListeners((Properties)props))).getMessage());
    }

    @Test
    public void testGetControllerAdvertisedListenersWithRegularListeners() throws Exception {
        Properties props = new Properties();
        props.setProperty("controller.listener.names", "CONTROLLER,CONTROLLER2");
        props.setProperty("listeners", "CONTROLLER://example.com:9092,CONTROLLER2://:9093");
        Assertions.assertEquals(new HashSet<RaftVoterEndpoint>(Arrays.asList(new RaftVoterEndpoint("CONTROLLER", "example.com", 9092), new RaftVoterEndpoint("CONTROLLER2", "localhost", 9093))), (Object)MetadataQuorumCommand.getControllerAdvertisedListeners((Properties)props));
    }

    @Test
    public void testGetControllerAdvertisedListenersWithRegularListenersAndAdvertisedListeners() throws Exception {
        Properties props = new Properties();
        props.setProperty("controller.listener.names", "CONTROLLER,CONTROLLER2");
        props.setProperty("listeners", "CONTROLLER://:9092,CONTROLLER2://:9093");
        props.setProperty("advertised.listeners", "CONTROLLER://example.com:9092,CONTROLLER2://example.com:9093");
        Assertions.assertEquals(new HashSet<RaftVoterEndpoint>(Arrays.asList(new RaftVoterEndpoint("CONTROLLER", "example.com", 9092), new RaftVoterEndpoint("CONTROLLER2", "example.com", 9093))), (Object)MetadataQuorumCommand.getControllerAdvertisedListeners((Properties)props));
    }

    @Test
    public void testAddControllerDryRun() throws Exception {
        try (MetadataQuorumCommandUnitTestEnv testEnv = new MetadataQuorumCommandUnitTestEnv(Optional.of(Uuid.fromString((String)"wZoXPqWoSu6F6c8MkmdyAg")));){
            File propsFile = testEnv.writePropertiesFile();
            List<String> outputs = Arrays.asList(ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)0, (int)MetadataQuorumCommand.mainNoExit((String[])new String[]{"--bootstrap-server", "localhost:9092", "--command-config", propsFile.getAbsolutePath(), "add-controller", "--dry-run"}))).split("\n"));
            Assertions.assertTrue((boolean)outputs.contains("DRY RUN of adding controller 5 with directory id wZoXPqWoSu6F6c8MkmdyAg and endpoints: CONTROLLER://example.com:9093, CONTROLLER_SSL://example.com:9094"), (String)("Failed to find expected output in stdout: " + String.valueOf(outputs)));
        }
    }

    static class MetadataQuorumCommandUnitTestEnv
    implements AutoCloseable {
        File metadataDir = TestUtils.tempDirectory();

        MetadataQuorumCommandUnitTestEnv(Optional<Uuid> directoryId) throws Exception {
            new MetaPropertiesEnsemble.Copier(MetaPropertiesEnsemble.EMPTY).setMetaLogDir(Optional.of(this.metadataDir.getAbsolutePath())).setLogDirProps(this.metadataDir.getAbsolutePath(), new MetaProperties.Builder().setClusterId("Ig-WB32JRqqzct3VafTr0w").setNodeId(2).setDirectoryId(directoryId).build()).writeLogDirChanges();
        }

        File writePropertiesFile() throws IOException {
            Properties props = new Properties();
            props.setProperty("metadata.log.dir", this.metadataDir.getAbsolutePath());
            props.setProperty("log.dirs", this.metadataDir.getAbsolutePath());
            props.setProperty("process.roles", "controller,broker");
            props.setProperty("node.id", "5");
            props.setProperty("controller.listener.names", "CONTROLLER,CONTROLLER_SSL");
            props.setProperty("listeners", "CONTROLLER://:9093,CONTROLLER_SSL://:9094");
            props.setProperty("advertised.listeners", "CONTROLLER://example.com:9093,CONTROLLER_SSL://example.com:9094");
            File file = new File(this.metadataDir, "controller.properties");
            PropertiesUtils.writePropertiesFile((Properties)props, (String)file.getAbsolutePath(), (boolean)false);
            return file;
        }

        @Override
        public void close() throws Exception {
            Utils.delete((File)this.metadataDir);
        }
    }
}

