/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTests;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tools.MetadataQuorumCommand;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MetadataQuorumCommandTest {
    MetadataQuorumCommandTest() {
    }

    @ClusterTests(value={@ClusterTest(brokers=2, controllers=2), @ClusterTest(brokers=2, controllers=1), @ClusterTest(brokers=1, controllers=2)})
    public void testDescribeQuorumReplicationSuccessful(ClusterInstance cluster) throws InterruptedException {
        cluster.waitForReadyBrokers();
        String describeOutput = ToolsTestUtils.captureStandardOut(() -> MetadataQuorumCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "describe", "--replication"}));
        List outputs = Arrays.stream(describeOutput.split("\n")).collect(Collectors.toList());
        String header = (String)outputs.get(0);
        List data = outputs.subList(1, outputs.size());
        Assertions.assertTrue((boolean)header.matches("NodeId\\s+DirectoryId\\s+LogEndOffset\\s+Lag\\s+LastFetchTimestamp\\s+LastCaughtUpTimestamp\\s+Status\\s+"));
        if (cluster.type() == Type.CO_KRAFT) {
            Assertions.assertEquals((int)Math.max(cluster.config().numControllers(), cluster.config().numBrokers()), (int)data.size());
        } else {
            Assertions.assertEquals((int)(cluster.config().numBrokers() + cluster.config().numControllers()), (int)data.size());
        }
        Pattern leaderPattern = Pattern.compile("\\d+\\s+\\S+\\s+\\d+\\s+\\d+\\s+-?\\d+\\s+-?\\d+\\s+Leader\\s*");
        Assertions.assertTrue((boolean)leaderPattern.matcher((CharSequence)data.get(0)).find());
        Assertions.assertTrue((boolean)data.stream().skip(1L).noneMatch(o -> leaderPattern.matcher((CharSequence)o).find()));
        Pattern followerPattern = Pattern.compile("\\d+\\s+\\S+\\s+\\d+\\s+\\d+\\s+-?\\d+\\s+-?\\d+\\s+Follower\\s*");
        Assertions.assertEquals((long)(cluster.config().numControllers() - 1), (long)data.stream().filter(o -> followerPattern.matcher((CharSequence)o).find()).count());
        Pattern observerPattern = Pattern.compile("\\d+\\s+\\S+\\s+\\d+\\s+\\d+\\s+-?\\d+\\s+-?\\d+\\s+Observer\\s*");
        if (cluster.type() == Type.CO_KRAFT) {
            Assertions.assertEquals((long)Math.max(0, cluster.config().numBrokers() - cluster.config().numControllers()), (long)data.stream().filter(o -> observerPattern.matcher((CharSequence)o).find()).count());
        } else {
            Assertions.assertEquals((long)cluster.config().numBrokers(), (long)data.stream().filter(o -> observerPattern.matcher((CharSequence)o).find()).count());
        }
    }

    @ClusterTests(value={@ClusterTest(brokers=2, controllers=2), @ClusterTest(brokers=2, controllers=1), @ClusterTest(brokers=1, controllers=2)})
    public void testDescribeQuorumStatusSuccessful(ClusterInstance cluster) throws InterruptedException {
        this.testDescribeQuorumStatusSuccessful(cluster, false);
        this.testDescribeQuorumStatusSuccessful(cluster, true);
    }

    private void testDescribeQuorumStatusSuccessful(ClusterInstance cluster, boolean usingBootstrapController) throws InterruptedException {
        cluster.waitForReadyBrokers();
        String describeOutput = ToolsTestUtils.captureStandardOut(() -> MetadataQuorumCommand.mainNoExit((String[])new String[]{usingBootstrapController ? "--bootstrap-controller" : "--bootstrap-server", usingBootstrapController ? cluster.bootstrapControllers() : cluster.bootstrapServers(), "describe", "--status"}));
        String[] outputs = describeOutput.split("\n");
        Assertions.assertTrue((boolean)outputs[0].matches("ClusterId:\\s+\\S{22}"), (String)describeOutput);
        Assertions.assertTrue((boolean)outputs[1].matches("LeaderId:\\s+\\d+"), (String)describeOutput);
        Assertions.assertTrue((boolean)outputs[2].matches("LeaderEpoch:\\s+\\d+"), (String)describeOutput);
        Assertions.assertTrue((boolean)outputs[3].matches("HighWatermark:\\s+-?\\d+"), (String)describeOutput);
        Assertions.assertTrue((boolean)outputs[4].matches("MaxFollowerLag:\\s+\\d+"), (String)describeOutput);
        Assertions.assertTrue((boolean)outputs[5].matches("MaxFollowerLagTimeMs:\\s+-?\\d+"), (String)describeOutput);
        Assertions.assertTrue((boolean)outputs[6].matches("CurrentVoters:\\s+\\[\\{\"id\":\\s+\\d+,\\s+\"endpoints\":\\s+\\[\"\\S+://\\[?\\S+]?:\\d+\",?.*]"), (String)describeOutput);
        if (cluster.type() == Type.CO_KRAFT && cluster.config().numBrokers() <= cluster.config().numControllers()) {
            Assertions.assertTrue((boolean)outputs[7].matches("CurrentObservers:\\s+\\[]"), (String)describeOutput);
        } else {
            Assertions.assertTrue((boolean)outputs[7].matches("CurrentObservers:\\s+\\[\\{\"id\":\\s+\\d+,\\s+\"directoryId\":\\s+\\S+}(,\\s+\\{\"id\":\\s+\\d+,\\s+\"directoryId\":\\s+\\S+})*]"), (String)describeOutput);
        }
    }

    @ClusterTest
    public void testOnlyOneBrokerAndOneController(ClusterInstance cluster) {
        this.testOnlyOneBrokerAndOneController(cluster, false);
        this.testOnlyOneBrokerAndOneController(cluster, true);
    }

    public void testOnlyOneBrokerAndOneController(ClusterInstance cluster, boolean usingBootstrapController) {
        String statusOutput = ToolsTestUtils.captureStandardOut(() -> MetadataQuorumCommand.mainNoExit((String[])new String[]{usingBootstrapController ? "--bootstrap-controller" : "--bootstrap-server", usingBootstrapController ? cluster.bootstrapControllers() : cluster.bootstrapServers(), "describe", "--status"}));
        Assertions.assertEquals((Object)"MaxFollowerLag:         0", (Object)statusOutput.split("\n")[4]);
        Assertions.assertEquals((Object)"MaxFollowerLagTimeMs:   0", (Object)statusOutput.split("\n")[5]);
        String replicationOutput = ToolsTestUtils.captureStandardOut(() -> MetadataQuorumCommand.mainNoExit((String[])new String[]{usingBootstrapController ? "--bootstrap-controller" : "--bootstrap-server", usingBootstrapController ? cluster.bootstrapControllers() : cluster.bootstrapServers(), "describe", "--replication"}));
        Assertions.assertEquals((Object)"0", (Object)replicationOutput.split("\n")[1].split("\\s+")[3]);
    }

    @Test
    public void testCommandConfig() throws IOException {
        File tmpfile = TestUtils.tempFile((String)"security.protocol=SSL_PLAINTEXT");
        Assertions.assertEquals((int)1, (int)MetadataQuorumCommand.mainNoExit((String[])new String[]{"--bootstrap-server", "localhost:9092", "--command-config", tmpfile.getAbsolutePath(), "describe", "--status"}));
    }

    @ClusterTest(types={Type.CO_KRAFT})
    public void testHumanReadableOutput(ClusterInstance cluster) {
        Assertions.assertEquals((int)1, (int)MetadataQuorumCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "describe", "--human-readable"}));
        Assertions.assertEquals((int)1, (int)MetadataQuorumCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "describe", "--status", "--human-readable"}));
        String out0 = ToolsTestUtils.captureStandardOut(() -> MetadataQuorumCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "describe", "--replication"}));
        Assertions.assertFalse((boolean)out0.split("\n")[1].matches("\\d*"));
        String out1 = ToolsTestUtils.captureStandardOut(() -> MetadataQuorumCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "describe", "--replication", "--human-readable"}));
        MetadataQuorumCommandTest.assertHumanReadable(out1);
        String out2 = ToolsTestUtils.captureStandardOut(() -> MetadataQuorumCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "describe", "--re", "--hu"}));
        MetadataQuorumCommandTest.assertHumanReadable(out2);
    }

    private static void assertHumanReadable(String output) {
        String dataRow = output.split("\n")[1];
        String lastFetchTimestamp = dataRow.split("\t")[4];
        String lastFetchTimestampValue = lastFetchTimestamp.split(" ")[0];
        String lastCaughtUpTimestamp = dataRow.split("\t")[5];
        String lastCaughtUpTimestampValue = lastCaughtUpTimestamp.split(" ")[0];
        Assertions.assertTrue((boolean)lastFetchTimestamp.contains("ms ago"));
        Assertions.assertTrue((boolean)lastFetchTimestampValue.matches("\\d*"));
        Assertions.assertTrue((boolean)lastCaughtUpTimestamp.contains("ms ago"));
        Assertions.assertTrue((boolean)lastCaughtUpTimestampValue.matches("\\d*"));
    }
}

