/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.tools.LogDirsCommand;
import org.apache.kafka.tools.TerseException;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LogDirsCommandTest {
    private static final String TOPIC = "test-log-dirs-topic";

    @ClusterTest(brokers=3)
    public void testLogDirsWithoutBrokers(ClusterInstance clusterInstance) {
        this.createTopic(clusterInstance, TOPIC);
        try (Admin admin = Admin.create(Collections.singletonMap("bootstrap.servers", clusterInstance.bootstrapServers()));){
            String output = (String)Assertions.assertDoesNotThrow(() -> this.execute(this.fromArgsToOptions("--bootstrap-server", clusterInstance.bootstrapServers(), "--describe"), admin));
            clusterInstance.brokerIds().forEach(brokerId -> Assertions.assertTrue((boolean)output.contains("\"broker\":" + brokerId)));
            Map logDirs = (Map)Assertions.assertDoesNotThrow(() -> (Map)admin.describeLogDirs((Collection)clusterInstance.brokerIds()).allDescriptions().get());
            Assertions.assertFalse((boolean)logDirs.isEmpty());
            logDirs.forEach((brokerId, logDirInfo) -> logDirInfo.forEach((logDir, logDirInfoValue) -> {
                Assertions.assertTrue((boolean)output.contains("\"logDir\":\"" + logDir + "\""));
                logDirInfoValue.replicaInfos().forEach((topicPartition, replicaInfo) -> Assertions.assertTrue((boolean)output.contains("\"partition\":\"" + String.valueOf(topicPartition) + "\"")));
            }));
        }
    }

    @ClusterTest(brokers=3)
    public void testLogDirsWithBrokers(ClusterInstance clusterInstance) {
        this.createTopic(clusterInstance, TOPIC);
        try (Admin admin = Admin.create(Collections.singletonMap("bootstrap.servers", clusterInstance.bootstrapServers()));){
            int brokerId = 0;
            String output = (String)Assertions.assertDoesNotThrow(() -> this.execute(this.fromArgsToOptions("--bootstrap-server", clusterInstance.bootstrapServers(), "--broker-list", String.valueOf(brokerId), "--describe"), admin));
            Assertions.assertTrue((boolean)output.contains("\"broker\":" + brokerId));
            clusterInstance.brokerIds().stream().filter(id -> id != brokerId).forEach(id -> Assertions.assertFalse((boolean)output.contains("\"broker\":" + id)));
            Map logDirs = (Map)Assertions.assertDoesNotThrow(() -> (Map)admin.describeLogDirs(Collections.singleton(brokerId)).allDescriptions().get());
            Assertions.assertEquals((int)1, (int)logDirs.size());
            logDirs.forEach((brokerIdValue, logDirInfo) -> {
                Assertions.assertFalse((boolean)logDirInfo.isEmpty());
                logDirInfo.forEach((logDir, logDirInfoValue) -> {
                    Assertions.assertTrue((boolean)output.contains("\"logDir\":\"" + logDir + "\""));
                    Optional<TopicPartition> topicPartition = logDirInfoValue.replicaInfos().keySet().stream().filter(tp -> tp.topic().equals(TOPIC)).findFirst();
                    Assertions.assertTrue((boolean)topicPartition.isPresent());
                    Assertions.assertTrue((boolean)output.contains("\"partition\":\"" + String.valueOf(topicPartition.get()) + "\""));
                });
            });
        }
    }

    @ClusterTest
    public void testLogDirsWithNonExistentTopic(ClusterInstance clusterInstance) {
        try (Admin admin = Admin.create(Collections.singletonMap("bootstrap.servers", clusterInstance.bootstrapServers()));){
            String output = (String)Assertions.assertDoesNotThrow(() -> this.execute(this.fromArgsToOptions("--bootstrap-server", clusterInstance.bootstrapServers(), "--topic-list", TOPIC, "--describe"), admin));
            clusterInstance.brokerIds().forEach(brokerId -> Assertions.assertTrue((boolean)output.contains("\"broker\":" + brokerId)));
            Map logDirs = (Map)Assertions.assertDoesNotThrow(() -> (Map)admin.describeLogDirs((Collection)clusterInstance.brokerIds()).allDescriptions().get());
            Assertions.assertFalse((boolean)logDirs.isEmpty());
            logDirs.forEach((brokerId, logDirInfo) -> logDirInfo.forEach((logDir, logDirInfoValue) -> {
                Assertions.assertTrue((boolean)output.contains("\"logDir\":\"" + logDir + "\""));
                logDirInfoValue.replicaInfos().forEach((topicPartition, replicaInfo) -> Assertions.assertFalse((boolean)output.contains("\"partition\":\"" + String.valueOf(topicPartition) + "\"")));
            }));
        }
    }

    @ClusterTest
    public void testLogDirsWithSpecificTopic(ClusterInstance clusterInstance) {
        this.createTopic(clusterInstance, TOPIC);
        this.createTopic(clusterInstance, "other-topic");
        try (Admin admin = Admin.create(Collections.singletonMap("bootstrap.servers", clusterInstance.bootstrapServers()));){
            String output = (String)Assertions.assertDoesNotThrow(() -> this.execute(this.fromArgsToOptions("--bootstrap-server", clusterInstance.bootstrapServers(), "--topic-list", TOPIC, "--describe"), admin));
            clusterInstance.brokerIds().forEach(brokerId -> Assertions.assertTrue((boolean)output.contains("\"broker\":" + brokerId)));
            Map logDirs = (Map)Assertions.assertDoesNotThrow(() -> (Map)admin.describeLogDirs((Collection)clusterInstance.brokerIds()).allDescriptions().get());
            Assertions.assertFalse((boolean)logDirs.isEmpty());
            Assertions.assertTrue((boolean)output.contains("\"partition\":\"" + String.valueOf(new TopicPartition(TOPIC, 0)) + "\""));
            Assertions.assertFalse((boolean)output.contains("\"partition\":\"" + String.valueOf(new TopicPartition("other-topic", 0)) + "\""));
            logDirs.forEach((brokerId, logDirInfo) -> logDirInfo.forEach((logDir, logDirInfoValue) -> {
                Assertions.assertTrue((boolean)output.contains("\"logDir\":\"" + logDir + "\""));
                logDirInfoValue.replicaInfos().keySet().stream().filter(tp -> !tp.topic().equals(TOPIC)).forEach(tp -> Assertions.assertFalse((boolean)output.contains("\"partition\":\"" + String.valueOf(tp) + "\"")));
            }));
        }
    }

    @Test
    public void shouldThrowWhenQueryingNonExistentBrokers() {
        Node broker = new Node(1, "hostname", 9092);
        try (MockAdminClient adminClient = new MockAdminClient(Collections.singletonList(broker), broker);){
            RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> this.execute(this.fromArgsToOptions("--bootstrap-server", "EMPTY", "--broker-list", "0,1,2", "--describe"), (Admin)adminClient));
            Assertions.assertNotNull((Object)exception.getCause());
            Assertions.assertEquals(TerseException.class, exception.getCause().getClass());
            Assertions.assertEquals((Object)"ERROR: The given brokers do not exist from --broker-list: 0,2. Current existent brokers: 1", (Object)exception.getCause().getMessage());
        }
    }

    @Test
    public void shouldNotThrowWhenDuplicatedBrokers() throws JsonProcessingException {
        Node broker = new Node(1, "hostname", 9092);
        try (MockAdminClient adminClient = new MockAdminClient(Collections.singletonList(broker), broker);){
            String standardOutput = this.execute(this.fromArgsToOptions("--bootstrap-server", "EMPTY", "--broker-list", "1,1", "--describe"), (Admin)adminClient);
            String[] standardOutputLines = standardOutput.split("\n");
            Assertions.assertEquals((int)3, (int)standardOutputLines.length);
            Map information = (Map)new ObjectMapper().readValue(standardOutputLines[2], HashMap.class);
            List brokersInformation = (List)information.get("brokers");
            Integer brokerId = (Integer)((HashMap)brokersInformation.get(0)).get("broker");
            Assertions.assertEquals((int)1, (int)brokersInformation.size());
            Assertions.assertEquals((int)1, (Integer)brokerId);
        }
    }

    @Test
    public void shouldQueryAllBrokersIfNonSpecified() throws JsonProcessingException {
        Node brokerOne = new Node(1, "hostname", 9092);
        Node brokerTwo = new Node(2, "hostname", 9092);
        try (MockAdminClient adminClient = new MockAdminClient(Arrays.asList(brokerTwo, brokerOne), brokerOne);){
            String standardOutput = this.execute(this.fromArgsToOptions("--bootstrap-server", "EMPTY", "--describe"), (Admin)adminClient);
            String[] standardOutputLines = standardOutput.split("\n");
            Assertions.assertEquals((int)3, (int)standardOutputLines.length);
            Map information = (Map)new ObjectMapper().readValue(standardOutputLines[2], HashMap.class);
            final List brokersInformation = (List)information.get("brokers");
            HashSet<Integer> brokerIds = new HashSet<Integer>(){
                {
                    this.add((Integer)((HashMap)brokersInformation.get(0)).get("broker"));
                    this.add((Integer)((HashMap)brokersInformation.get(1)).get("broker"));
                }
            };
            Assertions.assertEquals((int)2, (int)brokersInformation.size());
            Assertions.assertEquals(new HashSet<Integer>(Arrays.asList(2, 1)), (Object)brokerIds);
        }
    }

    @Test
    public void shouldQuerySpecifiedBroker() throws JsonProcessingException {
        Node brokerOne = new Node(1, "hostname", 9092);
        Node brokerTwo = new Node(2, "hostname", 9092);
        try (MockAdminClient adminClient = new MockAdminClient(Arrays.asList(brokerOne, brokerTwo), brokerOne);){
            String standardOutput = this.execute(this.fromArgsToOptions("--bootstrap-server", "EMPTY", "--broker-list", "1", "--describe"), (Admin)adminClient);
            String[] standardOutputLines = standardOutput.split("\n");
            Assertions.assertEquals((int)3, (int)standardOutputLines.length);
            Map information = (Map)new ObjectMapper().readValue(standardOutputLines[2], HashMap.class);
            List brokersInformation = (List)information.get("brokers");
            Integer brokerId = (Integer)((HashMap)brokersInformation.get(0)).get("broker");
            Assertions.assertEquals((int)1, (int)brokersInformation.size());
            Assertions.assertEquals((int)1, (Integer)brokerId);
        }
    }

    private LogDirsCommand.LogDirsCommandOptions fromArgsToOptions(String ... args) {
        return new LogDirsCommand.LogDirsCommandOptions(args);
    }

    private String execute(LogDirsCommand.LogDirsCommandOptions options, Admin adminClient) {
        Runnable runnable = () -> {
            try {
                LogDirsCommand.execute((LogDirsCommand.LogDirsCommandOptions)options, (Admin)adminClient);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        return ToolsTestUtils.captureStandardOut(runnable);
    }

    private void createTopic(ClusterInstance clusterInstance, String topic) {
        try (Admin admin = Admin.create(Collections.singletonMap("bootstrap.servers", clusterInstance.bootstrapServers()));){
            Assertions.assertDoesNotThrow(() -> (Uuid)admin.createTopics(Collections.singletonList(new NewTopic(topic, Collections.singletonMap(0, Collections.singletonList(0))))).topicId(topic).get());
            Assertions.assertDoesNotThrow(() -> clusterInstance.waitForTopic(topic, 1));
        }
    }
}

