/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import kafka.utils.TestUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.tools.AdminCommandFailedException;
import org.apache.kafka.tools.LeaderElectionCommand;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.mockito.ArgumentCaptor;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import scala.jdk.javaapi.CollectionConverters;

@ClusterTestDefaults(brokers=3, serverProperties={@ClusterConfigProperty(key="auto.create.topics.enable", value="false"), @ClusterConfigProperty(key="auto.leader.rebalance.enable", value="false"), @ClusterConfigProperty(key="controlled.shutdown.enable", value="true"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="2")})
public class LeaderElectionCommandTest {
    private final ClusterInstance cluster;
    int broker2 = 1;
    int broker3 = 2;

    public LeaderElectionCommandTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }

    @ClusterTest
    public void testAllTopicPartition() throws InterruptedException, ExecutionException {
        String topic = "unclean-topic";
        int partition = 0;
        List<Integer> assignment = Arrays.asList(this.broker2, this.broker3);
        this.cluster.waitForReadyBrokers();
        try (Admin client = this.cluster.admin();){
            this.createTopic(client, topic, Collections.singletonMap(partition, assignment));
            TopicPartition topicPartition = new TopicPartition(topic, partition);
            TestUtils.assertLeader((Admin)client, (TopicPartition)topicPartition, (int)this.broker2);
            this.cluster.shutdownBroker(this.broker3);
            TestUtils.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set)CollectionConverters.asScala(Collections.singletonList(topicPartition)).toSet(), (scala.collection.immutable.Set)CollectionConverters.asScala(Collections.singletonList(this.broker3)).toSet());
            this.cluster.shutdownBroker(this.broker2);
            TestUtils.assertNoLeader((Admin)client, (TopicPartition)topicPartition);
            this.cluster.startBroker(this.broker3);
            TestUtils.waitForOnlineBroker((Admin)client, (int)this.broker3);
            Assertions.assertEquals((int)0, (int)LeaderElectionCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "unclean", "--all-topic-partitions"}));
            TestUtils.assertLeader((Admin)client, (TopicPartition)topicPartition, (int)this.broker3);
        }
    }

    @ClusterTest
    public void testAdminConfigCustomTimeouts() throws Exception {
        String defaultApiTimeoutMs = String.valueOf(110000);
        String requestTimeoutMs = String.valueOf(55000);
        Path adminConfigPath = this.tempAdminConfig(defaultApiTimeoutMs, requestTimeoutMs);
        try (MockedStatic mockedAdmin = Mockito.mockStatic(Admin.class);){
            Assertions.assertEquals((int)1, (int)LeaderElectionCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "unclean", "--all-topic-partitions", "--admin.config", adminConfigPath.toString()}));
            ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(Properties.class);
            mockedAdmin.verify(() -> Admin.create((Properties)((Properties)argumentCaptor.capture())));
            Properties actualProps = (Properties)argumentCaptor.getValue();
            Assertions.assertEquals((Object)actualProps.get("request.timeout.ms"), (Object)requestTimeoutMs);
            Assertions.assertEquals((Object)actualProps.get("default.api.timeout.ms"), (Object)defaultApiTimeoutMs);
        }
    }

    @ClusterTest
    public void testTopicPartition() throws InterruptedException, ExecutionException {
        String topic = "unclean-topic";
        int partition = 0;
        List<Integer> assignment = Arrays.asList(this.broker2, this.broker3);
        this.cluster.waitForReadyBrokers();
        try (Admin client = this.cluster.admin();){
            this.createTopic(client, topic, Collections.singletonMap(partition, assignment));
            TopicPartition topicPartition = new TopicPartition(topic, partition);
            TestUtils.assertLeader((Admin)client, (TopicPartition)topicPartition, (int)this.broker2);
            this.cluster.shutdownBroker(this.broker3);
            TestUtils.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set)CollectionConverters.asScala(Collections.singletonList(topicPartition)).toSet(), (scala.collection.immutable.Set)CollectionConverters.asScala(Collections.singletonList(this.broker3)).toSet());
            this.cluster.shutdownBroker(this.broker2);
            TestUtils.assertNoLeader((Admin)client, (TopicPartition)topicPartition);
            this.cluster.startBroker(this.broker3);
            TestUtils.waitForOnlineBroker((Admin)client, (int)this.broker3);
            Assertions.assertEquals((int)0, (int)LeaderElectionCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "unclean", "--topic", topic, "--partition", Integer.toString(partition)}));
            TestUtils.assertLeader((Admin)client, (TopicPartition)topicPartition, (int)this.broker3);
        }
    }

    @ClusterTest
    public void testPathToJsonFile() throws Exception {
        String topic = "unclean-topic";
        int partition = 0;
        List<Integer> assignment = Arrays.asList(this.broker2, this.broker3);
        this.cluster.waitForReadyBrokers();
        HashMap<Integer, List<Integer>> partitionAssignment = new HashMap<Integer, List<Integer>>();
        partitionAssignment.put(partition, assignment);
        try (Admin client = this.cluster.admin();){
            this.createTopic(client, topic, partitionAssignment);
            TopicPartition topicPartition = new TopicPartition(topic, partition);
            TestUtils.assertLeader((Admin)client, (TopicPartition)topicPartition, (int)this.broker2);
            this.cluster.shutdownBroker(this.broker3);
            TestUtils.waitForBrokersOutOfIsr((Admin)client, (scala.collection.immutable.Set)CollectionConverters.asScala(Collections.singletonList(topicPartition)).toSet(), (scala.collection.immutable.Set)CollectionConverters.asScala(Collections.singletonList(this.broker3)).toSet());
            this.cluster.shutdownBroker(this.broker2);
            TestUtils.assertNoLeader((Admin)client, (TopicPartition)topicPartition);
            this.cluster.startBroker(this.broker3);
            TestUtils.waitForOnlineBroker((Admin)client, (int)this.broker3);
            Path topicPartitionPath = this.tempTopicPartitionFile(Collections.singletonList(topicPartition));
            Assertions.assertEquals((int)0, (int)LeaderElectionCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "unclean", "--path-to-json-file", topicPartitionPath.toString()}));
            TestUtils.assertLeader((Admin)client, (TopicPartition)topicPartition, (int)this.broker3);
        }
    }

    @ClusterTest
    public void testPreferredReplicaElection() throws InterruptedException, ExecutionException {
        String topic = "preferred-topic";
        int partition = 0;
        List<Integer> assignment = Arrays.asList(this.broker2, this.broker3);
        this.cluster.waitForReadyBrokers();
        try (Admin client = this.cluster.admin();){
            HashMap<Integer, List<Integer>> partitionAssignment = new HashMap<Integer, List<Integer>>();
            partitionAssignment.put(partition, assignment);
            this.createTopic(client, topic, partitionAssignment);
            TopicPartition topicPartition = new TopicPartition(topic, partition);
            TestUtils.assertLeader((Admin)client, (TopicPartition)topicPartition, (int)this.broker2);
            this.cluster.shutdownBroker(this.broker2);
            TestUtils.assertLeader((Admin)client, (TopicPartition)topicPartition, (int)this.broker3);
            this.cluster.startBroker(this.broker2);
            TestUtils.waitForBrokersInIsr((Admin)client, (TopicPartition)topicPartition, (scala.collection.immutable.Set)CollectionConverters.asScala(Collections.singletonList(this.broker2)).toSet());
            Assertions.assertEquals((int)0, (int)LeaderElectionCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "preferred", "--all-topic-partitions"}));
            TestUtils.assertLeader((Admin)client, (TopicPartition)topicPartition, (int)this.broker2);
        }
    }

    @ClusterTest
    public void testTopicDoesNotExist() {
        Throwable e = Assertions.assertThrows(AdminCommandFailedException.class, () -> LeaderElectionCommand.run((Duration)Duration.ofSeconds(30L), (String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "preferred", "--topic", "unknown-topic-name", "--partition", "0"}));
        Assertions.assertInstanceOf(UnknownTopicOrPartitionException.class, (Object)e.getSuppressed()[0]);
    }

    @ClusterTest
    public void testElectionResultOutput() throws Exception {
        TopicPartition topicPartition1;
        TopicPartition topicPartition0;
        String topic = "non-preferred-topic";
        int partition0 = 0;
        int partition1 = 1;
        List<Integer> assignment0 = Arrays.asList(this.broker2, this.broker3);
        List<Integer> assignment1 = Arrays.asList(this.broker3, this.broker2);
        this.cluster.waitForReadyBrokers();
        try (Admin client = this.cluster.admin();){
            HashMap<Integer, List<Integer>> partitionAssignment = new HashMap<Integer, List<Integer>>();
            partitionAssignment.put(partition0, assignment0);
            partitionAssignment.put(partition1, assignment1);
            this.createTopic(client, topic, partitionAssignment);
            topicPartition0 = new TopicPartition(topic, partition0);
            topicPartition1 = new TopicPartition(topic, partition1);
            TestUtils.assertLeader((Admin)client, (TopicPartition)topicPartition0, (int)this.broker2);
            TestUtils.assertLeader((Admin)client, (TopicPartition)topicPartition1, (int)this.broker3);
            this.cluster.shutdownBroker(this.broker2);
            TestUtils.assertLeader((Admin)client, (TopicPartition)topicPartition0, (int)this.broker3);
            this.cluster.startBroker(this.broker2);
            TestUtils.waitForBrokersInIsr((Admin)client, (TopicPartition)topicPartition0, (scala.collection.immutable.Set)CollectionConverters.asScala(Collections.singletonList(this.broker2)).toSet());
            TestUtils.waitForBrokersInIsr((Admin)client, (TopicPartition)topicPartition1, (scala.collection.immutable.Set)CollectionConverters.asScala(Collections.singletonList(this.broker2)).toSet());
        }
        Path topicPartitionPath = this.tempTopicPartitionFile(Arrays.asList(topicPartition0, topicPartition1));
        String output = ToolsTestUtils.captureStandardOut(() -> LeaderElectionCommand.mainNoExit((String[])new String[]{"--bootstrap-server", this.cluster.bootstrapServers(), "--election-type", "preferred", "--path-to-json-file", topicPartitionPath.toString()}));
        Iterator electionResultOutputIter = Arrays.stream(output.split("\n")).iterator();
        Assertions.assertTrue((boolean)electionResultOutputIter.hasNext());
        String firstLine = (String)electionResultOutputIter.next();
        Assertions.assertTrue((boolean)firstLine.contains(String.format("Successfully completed leader election (PREFERRED) for partitions %s", topicPartition0)), (String)String.format("Unexpected output: %s", firstLine));
        Assertions.assertTrue((boolean)electionResultOutputIter.hasNext());
        String secondLine = (String)electionResultOutputIter.next();
        Assertions.assertTrue((boolean)secondLine.contains(String.format("Valid replica already elected for partitions %s", topicPartition1)), (String)String.format("Unexpected output: %s", secondLine));
    }

    private void createTopic(Admin admin, String topic, Map<Integer, List<Integer>> replicaAssignment) throws ExecutionException, InterruptedException {
        NewTopic newTopic = new NewTopic(topic, replicaAssignment);
        List<NewTopic> newTopics = Collections.singletonList(newTopic);
        CreateTopicsResult createTopicResult = admin.createTopics(newTopics);
        createTopicResult.all().get();
    }

    private Path tempTopicPartitionFile(List<TopicPartition> partitions) throws Exception {
        File file = TestUtils.tempFile((String)"leader-election-command", (String)".json");
        String jsonString = this.stringifyTopicPartitions(new HashSet<TopicPartition>(partitions));
        Files.writeString(file.toPath(), (CharSequence)jsonString, new OpenOption[0]);
        return file.toPath();
    }

    private Path tempAdminConfig(String defaultApiTimeoutMs, String requestTimeoutMs) throws Exception {
        String content = "default.api.timeout.ms=" + defaultApiTimeoutMs + "\nrequest.timeout.ms=" + requestTimeoutMs;
        File file = TestUtils.tempFile((String)"admin-config", (String)".properties");
        Files.writeString(file.toPath(), (CharSequence)content, new OpenOption[0]);
        return file.toPath();
    }

    private String stringifyTopicPartitions(Set<TopicPartition> topicPartitions) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"partitions\":[");
        Iterator<TopicPartition> iterator = topicPartitions.iterator();
        while (iterator.hasNext()) {
            TopicPartition topicPartition = iterator.next();
            sb.append("{\"topic\":\"").append(topicPartition.topic()).append("\",\"partition\":").append(topicPartition.partition()).append("}");
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        sb.append("]}");
        return sb.toString();
    }
}

