/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.time.Duration;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.tools.AdminCommandFailedException;
import org.apache.kafka.tools.LeaderElectionCommand;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LeaderElectionCommandErrorTest {
    @Test
    public void testTopicWithoutPartition() {
        String[] args = new String[]{"--bootstrap-server", "nohost:9092", "--election-type", "unclean", "--topic", "some-topic"};
        Assertions.assertEquals((int)1, (int)LeaderElectionCommand.mainNoExit((String[])args));
        String out = ToolsTestUtils.captureStandardErr(() -> LeaderElectionCommand.mainNoExit((String[])args));
        Assertions.assertTrue((boolean)out.startsWith("Missing required option(s)"));
        Assertions.assertTrue((boolean)out.contains(" partition"));
    }

    @Test
    public void testPartitionWithoutTopic() {
        String[] args = new String[]{"--bootstrap-server", "nohost:9092", "--election-type", "unclean", "--all-topic-partitions", "--partition", "0"};
        Assertions.assertEquals((int)1, (int)LeaderElectionCommand.mainNoExit((String[])args));
        String out = ToolsTestUtils.captureStandardErr(() -> LeaderElectionCommand.mainNoExit((String[])args));
        Assertions.assertTrue((boolean)out.startsWith("Option partition is only allowed if topic is used"));
    }

    @Test
    public void testMissingElectionType() {
        String[] args = new String[]{"--bootstrap-server", "nohost:9092", "--topic", "some-topic", "--partition", "0"};
        Assertions.assertEquals((int)1, (int)LeaderElectionCommand.mainNoExit((String[])args));
        String out = ToolsTestUtils.captureStandardErr(() -> LeaderElectionCommand.mainNoExit((String[])args));
        Assertions.assertTrue((boolean)out.startsWith("Missing required option(s)"));
        Assertions.assertTrue((boolean)out.contains(" election-type"));
    }

    @Test
    public void testMissingTopicPartitionSelection() {
        String[] args = new String[]{"--bootstrap-server", "nohost:9092", "--election-type", "preferred"};
        Assertions.assertEquals((int)1, (int)LeaderElectionCommand.mainNoExit((String[])args));
        String out = ToolsTestUtils.captureStandardErr(() -> LeaderElectionCommand.mainNoExit((String[])args));
        Assertions.assertTrue((boolean)out.startsWith("One and only one of the following options is required: "));
        Assertions.assertTrue((boolean)out.contains(" all-topic-partitions"));
        Assertions.assertTrue((boolean)out.contains(" topic"));
        Assertions.assertTrue((boolean)out.contains(" path-to-json-file"));
    }

    @Test
    public void testInvalidBroker() {
        Throwable e = Assertions.assertThrows(AdminCommandFailedException.class, () -> LeaderElectionCommand.run((Duration)Duration.ofSeconds(1L), (String[])new String[]{"--bootstrap-server", "example.com:1234", "--election-type", "unclean", "--all-topic-partitions"}));
        Assertions.assertInstanceOf(TimeoutException.class, (Object)e.getCause());
    }
}

