/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.lang.management.ManagementFactory;
import java.net.ServerSocket;
import java.rmi.registry.LocateRegistry;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.tools.JmxTool;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JmxToolTest {
    private final ToolsTestUtils.MockExitProcedure exitProcedure = new ToolsTestUtils.MockExitProcedure();
    private static JMXConnectorServer jmxAgent;
    private static String jmxUrl;

    @BeforeAll
    public static void beforeAll() throws Exception {
        int port = JmxToolTest.findRandomOpenPortOnAllLocalInterfaces();
        jmxUrl = String.format("service:jmx:rmi:///jndi/rmi://:%d/jmxrmi", port);
        System.setProperty("java.rmi.server.hostname", "localhost");
        LocateRegistry.createRegistry(port);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("com.sun.management.jmxremote.authenticate", "false");
        env.put("com.sun.management.jmxremote.ssl", "false");
        JMXServiceURL url = new JMXServiceURL(jmxUrl);
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        server.registerMBean(new Metrics(), new ObjectName("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec"));
        jmxAgent = JMXConnectorServerFactory.newJMXConnectorServer(url, env, server);
        jmxAgent.start();
    }

    @AfterAll
    public static void afterAll() throws Exception {
        jmxAgent.stop();
    }

    @BeforeEach
    public void beforeEach() {
        Exit.setExitProcedure((Exit.Procedure)this.exitProcedure);
    }

    @AfterEach
    public void afterEach() {
        Exit.resetExitProcedure();
    }

    @Test
    public void kafkaVersion() {
        String out = this.executeAndGetOut("--version");
        this.assertNormalExit();
        Assertions.assertTrue((boolean)out.contains(AppInfoParser.getVersion()));
    }

    @Test
    public void unrecognizedOption() {
        String err = this.executeAndGetErr("--foo");
        this.assertCommandFailure();
        Assertions.assertTrue((boolean)err.contains("UnrecognizedOptionException"));
        Assertions.assertTrue((boolean)err.contains("foo"));
    }

    @Test
    public void missingRequired() {
        String err = this.executeAndGetErr("--reporting-interval");
        this.assertCommandFailure();
        Assertions.assertTrue((boolean)err.contains("OptionMissingRequiredArgumentException"));
        Assertions.assertTrue((boolean)err.contains("reporting-interval"));
    }

    @Test
    public void malformedURL() {
        String err = this.executeAndGetErr("--jmx-url", "localhost:9999");
        this.assertCommandFailure();
        Assertions.assertTrue((boolean)err.contains("MalformedURLException"));
    }

    @Test
    public void helpOptions() {
        String[] expectedOptions = new String[]{"--attributes", "--date-format", "--help", "--jmx-auth-prop", "--jmx-ssl-enable", "--jmx-url", "--object-name", "--one-time", "--report-format", "--reporting-interval", "--version", "--wait"};
        String err = this.executeAndGetErr("--help");
        this.assertCommandFailure();
        for (String option : expectedOptions) {
            Assertions.assertTrue((boolean)err.contains(option), (String)option);
        }
    }

    @Test
    public void csvFormat() {
        String[] args = new String[]{"--jmx-url", jmxUrl, "--object-name", "kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec", "--report-format", "csv", "--one-time"};
        String out = this.executeAndGetOut(args);
        Arrays.stream(out.split("\\r?\\n")).forEach(line -> Assertions.assertTrue((boolean)line.matches("([a-zA-Z0-9=:,.]+),\"([ -~]+)\""), (String)line));
    }

    @Test
    public void tsvFormat() {
        String[] args = new String[]{"--jmx-url", jmxUrl, "--object-name", "kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec", "--report-format", "tsv", "--one-time"};
        String out = this.executeAndGetOut(args);
        Arrays.stream(out.split("\\r?\\n")).forEach(line -> Assertions.assertTrue((boolean)line.matches("([a-zA-Z0-9=:,.]+)\\t([ -~]+)"), (String)line));
    }

    @Test
    public void allMetrics() {
        String[] args = new String[]{"--jmx-url", jmxUrl, "--report-format", "csv", "--reporting-interval", "-1"};
        String out = this.executeAndGetOut(args);
        this.assertNormalExit();
        Map<String, String> csv = this.parseCsv(out);
        Assertions.assertFalse((boolean)csv.isEmpty());
    }

    @Test
    public void filteredMetrics() {
        String[] args = new String[]{"--jmx-url", jmxUrl, "--object-name", "kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec", "--attributes", "FifteenMinuteRate,FiveMinuteRate", "--report-format", "csv", "--one-time"};
        String out = this.executeAndGetOut(args);
        this.assertNormalExit();
        Map<String, String> csv = this.parseCsv(out);
        Assertions.assertEquals((Object)"1.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FifteenMinuteRate"));
        Assertions.assertEquals((Object)"3.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FiveMinuteRate"));
    }

    @Test
    public void testDomainNamePattern() {
        String[] args = new String[]{"--jmx-url", jmxUrl, "--object-name", "kafka.serve?:*", "--attributes", "FifteenMinuteRate,FiveMinuteRate", "--report-format", "csv", "--one-time"};
        String out = this.executeAndGetOut(args);
        this.assertNormalExit();
        Map<String, String> csv = this.parseCsv(out);
        Assertions.assertEquals((Object)"1.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FifteenMinuteRate"));
        Assertions.assertEquals((Object)"3.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FiveMinuteRate"));
    }

    @Test
    public void testDomainNamePatternWithNoAttributes() {
        String[] args = new String[]{"--jmx-url", jmxUrl, "--object-name", "kafka.serve?:*", "--report-format", "csv", "--one-time"};
        String out = this.executeAndGetOut(args);
        this.assertNormalExit();
        Map<String, String> csv = this.parseCsv(out);
        Assertions.assertEquals((Object)"1.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FifteenMinuteRate"));
        Assertions.assertEquals((Object)"3.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FiveMinuteRate"));
    }

    @Test
    public void testPropertyListPattern() {
        String[] args = new String[]{"--jmx-url", jmxUrl, "--object-name", "kafka.server:type=BrokerTopicMetrics,*", "--attributes", "FifteenMinuteRate,FiveMinuteRate", "--report-format", "csv", "--one-time"};
        String out = this.executeAndGetOut(args);
        this.assertNormalExit();
        Map<String, String> csv = this.parseCsv(out);
        Assertions.assertEquals((Object)"1.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FifteenMinuteRate"));
        Assertions.assertEquals((Object)"3.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FiveMinuteRate"));
    }

    @Test
    public void testPropertyListPatternWithNoAttributes() {
        String[] args = new String[]{"--jmx-url", jmxUrl, "--object-name", "kafka.server:type=BrokerTopicMetrics,*", "--report-format", "csv", "--one-time"};
        String out = this.executeAndGetOut(args);
        this.assertNormalExit();
        Map<String, String> csv = this.parseCsv(out);
        Assertions.assertEquals((Object)"1.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FifteenMinuteRate"));
        Assertions.assertEquals((Object)"3.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FiveMinuteRate"));
    }

    @Test
    public void testPropertyValuePattern() {
        String[] args = new String[]{"--jmx-url", jmxUrl, "--object-name", "kafka.server:type=BrokerTopicMetrics,name=*InPerSec", "--attributes", "FifteenMinuteRate,FiveMinuteRate", "--report-format", "csv", "--one-time"};
        String out = this.executeAndGetOut(args);
        this.assertNormalExit();
        Map<String, String> csv = this.parseCsv(out);
        Assertions.assertEquals((Object)"1.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FifteenMinuteRate"));
        Assertions.assertEquals((Object)"3.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FiveMinuteRate"));
    }

    @Test
    public void testPropertyValuePatternWithNoAttributes() {
        String[] args = new String[]{"--jmx-url", jmxUrl, "--object-name", "kafka.server:type=BrokerTopicMetrics,name=*InPerSec", "--report-format", "csv", "--one-time"};
        String out = this.executeAndGetOut(args);
        this.assertNormalExit();
        Map<String, String> csv = this.parseCsv(out);
        Assertions.assertEquals((Object)"1.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FifteenMinuteRate"));
        Assertions.assertEquals((Object)"3.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FiveMinuteRate"));
    }

    @Test
    public void testPropertyPattern() {
        String[] args = new String[]{"--jmx-url", jmxUrl, "--object-name", "kafka.server:type=*,*", "--attributes", "FifteenMinuteRate,FiveMinuteRate", "--report-format", "csv", "--one-time"};
        String out = this.executeAndGetOut(args);
        this.assertNormalExit();
        Map<String, String> csv = this.parseCsv(out);
        Assertions.assertEquals((Object)"1.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FifteenMinuteRate"));
        Assertions.assertEquals((Object)"3.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FiveMinuteRate"));
    }

    @Test
    public void testPropertyPatternWithNoAttributes() {
        String[] args = new String[]{"--jmx-url", jmxUrl, "--object-name", "kafka.server:type=*,*", "--report-format", "csv", "--one-time"};
        String out = this.executeAndGetOut(args);
        this.assertNormalExit();
        Map<String, String> csv = this.parseCsv(out);
        Assertions.assertEquals((Object)"1.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FifteenMinuteRate"));
        Assertions.assertEquals((Object)"3.0", (Object)csv.get("kafka.server:type=BrokerTopicMetrics,name=MessagesInPerSec:FiveMinuteRate"));
    }

    @Test
    public void dateFormat() {
        String dateFormat = "yyyyMMdd-hh:mm:ss";
        String[] args = new String[]{"--jmx-url", jmxUrl, "--date-format", dateFormat, "--report-format", "csv", "--one-time"};
        String out = this.executeAndGetOut(args);
        this.assertNormalExit();
        Map<String, String> csv = this.parseCsv(out);
        Assertions.assertTrue((boolean)this.validDateFormat(dateFormat, csv.get("time")));
    }

    @Test
    public void unknownObjectName() {
        String[] args = new String[]{"--jmx-url", jmxUrl, "--object-name", "kafka.server:type=DummyMetrics,name=MessagesInPerSec", "--wait"};
        String err = this.executeAndGetErr(args);
        this.assertCommandFailure();
        Assertions.assertTrue((boolean)err.contains("Could not find all requested object names after 10000 ms"));
    }

    private static int findRandomOpenPortOnAllLocalInterfaces() throws Exception {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    private String executeAndGetOut(String ... args) {
        return this.execute(args, false);
    }

    private String executeAndGetErr(String ... args) {
        return this.execute(args, true);
    }

    private String execute(String[] args, boolean err) {
        Runnable runnable = () -> {
            try {
                JmxTool.main((String[])args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        return err ? ToolsTestUtils.captureStandardErr(runnable) : ToolsTestUtils.captureStandardOut(runnable);
    }

    private void assertNormalExit() {
        Assertions.assertTrue((boolean)this.exitProcedure.hasExited());
        Assertions.assertEquals((int)0, (int)this.exitProcedure.statusCode());
    }

    private void assertCommandFailure() {
        Assertions.assertTrue((boolean)this.exitProcedure.hasExited());
        Assertions.assertEquals((int)1, (int)this.exitProcedure.statusCode());
    }

    private Map<String, String> parseCsv(String value) {
        HashMap<String, String> result = new HashMap<String, String>();
        Arrays.stream(value.split("\\r?\\n")).forEach(line -> {
            String[] cells = line.split(",\"");
            if (cells.length == 2) {
                result.put(cells[0], cells[1].replaceAll("\"", ""));
            }
        });
        return result;
    }

    private boolean validDateFormat(String format, String value) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setLenient(false);
        try {
            formatter.parse(value);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static class Metrics
    implements MetricsMBean {
        @Override
        public double getFifteenMinuteRate() {
            return 1.0;
        }

        @Override
        public double getFiveMinuteRate() {
            return 3.0;
        }
    }

    public static interface MetricsMBean {
        public double getFifteenMinuteRate();

        public double getFiveMinuteRate();
    }
}

