/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.GroupListing;
import org.apache.kafka.clients.admin.ListGroupsResult;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.KafkaShareConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tools.GroupsCommand;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;

@Timeout(value=60L)
public class GroupsCommandTest {
    private final String bootstrapServer = "localhost:9092";
    private final ToolsTestUtils.MockExitProcedure exitProcedure = new ToolsTestUtils.MockExitProcedure();

    @BeforeEach
    public void setupExitProcedure() {
        Exit.setExitProcedure((Exit.Procedure)this.exitProcedure);
    }

    @AfterEach
    public void resetExitProcedure() {
        Exit.resetExitProcedure();
    }

    @Test
    public void testOptionsNoActionFails() {
        this.assertInitializeInvalidOptionsExitCode(1, new String[]{"--bootstrap-server", "localhost:9092"});
    }

    @Test
    public void testOptionsListSucceeds() {
        GroupsCommand.GroupsCommandOptions opts = new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list"});
        Assertions.assertTrue((boolean)opts.hasListOption());
    }

    @Test
    public void testOptionsListConsumerFilterSucceeds() {
        GroupsCommand.GroupsCommandOptions opts = new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--consumer"});
        Assertions.assertTrue((boolean)opts.hasListOption());
        Assertions.assertTrue((boolean)opts.hasConsumerOption());
    }

    @Test
    public void testOptionsListShareFilterSucceeds() {
        GroupsCommand.GroupsCommandOptions opts = new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--share"});
        Assertions.assertTrue((boolean)opts.hasListOption());
        Assertions.assertTrue((boolean)opts.hasShareOption());
    }

    @Test
    public void testOptionsListStreamsFilterSucceeds() {
        GroupsCommand.GroupsCommandOptions opts = new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--streams"});
        Assertions.assertTrue((boolean)opts.hasListOption());
        Assertions.assertTrue((boolean)opts.hasStreamsOption());
    }

    @Test
    public void testOptionsListProtocolFilterSucceeds() {
        GroupsCommand.GroupsCommandOptions opts = new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--protocol", "anyproto"});
        Assertions.assertTrue((boolean)opts.hasListOption());
        Assertions.assertTrue((boolean)opts.protocol().isPresent());
        Assertions.assertEquals((Object)"anyproto", opts.protocol().get());
    }

    @Test
    public void testOptionsListTypeFilterSucceeds() {
        GroupsCommand.GroupsCommandOptions opts = new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--group-type", "share"});
        Assertions.assertTrue((boolean)opts.hasListOption());
        Assertions.assertTrue((boolean)opts.groupType().isPresent());
        Assertions.assertEquals((Object)GroupType.SHARE, opts.groupType().get());
    }

    @Test
    public void testOptionsListTypeStreamsFilterSucceeds() {
        GroupsCommand.GroupsCommandOptions opts = new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--group-type", "streams"});
        Assertions.assertTrue((boolean)opts.hasListOption());
        Assertions.assertTrue((boolean)opts.groupType().isPresent());
        Assertions.assertEquals((Object)GroupType.STREAMS, opts.groupType().get());
    }

    @Test
    public void testOptionsListInvalidTypeFilterFails() {
        this.assertInitializeInvalidOptionsExitCode(1, new String[]{"--bootstrap-server", "localhost:9092", "--list", "--group-type", "invalid"});
    }

    @Test
    public void testOptionsListProtocolAndTypeFiltersSucceeds() {
        GroupsCommand.GroupsCommandOptions opts = new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--protocol", "anyproto", "--group-type", "share"});
        Assertions.assertTrue((boolean)opts.hasListOption());
        Assertions.assertTrue((boolean)opts.protocol().isPresent());
        Assertions.assertEquals((Object)"anyproto", opts.protocol().get());
        Assertions.assertTrue((boolean)opts.groupType().isPresent());
        Assertions.assertEquals((Object)GroupType.SHARE, opts.groupType().get());
    }

    @Test
    public void testOptionsListConsumerAndShareFilterFails() {
        this.assertInitializeInvalidOptionsExitCode(1, new String[]{"--bootstrap-server", "localhost:9092", "--list", "--consumer", "--share"});
    }

    @Test
    public void testOptionsListShareAndStreamsFilterFails() {
        this.assertInitializeInvalidOptionsExitCode(1, new String[]{"--bootstrap-server", "localhost:9092", "--list", "--share", "--streams"});
    }

    @Test
    public void testOptionsListConsumerAndStreamsFilterFails() {
        this.assertInitializeInvalidOptionsExitCode(1, new String[]{"--bootstrap-server", "localhost:9092", "--list", "--consumer", "--streams"});
    }

    @Test
    public void testOptionsListConsumerAndProtocolFilterFails() {
        this.assertInitializeInvalidOptionsExitCode(1, new String[]{"--bootstrap-server", "localhost:9092", "--list", "--consumer", "--protocol", "anyproto"});
    }

    @Test
    public void testOptionsListConsumerAndTypeFilterFails() {
        this.assertInitializeInvalidOptionsExitCode(1, new String[]{"--bootstrap-server", "localhost:9092", "--list", "--consumer", "--group-type", "share"});
    }

    @Test
    public void testOptionsListShareAndProtocolFilterFails() {
        this.assertInitializeInvalidOptionsExitCode(1, new String[]{"--bootstrap-server", "localhost:9092", "--list", "--share", "--protocol", "anyproto"});
    }

    @Test
    public void testOptionsListShareAndTypeFilterFails() {
        this.assertInitializeInvalidOptionsExitCode(1, new String[]{"--bootstrap-server", "localhost:9092", "--list", "--share", "--group-type", "classic"});
    }

    @Test
    public void testOptionsListStreamsAndProtocolFilterFails() {
        this.assertInitializeInvalidOptionsExitCode(1, new String[]{"--bootstrap-server", "localhost:9092", "--list", "--streams", "--protocol", "anyproto"});
    }

    @Test
    public void testOptionsListStreamsAndTypeFilterFails() {
        this.assertInitializeInvalidOptionsExitCode(1, new String[]{"--bootstrap-server", "localhost:9092", "--list", "--streams", "--group-type", "classic"});
    }

    @Test
    public void testListGroupsEmpty() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        GroupsCommand.GroupsService service = new GroupsCommand.GroupsService(adminClient);
        ListGroupsResult result = AdminClientTestUtils.listGroupsResult((GroupListing[])new GroupListing[0]);
        Mockito.when((Object)adminClient.listGroups()).thenReturn((Object)result);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.listGroups(new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        this.assertCapturedListOutput(capturedOutput, new String[0][]);
    }

    @Test
    public void testListGroups() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        GroupsCommand.GroupsService service = new GroupsCommand.GroupsService(adminClient);
        ListGroupsResult result = AdminClientTestUtils.listGroupsResult((GroupListing[])new GroupListing[]{new GroupListing("CGclassic", Optional.of(GroupType.CLASSIC), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("CGconsumer", Optional.of(GroupType.CONSUMER), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("SG", Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE)), new GroupListing("StrG", Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.STABLE))});
        Mockito.when((Object)adminClient.listGroups()).thenReturn((Object)result);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.listGroups(new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        this.assertCapturedListOutput(capturedOutput, {"CGclassic", "Classic", "consumer"}, {"CGconsumer", "Consumer", "consumer"}, {"SG", "Share", "share"}, {"StrG", "Streams", "streams"});
    }

    @Test
    public void testListGroupsConsumerFilter() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        GroupsCommand.GroupsService service = new GroupsCommand.GroupsService(adminClient);
        ListGroupsResult result = AdminClientTestUtils.listGroupsResult((GroupListing[])new GroupListing[]{new GroupListing("CGclassic", Optional.of(GroupType.CLASSIC), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("CGconsumer", Optional.of(GroupType.CONSUMER), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("SG", Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE)), new GroupListing("StrG", Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.STABLE))});
        Mockito.when((Object)adminClient.listGroups()).thenReturn((Object)result);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.listGroups(new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--consumer"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        this.assertCapturedListOutput(capturedOutput, {"CGclassic", "Classic", "consumer"}, {"CGconsumer", "Consumer", "consumer"});
    }

    @Test
    public void testListGroupsShareFilter() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        GroupsCommand.GroupsService service = new GroupsCommand.GroupsService(adminClient);
        ListGroupsResult result = AdminClientTestUtils.listGroupsResult((GroupListing[])new GroupListing[]{new GroupListing("CGclassic", Optional.of(GroupType.CLASSIC), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("CGconsumer", Optional.of(GroupType.CONSUMER), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("SG", Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE)), new GroupListing("StrG", Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.STABLE))});
        Mockito.when((Object)adminClient.listGroups()).thenReturn((Object)result);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.listGroups(new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--share"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        this.assertCapturedListOutput(capturedOutput, new String[][]{{"SG", "Share", "share"}});
    }

    @Test
    public void testListGroupsStreamsFilter() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        GroupsCommand.GroupsService service = new GroupsCommand.GroupsService(adminClient);
        ListGroupsResult result = AdminClientTestUtils.listGroupsResult((GroupListing[])new GroupListing[]{new GroupListing("CGclassic", Optional.of(GroupType.CLASSIC), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("CGconsumer", Optional.of(GroupType.CONSUMER), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("SG", Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE)), new GroupListing("StrG", Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.STABLE))});
        Mockito.when((Object)adminClient.listGroups()).thenReturn((Object)result);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.listGroups(new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--streams"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        this.assertCapturedListOutput(capturedOutput, new String[][]{{"StrG", "Streams", "streams"}});
    }

    @Test
    public void testListGroupsProtocolFilter() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        GroupsCommand.GroupsService service = new GroupsCommand.GroupsService(adminClient);
        ListGroupsResult result = AdminClientTestUtils.listGroupsResult((GroupListing[])new GroupListing[]{new GroupListing("CGclassic", Optional.of(GroupType.CLASSIC), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("CGconsumer", Optional.of(GroupType.CONSUMER), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("SG", Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE)), new GroupListing("StrG", Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.STABLE))});
        Mockito.when((Object)adminClient.listGroups()).thenReturn((Object)result);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.listGroups(new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--protocol", "consumer"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        this.assertCapturedListOutput(capturedOutput, {"CGclassic", "Classic", "consumer"}, {"CGconsumer", "Consumer", "consumer"});
    }

    @Test
    public void testListGroupsTypeFilter() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        GroupsCommand.GroupsService service = new GroupsCommand.GroupsService(adminClient);
        ListGroupsResult result = AdminClientTestUtils.listGroupsResult((GroupListing[])new GroupListing[]{new GroupListing("CGclassic", Optional.of(GroupType.CLASSIC), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("CGconsumer", Optional.of(GroupType.CONSUMER), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("SG", Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE)), new GroupListing("StrG", Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.STABLE))});
        Mockito.when((Object)adminClient.listGroups()).thenReturn((Object)result);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.listGroups(new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--group-type", "share"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        this.assertCapturedListOutput(capturedOutput, new String[][]{{"SG", "Share", "share"}});
    }

    @Test
    public void testListGroupsProtocolAndTypeFilter() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        GroupsCommand.GroupsService service = new GroupsCommand.GroupsService(adminClient);
        ListGroupsResult result = AdminClientTestUtils.listGroupsResult((GroupListing[])new GroupListing[]{new GroupListing("CGclassic", Optional.of(GroupType.CLASSIC), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("CGconsumer", Optional.of(GroupType.CONSUMER), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("SG", Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE)), new GroupListing("StrG", Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.STABLE))});
        Mockito.when((Object)adminClient.listGroups()).thenReturn((Object)result);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.listGroups(new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--protocol", "consumer", "--group-type", "classic"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        this.assertCapturedListOutput(capturedOutput, new String[][]{{"CGclassic", "Classic", "consumer"}});
    }

    @Test
    public void testListGroupsProtocolAndTypeFilterNoMatch() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        GroupsCommand.GroupsService service = new GroupsCommand.GroupsService(adminClient);
        ListGroupsResult result = AdminClientTestUtils.listGroupsResult((GroupListing[])new GroupListing[]{new GroupListing("CGconsumer", Optional.of(GroupType.CONSUMER), "consumer", Optional.of(GroupState.STABLE)), new GroupListing("SG", Optional.of(GroupType.SHARE), "share", Optional.of(GroupState.STABLE)), new GroupListing("StrG", Optional.of(GroupType.STREAMS), "streams", Optional.of(GroupState.STABLE))});
        Mockito.when((Object)adminClient.listGroups()).thenReturn((Object)result);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.listGroups(new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list", "--protocol", "consumer", "--group-type", "classic"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        this.assertCapturedListOutput(capturedOutput, new String[0][]);
    }

    @Test
    public void testListGroupsFailsWithException() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        GroupsCommand.GroupsService service = new GroupsCommand.GroupsService(adminClient);
        ListGroupsResult result = AdminClientTestUtils.listGroupsResult((KafkaException)Errors.COORDINATOR_NOT_AVAILABLE.exception());
        Mockito.when((Object)adminClient.listGroups()).thenReturn((Object)result);
        Assertions.assertThrows(ExecutionException.class, () -> service.listGroups(new GroupsCommand.GroupsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list"})));
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="group.coordinator.rebalance.protocols", value="classic,consumer,streams"), @ClusterConfigProperty(key="offsets.topic.num.partitions", value="1"), @ClusterConfigProperty(key="offsets.topic.replication.factor", value="1")})
    public void testGroupCommand(ClusterInstance clusterInstance) throws Exception {
        String topic = "topic";
        String outputTopic = "output-topic";
        String classicGroupId = "classic_group";
        String consumerGroupId = "consumer_group";
        String shareGroupId = "share_group";
        String streamsGroupId = "streams_group";
        String simpleGroupId = "simple_group";
        clusterInstance.createTopic(topic, 1, (short)1);
        clusterInstance.createTopic(outputTopic, 1, (short)1);
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        Properties props = new Properties();
        props.put("bootstrap.servers", clusterInstance.bootstrapServers());
        try (KafkaConsumer<String, String> classicGroup = this.createKafkaConsumer(clusterInstance, classicGroupId, GroupProtocol.CLASSIC);
             KafkaConsumer<String, String> consumerGroup = this.createKafkaConsumer(clusterInstance, consumerGroupId, GroupProtocol.CONSUMER);
             KafkaShareConsumer<String, String> shareGroup = this.createKafkaShareConsumer(clusterInstance, shareGroupId);
             KafkaStreams streams = this.createKafkaStreams(clusterInstance, streamsGroupId, topic, outputTopic);
             Admin admin = clusterInstance.admin();
             GroupsCommand.GroupsService groupsCommand = new GroupsCommand.GroupsService(props);){
            classicGroup.subscribe(List.of(topic));
            classicGroup.poll(Duration.ofMillis(1000L));
            consumerGroup.subscribe(List.of(topic));
            consumerGroup.poll(Duration.ofMillis(1000L));
            shareGroup.subscribe(List.of(topic));
            shareGroup.poll(Duration.ofMillis(1000L));
            streams.start();
            AlterConsumerGroupOffsetsResult result = admin.alterConsumerGroupOffsets(simpleGroupId, Map.of(topicPartition, new OffsetAndMetadata(0L)));
            Assertions.assertNull((Object)result.all().get());
            TestUtils.waitForCondition(() -> {
                Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(() -> Assertions.assertDoesNotThrow(() -> groupsCommand.listGroups(new GroupsCommand.GroupsCommandOptions(List.of("--bootstrap-server", clusterInstance.bootstrapServers(), "--list").toArray(new String[0])))));
                if (res.getKey().split("\n").length == 6 && res.getValue().isEmpty()) {
                    this.assertCapturedListOutput(res.getKey(), {classicGroupId, "Classic", "consumer"}, {consumerGroupId, "Consumer", "consumer"}, {simpleGroupId, "Classic"}, {shareGroupId, "Share", "share"}, {streamsGroupId, "Streams", "streams"});
                    return true;
                }
                return false;
            }, (String)"Waiting for listing groups to return all groups");
            TestUtils.waitForCondition(() -> {
                Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(() -> Assertions.assertDoesNotThrow(() -> groupsCommand.listGroups(new GroupsCommand.GroupsCommandOptions(List.of("--bootstrap-server", clusterInstance.bootstrapServers(), "--list", "--consumer").toArray(new String[0])))));
                if (res.getKey().split("\n").length == 4 && res.getValue().isEmpty()) {
                    this.assertCapturedListOutput(res.getKey(), {classicGroupId, "Classic", "consumer"}, {consumerGroupId, "Consumer", "consumer"}, {simpleGroupId, "Classic"});
                    return true;
                }
                return false;
            }, (String)"Waiting for listing groups to return consumer protocol groups");
            TestUtils.waitForCondition(() -> {
                Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(() -> Assertions.assertDoesNotThrow(() -> groupsCommand.listGroups(new GroupsCommand.GroupsCommandOptions(List.of("--bootstrap-server", clusterInstance.bootstrapServers(), "--list", "--group-type", "classic").toArray(new String[0])))));
                if (res.getKey().split("\n").length == 3 && res.getValue().isEmpty()) {
                    this.assertCapturedListOutput(res.getKey(), {classicGroupId, "Classic", "consumer"}, {simpleGroupId, "Classic"});
                    return true;
                }
                return false;
            }, (String)"Waiting for listing groups to return classic type groups");
            TestUtils.waitForCondition(() -> {
                Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(() -> Assertions.assertDoesNotThrow(() -> groupsCommand.listGroups(new GroupsCommand.GroupsCommandOptions(List.of("--bootstrap-server", clusterInstance.bootstrapServers(), "--list", "--group-type", "consumer").toArray(new String[0])))));
                if (res.getKey().split("\n").length == 2 && res.getValue().isEmpty()) {
                    this.assertCapturedListOutput(res.getKey(), new String[][]{{consumerGroupId, "Consumer", "consumer"}});
                    return true;
                }
                return false;
            }, (String)"Waiting for listing groups to return consumer type groups");
            TestUtils.waitForCondition(() -> {
                Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(() -> Assertions.assertDoesNotThrow(() -> groupsCommand.listGroups(new GroupsCommand.GroupsCommandOptions(List.of("--bootstrap-server", clusterInstance.bootstrapServers(), "--list", "--group-type", "share").toArray(new String[0])))));
                if (res.getKey().split("\n").length == 2 && res.getValue().isEmpty()) {
                    this.assertCapturedListOutput(res.getKey(), new String[][]{{shareGroupId, "Share", "share"}});
                    return true;
                }
                return false;
            }, (String)"Waiting for listing groups to return share type groups");
            TestUtils.waitForCondition(() -> {
                Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(() -> Assertions.assertDoesNotThrow(() -> groupsCommand.listGroups(new GroupsCommand.GroupsCommandOptions(List.of("--bootstrap-server", clusterInstance.bootstrapServers(), "--list", "--group-type", "streams").toArray(new String[0])))));
                if (res.getKey().split("\n").length == 2 && res.getValue().isEmpty()) {
                    this.assertCapturedListOutput(res.getKey(), new String[][]{{streamsGroupId, "Streams", "streams"}});
                    return true;
                }
                return false;
            }, (String)"Waiting for listing groups to return streams type groups");
            TestUtils.waitForCondition(() -> {
                Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(() -> Assertions.assertDoesNotThrow(() -> groupsCommand.listGroups(new GroupsCommand.GroupsCommandOptions(List.of("--bootstrap-server", clusterInstance.bootstrapServers(), "--list", "--share").toArray(new String[0])))));
                if (res.getKey().split("\n").length == 2 && res.getValue().isEmpty()) {
                    this.assertCapturedListOutput(res.getKey(), new String[][]{{shareGroupId, "Share", "share"}});
                    return true;
                }
                return false;
            }, (String)"Waiting for listing groups to return share type groups");
            TestUtils.waitForCondition(() -> {
                Map.Entry<String, String> res = ToolsTestUtils.grabConsoleOutputAndError(() -> Assertions.assertDoesNotThrow(() -> groupsCommand.listGroups(new GroupsCommand.GroupsCommandOptions(List.of("--bootstrap-server", clusterInstance.bootstrapServers(), "--list", "--streams").toArray(new String[0])))));
                if (res.getKey().split("\n").length == 2 && res.getValue().isEmpty()) {
                    this.assertCapturedListOutput(res.getKey(), new String[][]{{streamsGroupId, "Streams", "streams"}});
                    return true;
                }
                return false;
            }, (String)"Waiting for listing groups to return streams type groups");
        }
    }

    private void assertInitializeInvalidOptionsExitCode(int expected, String[] options) {
        Exit.setExitProcedure((exitCode, message) -> {
            Assertions.assertEquals((int)expected, (int)exitCode);
            throw new RuntimeException();
        });
        try {
            Assertions.assertThrows(RuntimeException.class, () -> new GroupsCommand.GroupsCommandOptions(options));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    private void assertCapturedListOutput(String capturedOutput, String[] ... expectedLines) {
        String[] capturedLines = capturedOutput.split("\n");
        Assertions.assertEquals((int)(expectedLines.length + 1), (int)capturedLines.length);
        Assertions.assertEquals((Object)"GROUP,TYPE,PROTOCOL", (Object)String.join((CharSequence)",", capturedLines[0].split(" +")));
        int i = 1;
        for (CharSequence[] charSequenceArray : expectedLines) {
            Assertions.assertEquals((Object)String.join((CharSequence)",", charSequenceArray), (Object)String.join((CharSequence)",", capturedLines[i++].split(" +")));
        }
    }

    private KafkaConsumer<String, String> createKafkaConsumer(ClusterInstance clusterInstance, String groupId, GroupProtocol groupProtocol) {
        return new KafkaConsumer(Map.of("bootstrap.servers", clusterInstance.bootstrapServers(), "group.id", groupId, "group.protocol", groupProtocol.name, "key.deserializer", StringDeserializer.class.getName(), "value.deserializer", StringDeserializer.class.getName()));
    }

    private KafkaShareConsumer<String, String> createKafkaShareConsumer(ClusterInstance clusterInstance, String groupId) {
        return new KafkaShareConsumer(Map.of("bootstrap.servers", clusterInstance.bootstrapServers(), "group.id", groupId, "key.deserializer", StringDeserializer.class.getName(), "value.deserializer", StringDeserializer.class.getName()));
    }

    private KafkaStreams createKafkaStreams(ClusterInstance clusterInstance, String groupId, String inputTopic, String outputTopic) {
        StreamsBuilder builder = new StreamsBuilder();
        KStream input = builder.stream(inputTopic);
        input.map((key, value) -> new KeyValue(key, key)).to(outputTopic, Produced.with((Serde)Serdes.Long(), (Serde)Serdes.Long()));
        Topology topology = builder.build();
        Properties properties = new Properties();
        properties.put("bootstrap.servers", clusterInstance.bootstrapServers());
        properties.put("application.id", groupId);
        properties.put("group.protocol", "streams");
        properties.put("default.key.serde", Serdes.String().getClass());
        properties.put("default.value.serde", Serdes.String().getClass());
        return new KafkaStreams(topology, properties);
    }
}

