/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.tools.GetOffsetShell;
import org.apache.kafka.tools.TerseException;
import org.apache.kafka.tools.filter.TopicPartitionFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GetOffsetShellParsingTest {
    GetOffsetShell getOffsetShell = new GetOffsetShell();

    @Test
    public void testTopicPartitionFilterForTopicName() {
        TopicPartitionFilter topicPartitionFilter = this.getOffsetShell.createTopicPartitionFilterWithPatternList("test");
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test"));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicAllowed("test1"));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicAllowed("__consumer_offsets"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 0)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 1)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test1", 0)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 0)));
    }

    @Test
    public void testTopicPartitionFilterForInternalTopicName() {
        TopicPartitionFilter topicPartitionFilter = this.getOffsetShell.createTopicPartitionFilterWithPatternList("__consumer_offsets");
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("__consumer_offsets"));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicAllowed("test1"));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicAllowed("test2"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 0)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 1)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test1", 0)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test2", 0)));
    }

    @Test
    public void testTopicPartitionFilterForTopicNameList() {
        TopicPartitionFilter topicPartitionFilter = this.getOffsetShell.createTopicPartitionFilterWithPatternList("test,test1,__consumer_offsets");
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test1"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("__consumer_offsets"));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicAllowed("test2"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 0)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test1", 1)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 0)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test2", 0)));
    }

    @Test
    public void testTopicPartitionFilterForRegex() {
        TopicPartitionFilter topicPartitionFilter = this.getOffsetShell.createTopicPartitionFilterWithPatternList("test.*");
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test1"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test2"));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicAllowed("__consumer_offsets"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 0)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test1", 1)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test2", 0)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 0)));
    }

    @Test
    public void testTopicPartitionFilterForPartitionIndexSpec() {
        TopicPartitionFilter topicPartitionFilter = this.getOffsetShell.createTopicPartitionFilterWithPatternList(":0");
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test1"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test2"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("__consumer_offsets"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 0)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test1", 0)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test2", 1)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 0)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 1)));
    }

    @Test
    public void testTopicPartitionFilterForPartitionRangeSpec() {
        TopicPartitionFilter topicPartitionFilter = this.getOffsetShell.createTopicPartitionFilterWithPatternList(":1-3");
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test1"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("__consumer_offsets"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test2"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 1)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test1", 2)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 2)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test2", 0)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test2", 3)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 3)));
    }

    @Test
    public void testTopicPartitionFilterForPartitionLowerBoundSpec() {
        TopicPartitionFilter topicPartitionFilter = this.getOffsetShell.createTopicPartitionFilterWithPatternList(":1-");
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test1"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test2"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("__consumer_offsets"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 1)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test1", 2)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 2)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test2", 0)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 0)));
    }

    @Test
    public void testTopicPartitionFilterForPartitionUpperBoundSpec() {
        TopicPartitionFilter topicPartitionFilter = this.getOffsetShell.createTopicPartitionFilterWithPatternList(":-3");
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test1"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test2"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test3"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("__consumer_offsets"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 0)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test1", 1)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test2", 2)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 2)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test3", 3)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 3)));
    }

    @Test
    public void testTopicPartitionFilterComplex() {
        TopicPartitionFilter topicPartitionFilter = this.getOffsetShell.createTopicPartitionFilterWithPatternList("test.*:0,__consumer_offsets:1-2,.*:3");
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("test1"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("custom"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicAllowed("__consumer_offsets"));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 0)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test1", 0)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 1)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test1", 1)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("custom", 3)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("custom", 0)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 1)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 3)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 0)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("__consumer_offsets", 2)));
    }

    @Test
    public void testPartitionFilterForSingleIndex() {
        TopicPartitionFilter topicPartitionFilter = this.getOffsetShell.createTopicPartitionFilterWithPatternList(":1");
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 1)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 0)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 2)));
    }

    @Test
    public void testPartitionFilterForRange() {
        TopicPartitionFilter topicPartitionFilter = this.getOffsetShell.createTopicPartitionFilterWithPatternList(":1-3");
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 0)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 1)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 2)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 3)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 4)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 5)));
    }

    @Test
    public void testPartitionFilterForLowerBound() {
        TopicPartitionFilter topicPartitionFilter = this.getOffsetShell.createTopicPartitionFilterWithPatternList(":3-");
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 0)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 1)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 2)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 3)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 4)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 5)));
    }

    @Test
    public void testPartitionFilterForUpperBound() {
        TopicPartitionFilter topicPartitionFilter = this.getOffsetShell.createTopicPartitionFilterWithPatternList(":-3");
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 0)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 1)));
        Assertions.assertTrue((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 2)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 3)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 4)));
        Assertions.assertFalse((boolean)topicPartitionFilter.isTopicPartitionAllowed(this.getTopicPartition("test", 5)));
    }

    @Test
    public void testPartitionsSetFilter() throws TerseException {
        TopicPartitionFilter partitionsSetFilter = this.getOffsetShell.createTopicPartitionFilterWithTopicAndPartitionPattern("topic", "1,3,5");
        Assertions.assertFalse((boolean)partitionsSetFilter.isTopicPartitionAllowed(this.getTopicPartition("topic", 0)));
        Assertions.assertFalse((boolean)partitionsSetFilter.isTopicPartitionAllowed(this.getTopicPartition("topic", 2)));
        Assertions.assertFalse((boolean)partitionsSetFilter.isTopicPartitionAllowed(this.getTopicPartition("topic", 4)));
        Assertions.assertFalse((boolean)partitionsSetFilter.isTopicPartitionAllowed(this.getTopicPartition("topic1", 1)));
        Assertions.assertFalse((boolean)partitionsSetFilter.isTopicAllowed("topic1"));
        Assertions.assertTrue((boolean)partitionsSetFilter.isTopicPartitionAllowed(this.getTopicPartition("topic", 1)));
        Assertions.assertTrue((boolean)partitionsSetFilter.isTopicPartitionAllowed(this.getTopicPartition("topic", 3)));
        Assertions.assertTrue((boolean)partitionsSetFilter.isTopicPartitionAllowed(this.getTopicPartition("topic", 5)));
        Assertions.assertTrue((boolean)partitionsSetFilter.isTopicAllowed("topic"));
    }

    @Test
    public void testInvalidTimeValue() {
        Assertions.assertThrows(TerseException.class, () -> GetOffsetShell.execute((String[])new String[]{"--bootstrap-server", "localhost:9092", "--time", "invalid"}));
    }

    @Test
    public void testInvalidOffset() {
        Assertions.assertEquals((Object)"Malformed time argument foo. Please use -1 or latest / -2 or earliest / -3 or max-timestamp / -4 or earliest-local / -5 or latest-tiered, or a specified long format timestamp", (Object)((TerseException)Assertions.assertThrows(TerseException.class, () -> GetOffsetShell.parseOffsetSpec((String)"foo"))).getMessage());
    }

    private TopicPartition getTopicPartition(String topic, Integer partition) {
        return new TopicPartition(topic, partition.intValue());
    }
}

