/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.tools.FeatureCommand;
import org.apache.kafka.tools.TerseException;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FeatureCommandTest {
    private final List<Feature> testingFeatures = Arrays.stream(Feature.FEATURES).collect(Collectors.toList());

    @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_3_IV3)
    public void testDescribeWithKRaft(ClusterInstance cluster) {
        String commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)0, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "describe"})));
        List features = Arrays.stream(commandOutput.split("\n")).sorted().collect(Collectors.toList());
        Assertions.assertEquals((Object)"Feature: eligible.leader.replicas.version\tSupportedMinVersion: 0\tSupportedMaxVersion: 1\tFinalizedVersionLevel: 0\t", (Object)this.outputWithoutEpoch((String)features.get(0)));
        Assertions.assertEquals((Object)"Feature: group.version\tSupportedMinVersion: 0\tSupportedMaxVersion: 1\tFinalizedVersionLevel: 0\t", (Object)this.outputWithoutEpoch((String)features.get(1)));
        Assertions.assertEquals((Object)"Feature: kraft.version\tSupportedMinVersion: 0\tSupportedMaxVersion: 1\tFinalizedVersionLevel: 0\t", (Object)this.outputWithoutEpoch((String)features.get(2)));
        Assertions.assertEquals((Object)"Feature: metadata.version\tSupportedMinVersion: 3.3-IV3\tSupportedMaxVersion: 4.2-IV1\tFinalizedVersionLevel: 3.3-IV3\t", (Object)this.outputWithoutEpoch((String)features.get(3)));
        Assertions.assertEquals((Object)"Feature: share.version\tSupportedMinVersion: 0\tSupportedMaxVersion: 1\tFinalizedVersionLevel: 0\t", (Object)this.outputWithoutEpoch((String)features.get(4)));
        Assertions.assertEquals((Object)"Feature: streams.version\tSupportedMinVersion: 0\tSupportedMaxVersion: 1\tFinalizedVersionLevel: 0\t", (Object)this.outputWithoutEpoch((String)features.get(5)));
        Assertions.assertEquals((Object)"Feature: transaction.version\tSupportedMinVersion: 0\tSupportedMaxVersion: 2\tFinalizedVersionLevel: 0\t", (Object)this.outputWithoutEpoch((String)features.get(6)));
    }

    @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_7_IV0)
    public void testDescribeWithKRaftAndBootstrapControllers(ClusterInstance cluster) {
        String commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)0, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-controller", cluster.bootstrapControllers(), "describe"})));
        List features = Arrays.stream(commandOutput.split("\n")).sorted().collect(Collectors.toList());
        Assertions.assertEquals((Object)"Feature: eligible.leader.replicas.version\tSupportedMinVersion: 0\tSupportedMaxVersion: 1\tFinalizedVersionLevel: 0\t", (Object)this.outputWithoutEpoch((String)features.get(0)));
        Assertions.assertEquals((Object)"Feature: group.version\tSupportedMinVersion: 0\tSupportedMaxVersion: 1\tFinalizedVersionLevel: 0\t", (Object)this.outputWithoutEpoch((String)features.get(1)));
        Assertions.assertEquals((Object)"Feature: kraft.version\tSupportedMinVersion: 0\tSupportedMaxVersion: 1\tFinalizedVersionLevel: 0\t", (Object)this.outputWithoutEpoch((String)features.get(2)));
        Assertions.assertEquals((Object)"Feature: metadata.version\tSupportedMinVersion: 3.3-IV3\tSupportedMaxVersion: 4.2-IV1\tFinalizedVersionLevel: 3.7-IV0\t", (Object)this.outputWithoutEpoch((String)features.get(3)));
        Assertions.assertEquals((Object)"Feature: share.version\tSupportedMinVersion: 0\tSupportedMaxVersion: 1\tFinalizedVersionLevel: 0\t", (Object)this.outputWithoutEpoch((String)features.get(4)));
        Assertions.assertEquals((Object)"Feature: streams.version\tSupportedMinVersion: 0\tSupportedMaxVersion: 1\tFinalizedVersionLevel: 0\t", (Object)this.outputWithoutEpoch((String)features.get(5)));
        Assertions.assertEquals((Object)"Feature: transaction.version\tSupportedMinVersion: 0\tSupportedMaxVersion: 2\tFinalizedVersionLevel: 0\t", (Object)this.outputWithoutEpoch((String)features.get(6)));
    }

    @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_3_IV3)
    public void testUpgradeMetadataVersionWithKraft(ClusterInstance cluster) {
        String commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)0, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "upgrade", "--feature", "metadata.version=7"})));
        Assertions.assertEquals((Object)"metadata.version was upgraded to 7.", (Object)commandOutput);
        commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)0, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "upgrade", "--metadata", "3.4-IV0"})));
        Assertions.assertEquals((Object)String.format("`metadata` flag is deprecated and may be removed in a future release.%nmetadata.version was upgraded to 8.", new Object[0]), (Object)commandOutput);
    }

    @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_4_IV0)
    public void testDowngradeMetadataVersionWithKRaft(ClusterInstance cluster) {
        String commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)1, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "disable", "--feature", "metadata.version"})));
        Assertions.assertEquals((Object)String.format("Could not disable metadata.version. The update failed for all features since the following feature had an error: Invalid update version 0 for feature metadata.version. Local controller 3000 only supports versions %s-%s", MetadataVersion.MINIMUM_VERSION.featureLevel(), MetadataVersion.latestTesting().featureLevel()), (Object)commandOutput);
        commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)1, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "downgrade", "--metadata", "3.3-IV3"})));
        Assertions.assertEquals((Object)String.format("`metadata` flag is deprecated and may be removed in a future release.%nCould not downgrade metadata.version to 7. The update failed for all features since the following feature had an error: Invalid metadata.version 7. Refusing to perform the requested downgrade because it might delete metadata information.", new Object[0]), (Object)commandOutput);
        commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)1, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "downgrade", "--unsafe", "--metadata", "3.3-IV3"})));
        Assertions.assertEquals((Object)String.format("`metadata` flag is deprecated and may be removed in a future release.%nCould not downgrade metadata.version to 7. The update failed for all features since the following feature had an error: Invalid metadata.version 7. Unsafe metadata downgrade is not supported in this version.", new Object[0]), (Object)commandOutput);
    }

    @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_8_IV0)
    public void testUpgradeWithReleaseVersion(ClusterInstance cluster) {
        String commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)1, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "upgrade", "--release-version", "3.7-IV3"})));
        Assertions.assertEquals((Object)"Could not upgrade metadata.version to 18. The update failed for all features since the following feature had an error: Invalid update version 18 for feature metadata.version. Can't downgrade the version of this feature without setting the upgrade type to either safe or unsafe downgrade.", (Object)commandOutput);
        commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)0, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "upgrade", "--release-version", "3.9-IV0"})));
        Assertions.assertEquals((Object)"kraft.version was upgraded to 1.\nmetadata.version was upgraded to 21.", (Object)commandOutput);
    }

    @ClusterTest(types={Type.KRAFT}, metadataVersion=MetadataVersion.IBP_3_8_IV0)
    public void testDowngradeWithReleaseVersion(ClusterInstance cluster) {
        String commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)1, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "downgrade", "--release-version", "3.9-IV0"})));
        Assertions.assertTrue((boolean)commandOutput.contains("The update failed for all features since the following feature had an error: Invalid update version 1 for feature kraft.version. Can't downgrade to a newer version."));
        Assertions.assertTrue((boolean)commandOutput.contains("Could not downgrade group.version to 0."));
        Assertions.assertTrue((boolean)commandOutput.contains("Could not downgrade transaction.version to 0."));
        Assertions.assertTrue((boolean)commandOutput.contains("Could not downgrade kraft.version to 1."));
        Assertions.assertTrue((boolean)commandOutput.contains("Could not downgrade metadata.version to 21."));
        commandOutput = ToolsTestUtils.captureStandardOut(() -> Assertions.assertEquals((int)0, (int)FeatureCommand.mainNoExit((String[])new String[]{"--bootstrap-server", cluster.bootstrapServers(), "downgrade", "--release-version", "3.7-IV3"})));
        Assertions.assertEquals((Object)"eligible.leader.replicas.version was downgraded to 0.\ngroup.version was downgraded to 0.\nkraft.version was downgraded to 0.\nmetadata.version was downgraded to 18.\nshare.version was downgraded to 0.\nstreams.version was downgraded to 0.\ntransaction.version was downgraded to 0.", (Object)commandOutput);
    }

    private String outputWithoutEpoch(String output) {
        int pos = output.indexOf("Epoch: ");
        return pos > 0 ? output.substring(0, pos) : output;
    }

    @Test
    public void testLevelToString() {
        Assertions.assertEquals((Object)"5", (Object)FeatureCommand.levelToString((String)"foo.bar", (short)5));
        Assertions.assertEquals((Object)"3.9-IV0", (Object)FeatureCommand.levelToString((String)"metadata.version", (short)MetadataVersion.IBP_3_9_IV0.featureLevel()));
    }

    @Test
    public void testMetadataVersionsToString() {
        Assertions.assertEquals((Object)"3.5-IV0, 3.5-IV1, 3.5-IV2, 3.6-IV0", (Object)FeatureCommand.metadataVersionsToString((MetadataVersion)MetadataVersion.IBP_3_5_IV0, (MetadataVersion)MetadataVersion.IBP_3_6_IV0));
    }

    @Test
    public void testDowngradeType() {
        Assertions.assertEquals((Object)FeatureUpdate.UpgradeType.SAFE_DOWNGRADE, (Object)FeatureCommand.downgradeType((Namespace)new Namespace(Collections.singletonMap("unsafe", Boolean.FALSE))));
        Assertions.assertEquals((Object)FeatureUpdate.UpgradeType.UNSAFE_DOWNGRADE, (Object)FeatureCommand.downgradeType((Namespace)new Namespace(Collections.singletonMap("unsafe", Boolean.TRUE))));
        Assertions.assertEquals((Object)FeatureUpdate.UpgradeType.SAFE_DOWNGRADE, (Object)FeatureCommand.downgradeType((Namespace)new Namespace(Collections.emptyMap())));
    }

    @Test
    public void testParseNameAndLevel() {
        Assertions.assertArrayEquals((Object[])new String[]{"foo.bar", "5"}, (Object[])FeatureCommand.parseNameAndLevel((String)"foo.bar=5"));
        Assertions.assertArrayEquals((Object[])new String[]{"quux", "0"}, (Object[])FeatureCommand.parseNameAndLevel((String)"quux=0"));
        Assertions.assertTrue((boolean)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> FeatureCommand.parseNameAndLevel((String)"baaz"))).getMessage().contains("Can't parse feature=level string baaz: equals sign not found."));
        Assertions.assertTrue((boolean)((RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> FeatureCommand.parseNameAndLevel((String)"w=tf"))).getMessage().contains("Can't parse feature=level string w=tf: unable to parse tf as a short."));
    }

    private static MockAdminClient buildAdminClient() {
        HashMap<String, Short> minSupportedFeatureLevels = new HashMap<String, Short>();
        minSupportedFeatureLevels.put("metadata.version", MetadataVersion.IBP_3_3_IV3.featureLevel());
        minSupportedFeatureLevels.put("foo.bar", (short)0);
        HashMap<String, Short> featureLevels = new HashMap<String, Short>();
        featureLevels.put("metadata.version", MetadataVersion.IBP_3_4_IV0.featureLevel());
        featureLevels.put("foo.bar", (short)5);
        HashMap<String, Short> maxSupportedFeatureLevels = new HashMap<String, Short>();
        maxSupportedFeatureLevels.put("metadata.version", MetadataVersion.IBP_3_5_IV0.featureLevel());
        maxSupportedFeatureLevels.put("foo.bar", (short)10);
        return new MockAdminClient.Builder().minSupportedFeatureLevels(minSupportedFeatureLevels).featureLevels(featureLevels).maxSupportedFeatureLevels(maxSupportedFeatureLevels).build();
    }

    @Test
    public void testHandleDescribe() {
        String describeResult = ToolsTestUtils.captureStandardOut(() -> {
            try {
                FeatureCommand.handleDescribe((Admin)FeatureCommandTest.buildAdminClient());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        Assertions.assertEquals((Object)String.format("Feature: foo.bar\tSupportedMinVersion: 0\tSupportedMaxVersion: 10\tFinalizedVersionLevel: 5\tEpoch: 123%nFeature: metadata.version\tSupportedMinVersion: 3.3-IV3\tSupportedMaxVersion: 3.5-IV0\tFinalizedVersionLevel: 3.4-IV0\tEpoch: 123", new Object[0]), (Object)describeResult);
    }

    @Test
    public void testHandleUpgradeToUnsupportedMetadataVersion() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        namespace.put("metadata", "3.3-IV1");
        namespace.put("feature", Collections.singletonList("foo.bar=6"));
        namespace.put("dry_run", false);
        Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleUpgrade((Namespace)new Namespace(namespace), (Admin)FeatureCommandTest.buildAdminClient()));
        Assertions.assertTrue((boolean)t.getMessage().contains("Unknown metadata.version 3.3-IV1"));
    }

    @Test
    public void testHandleUpgradeToLowerVersion() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        namespace.put("metadata", "3.3-IV3");
        namespace.put("feature", Collections.singletonList("foo.bar=6"));
        namespace.put("dry_run", false);
        String upgradeOutput = ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleUpgrade((Namespace)new Namespace(namespace), (Admin)FeatureCommandTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("2 out of 2 operation(s) failed."));
        });
        Assertions.assertEquals((Object)String.format("`metadata` flag is deprecated and may be removed in a future release.%nCould not upgrade foo.bar to 6. Invalid update version 7 for feature metadata.version. Can't upgrade to lower version.%nCould not upgrade metadata.version to 7. Invalid update version 7 for feature metadata.version. Can't upgrade to lower version.", new Object[0]), (Object)upgradeOutput);
    }

    @Test
    public void testHandleUpgradeToLowerVersionDryRun() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        namespace.put("metadata", "3.3-IV3");
        namespace.put("feature", Collections.singletonList("foo.bar=6"));
        namespace.put("dry_run", true);
        String upgradeOutput = ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleUpgrade((Namespace)new Namespace(namespace), (Admin)FeatureCommandTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("2 out of 2 operation(s) failed."));
        });
        Assertions.assertEquals((Object)String.format("`metadata` flag is deprecated and may be removed in a future release.%nCan not upgrade foo.bar to 6. Invalid update version 7 for feature metadata.version. Can't upgrade to lower version.%nCan not upgrade metadata.version to 7. Invalid update version 7 for feature metadata.version. Can't upgrade to lower version.", new Object[0]), (Object)upgradeOutput);
    }

    @Test
    public void testHandleDowngrade() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        namespace.put("metadata", "3.7-IV0");
        namespace.put("feature", Collections.singletonList("foo.bar=1"));
        namespace.put("dry_run", false);
        String downgradeOutput = ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleDowngrade((Namespace)new Namespace(namespace), (Admin)FeatureCommandTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("2 out of 2 operation(s) failed."));
        });
        Assertions.assertEquals((Object)String.format("`metadata` flag is deprecated and may be removed in a future release.%nCould not downgrade foo.bar to 1. Invalid update version 15 for feature metadata.version. Can't downgrade to newer version.%nCould not downgrade metadata.version to 15. Invalid update version 15 for feature metadata.version. Can't downgrade to newer version.", new Object[0]), (Object)downgradeOutput);
    }

    @Test
    public void testHandleDowngradeDryRun() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        namespace.put("metadata", "3.7-IV0");
        namespace.put("feature", Collections.singletonList("foo.bar=1"));
        namespace.put("dry_run", true);
        String downgradeOutput = ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleDowngrade((Namespace)new Namespace(namespace), (Admin)FeatureCommandTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("2 out of 2 operation(s) failed."));
        });
        Assertions.assertEquals((Object)String.format("`metadata` flag is deprecated and may be removed in a future release.%nCan not downgrade foo.bar to 1. Invalid update version 15 for feature metadata.version. Can't downgrade to newer version.%nCan not downgrade metadata.version to 15. Invalid update version 15 for feature metadata.version. Can't downgrade to newer version.", new Object[0]), (Object)downgradeOutput);
    }

    @Test
    public void testHandleDisable() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        namespace.put("feature", Arrays.asList("foo.bar", "metadata.version", "quux"));
        namespace.put("dry_run", false);
        String disableOutput = ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleDisable((Namespace)new Namespace(namespace), (Admin)FeatureCommandTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("3 out of 3 operation(s) failed."));
        });
        Assertions.assertEquals((Object)String.format("Could not disable foo.bar. Invalid update version 0 for feature metadata.version. Can't downgrade below 7%nCould not disable metadata.version. Invalid update version 0 for feature metadata.version. Can't downgrade below 7%nCould not disable quux. Invalid update version 0 for feature metadata.version. Can't downgrade below 7", new Object[0]), (Object)disableOutput);
    }

    @Test
    public void testHandleDisableDryRun() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        namespace.put("feature", Arrays.asList("foo.bar", "metadata.version", "quux"));
        namespace.put("dry_run", true);
        String disableOutput = ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleDisable((Namespace)new Namespace(namespace), (Admin)FeatureCommandTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("3 out of 3 operation(s) failed."));
        });
        Assertions.assertEquals((Object)String.format("Can not disable foo.bar. Invalid update version 0 for feature metadata.version. Can't downgrade below 7%nCan not disable metadata.version. Invalid update version 0 for feature metadata.version. Can't downgrade below 7%nCan not disable quux. Invalid update version 0 for feature metadata.version. Can't downgrade below 7", new Object[0]), (Object)disableOutput);
    }

    @Test
    public void testInvalidReleaseVersion() {
        HashMap<String, String> namespace = new HashMap<String, String>();
        namespace.put("release_version", "foo");
        ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleUpgrade((Namespace)new Namespace(namespace), (Admin)FeatureCommandTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("Unknown metadata.version foo."));
        });
    }

    @Test
    public void testIncompatibleUpgradeFlags() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        namespace.put("release_version", "3.3-IV3");
        namespace.put("feature", Arrays.asList("foo.bar", "metadata.version", "quux"));
        ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleUpgrade((Namespace)new Namespace(namespace), (Admin)FeatureCommandTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("Can not specify `release-version` with other feature flags."));
        });
        namespace.put("release_version", "3.3-IV3");
        namespace.put("metadata", "3.3-IV3");
        ToolsTestUtils.captureStandardOut(() -> {
            Throwable t = Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleUpgrade((Namespace)new Namespace(namespace), (Admin)FeatureCommandTest.buildAdminClient()));
            Assertions.assertTrue((boolean)t.getMessage().contains("Can not specify `release-version` with other feature flags."));
        });
    }

    @Test
    public void testHandleVersionMappingWithValidReleaseVersion() {
        HashMap<String, String> namespace = new HashMap<String, String>();
        namespace.put("release_version", "3.3-IV3");
        String versionMappingOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                FeatureCommand.handleVersionMapping((Namespace)new Namespace(namespace), this.testingFeatures);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        MetadataVersion metadataVersion = MetadataVersion.IBP_3_3_IV3;
        Assertions.assertTrue((boolean)versionMappingOutput.contains("metadata.version=" + metadataVersion.featureLevel() + " (" + metadataVersion.version() + ")"), (String)("Output did not contain expected Metadata Version: " + versionMappingOutput));
        for (Feature feature : Feature.values()) {
            short featureLevel = feature.defaultLevel(metadataVersion);
            Assertions.assertTrue((boolean)versionMappingOutput.contains(feature.featureName() + "=" + featureLevel), (String)("Output did not contain expected feature mapping: " + versionMappingOutput));
        }
    }

    @Test
    public void testHandleVersionMappingWithNoReleaseVersion() {
        HashMap namespace = new HashMap();
        String versionMappingOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                FeatureCommand.handleVersionMapping((Namespace)new Namespace(namespace), this.testingFeatures);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        MetadataVersion metadataVersion = MetadataVersion.latestProduction();
        Assertions.assertTrue((boolean)versionMappingOutput.contains("metadata.version=" + metadataVersion.featureLevel() + " (" + metadataVersion.version() + ")"), (String)("Output did not contain expected Metadata Version: " + versionMappingOutput));
        for (Feature feature : Feature.values()) {
            short featureLevel = feature.defaultLevel(metadataVersion);
            Assertions.assertTrue((boolean)versionMappingOutput.contains(feature.featureName() + "=" + featureLevel), (String)("Output did not contain expected feature mapping: " + versionMappingOutput));
        }
    }

    @Test
    public void testHandleVersionMappingWithInvalidReleaseVersion() {
        HashMap<String, String> namespace = new HashMap<String, String>();
        namespace.put("release_version", "2.9-IV2");
        TerseException exception1 = (TerseException)Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleVersionMapping((Namespace)new Namespace(namespace), this.testingFeatures));
        Assertions.assertEquals((Object)("Unknown release version '2.9-IV2'. Supported versions are: " + String.valueOf(MetadataVersion.MINIMUM_VERSION) + " to " + String.valueOf(MetadataVersion.LATEST_PRODUCTION)), (Object)exception1.getMessage());
        namespace.put("release_version", "invalid");
        TerseException exception2 = (TerseException)Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleVersionMapping((Namespace)new Namespace(namespace), this.testingFeatures));
        Assertions.assertEquals((Object)("Unknown release version 'invalid'. Supported versions are: " + String.valueOf(MetadataVersion.MINIMUM_VERSION) + " to " + String.valueOf(MetadataVersion.LATEST_PRODUCTION)), (Object)exception2.getMessage());
    }

    @Test
    public void testHandleFeatureDependenciesForFeatureWithDependencies() {
        HashMap<String, List<String>> namespace = new HashMap<String, List<String>>();
        namespace.put("feature", Collections.singletonList("test.feature.version=2"));
        String output = ToolsTestUtils.captureStandardOut(() -> {
            try {
                FeatureCommand.handleFeatureDependencies((Namespace)new Namespace(namespace), this.testingFeatures);
            }
            catch (TerseException e) {
                throw new RuntimeException(e);
            }
        });
        String expectedOutput = String.format("test.feature.version=2 requires:\n    metadata.version=%d (%s)\n", MetadataVersion.latestTesting().featureLevel(), MetadataVersion.latestTesting().version());
        Assertions.assertEquals((Object)expectedOutput.trim(), (Object)output.trim());
    }

    @Test
    public void testHandleFeatureDependenciesForFeatureWithNoDependencies() {
        HashMap<String, List<String>> namespace = new HashMap<String, List<String>>();
        namespace.put("feature", Collections.singletonList("metadata.version=17"));
        String output = ToolsTestUtils.captureStandardOut(() -> {
            try {
                FeatureCommand.handleFeatureDependencies((Namespace)new Namespace(namespace), this.testingFeatures);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        Assertions.assertEquals((Object)"metadata.version=17 (3.7-IV2) has no dependencies.", (Object)output);
    }

    @Test
    public void testHandleFeatureDependenciesForUnknownFeature() {
        HashMap<String, List<String>> namespace = new HashMap<String, List<String>>();
        namespace.put("feature", Collections.singletonList("unknown.feature=1"));
        Exception exception = (Exception)Assertions.assertThrows(TerseException.class, () -> FeatureCommand.handleFeatureDependencies((Namespace)new Namespace(namespace), this.testingFeatures));
        Assertions.assertEquals((Object)"Unknown feature: unknown.feature", (Object)exception.getMessage());
    }

    @Test
    public void testHandleFeatureDependenciesForFeatureWithUnknownFeatureVersion() {
        HashMap<String, List<String>> namespace = new HashMap<String, List<String>>();
        namespace.put("feature", Collections.singletonList("transaction.version=1000"));
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> FeatureCommand.handleFeatureDependencies((Namespace)new Namespace(namespace), this.testingFeatures));
        Assertions.assertEquals((Object)"No feature:transaction.version with feature level 1000", (Object)exception.getMessage());
    }

    @Test
    public void testHandleFeatureDependenciesForInvalidVersionFormat() {
        HashMap<String, List<String>> namespace = new HashMap<String, List<String>>();
        namespace.put("feature", Collections.singletonList("metadata.version=invalid"));
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> FeatureCommand.handleFeatureDependencies((Namespace)new Namespace(namespace), this.testingFeatures));
        Assertions.assertEquals((Object)"Can't parse feature=level string metadata.version=invalid: unable to parse invalid as a short.", (Object)exception.getMessage());
    }

    @Test
    public void testHandleFeatureDependenciesForMultipleFeatures() {
        HashMap<String, List<String>> namespace = new HashMap<String, List<String>>();
        namespace.put("feature", Arrays.asList("transaction.version=2", "group.version=1", "test.feature.version=2"));
        String output = ToolsTestUtils.captureStandardOut(() -> {
            try {
                FeatureCommand.handleFeatureDependencies((Namespace)new Namespace(namespace), this.testingFeatures);
            }
            catch (TerseException e) {
                throw new RuntimeException(e);
            }
        });
        String latestTestingVersionOutput = String.format("test.feature.version=2 requires:\n    metadata.version=%d (%s)\n", MetadataVersion.latestTesting().featureLevel(), MetadataVersion.latestTesting().version());
        String expectedOutput = String.join((CharSequence)"\n", "transaction.version=2 has no dependencies.", "group.version=1 has no dependencies.", latestTestingVersionOutput.trim());
        Assertions.assertEquals((Object)expectedOutput.trim(), (Object)output.trim());
    }
}

