/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.tools.AdminCommandFailedException;
import org.apache.kafka.tools.AdminOperationException;
import org.apache.kafka.tools.DeleteRecordsCommand;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeleteRecordsCommandTest {
    @ClusterTest
    public void testCommand(ClusterInstance cluster) throws Exception {
        HashMap<String, Integer> adminProps = new HashMap<String, Integer>();
        adminProps.put("retries", 1);
        try (Admin admin = cluster.admin(adminProps);){
            Assertions.assertThrows(AdminCommandFailedException.class, () -> DeleteRecordsCommand.execute((Admin)admin, (String)"{\"partitions\":[{\"topic\":\"t\", \"partition\":0, \"offset\":1},{\"topic\":\"t\", \"partition\":0, \"offset\":1}]}", (PrintStream)System.out), (String)"Offset json file contains duplicate topic partitions: t-0");
            admin.createTopics(Collections.singleton(new NewTopic("t", 1, 1))).all().get();
            Properties props = new Properties();
            props.put("bootstrap.servers", cluster.bootstrapServers());
            props.put("key.serializer", StringSerializer.class);
            props.put("value.serializer", StringSerializer.class);
            try (KafkaProducer producer = new KafkaProducer(props);){
                producer.send(new ProducerRecord("t", (Object)"1")).get();
                producer.send(new ProducerRecord("t", (Object)"2")).get();
                producer.send(new ProducerRecord("t", (Object)"3")).get();
            }
            DeleteRecordsCommandTest.executeAndAssertOutput("{\"partitions\":[{\"topic\":\"t\", \"partition\":0, \"offset\":1}]}", "partition: t-0\tlow_watermark: 1", admin);
            DeleteRecordsCommandTest.executeAndAssertOutput("{\"partitions\":[{\"topic\":\"t\", \"partition\":42, \"offset\":42}]}", "partition: t-42\terror", admin);
        }
    }

    private static void executeAndAssertOutput(String json, String expOut, Admin admin) {
        String output = ToolsTestUtils.captureStandardOut(() -> {
            try {
                DeleteRecordsCommand.execute((Admin)admin, (String)json, (PrintStream)System.out);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        Assertions.assertTrue((boolean)output.contains(expOut));
    }

    @Test
    public void testOffsetFileNotExists() {
        Assertions.assertThrows(IOException.class, () -> DeleteRecordsCommand.execute((String[])new String[]{"--bootstrap-server", "localhost:9092", "--offset-json-file", "/not/existing/file"}, (PrintStream)System.out));
        Assertions.assertEquals((int)1, (int)DeleteRecordsCommand.mainNoExit((String[])new String[]{"--bootstrap-server", "localhost:9092", "--offset-json-file", "/not/existing/file"}));
    }

    @Test
    public void testCommandConfigNotExists() {
        Assertions.assertThrows(NoSuchFileException.class, () -> DeleteRecordsCommand.execute((String[])new String[]{"--bootstrap-server", "localhost:9092", "--offset-json-file", "/not/existing/file", "--command-config", "/another/not/existing/file"}, (PrintStream)System.out));
        Assertions.assertEquals((int)1, (int)DeleteRecordsCommand.mainNoExit((String[])new String[]{"--bootstrap-server", "localhost:9092", "--offset-json-file", "/not/existing/file", "--command-config", "/another/not/existing/file"}));
    }

    @Test
    public void testWrongVersion() {
        DeleteRecordsCommandTest.assertCommandThrows(JsonProcessingException.class, "{\"version\":\"string\"}");
        DeleteRecordsCommandTest.assertCommandThrows(AdminOperationException.class, "{\"version\":2}");
    }

    @Test
    public void testWrongPartitions() {
        DeleteRecordsCommandTest.assertCommandThrows(AdminOperationException.class, "{\"version\":1}");
        DeleteRecordsCommandTest.assertCommandThrows(JsonProcessingException.class, "{\"partitions\":2}");
        DeleteRecordsCommandTest.assertCommandThrows(JsonProcessingException.class, "{\"partitions\":{}}");
        DeleteRecordsCommandTest.assertCommandThrows(JsonProcessingException.class, "{\"partitions\":[{}]}");
        DeleteRecordsCommandTest.assertCommandThrows(JsonProcessingException.class, "{\"partitions\":[{\"topic\":\"t\"}]}");
        DeleteRecordsCommandTest.assertCommandThrows(JsonProcessingException.class, "{\"partitions\":[{\"topic\":\"t\", \"partition\": \"\"}]}");
        DeleteRecordsCommandTest.assertCommandThrows(JsonProcessingException.class, "{\"partitions\":[{\"topic\":\"t\", \"partition\": 0}]}");
        DeleteRecordsCommandTest.assertCommandThrows(JsonProcessingException.class, "{\"partitions\":[{\"topic\":\"t\", \"offset\":0}]}");
    }

    @Test
    public void testParse() throws Exception {
        Map res = DeleteRecordsCommand.parseOffsetJsonStringWithoutDedup((String)"{\"partitions\":[{\"topic\":\"t\", \"partition\":0, \"offset\":0},{\"topic\":\"t\", \"partition\":1, \"offset\":1, \"ignored\":\"field\"},{\"topic\":\"t\", \"partition\":0, \"offset\":2},{\"topic\":\"t\", \"partition\":0, \"offset\":0}]}");
        Assertions.assertEquals((int)2, (int)res.size());
        Assertions.assertEquals(Arrays.asList(0L, 2L, 0L), res.get(new TopicPartition("t", 0)));
        Assertions.assertEquals(Collections.singletonList(1L), res.get(new TopicPartition("t", 1)));
    }

    private static void assertCommandThrows(Class<? extends Exception> expectedException, String jsonData) {
        Assertions.assertThrows(expectedException, () -> DeleteRecordsCommand.parseOffsetJsonStringWithoutDedup((String)jsonData));
    }
}

