/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import kafka.utils.TestUtils;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.tools.ConsoleProducer;
import org.apache.kafka.tools.LineMessageReader;
import org.apache.kafka.tools.api.RecordReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ConsoleProducerTest {
    private static final String[] BOOTSTRAP_SERVER_VALID_ARGS = new String[]{"--bootstrap-server", "localhost:1003,localhost:1004", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"};
    private static final String[] INVALID_ARGS = new String[]{"--t", "t3"};
    private static final String[] BOOTSTRAP_SERVER_OVERRIDE = new String[]{"--bootstrap-server", "localhost:1002", "--topic", "t3"};
    private static final String[] CLIENT_ID_OVERRIDE = new String[]{"--bootstrap-server", "localhost:1001", "--topic", "t3", "--producer-property", "client.id=producer-1"};
    private static final String[] BATCH_SIZE_OVERRIDDEN_BY_MAX_PARTITION_MEMORY_BYTES_VALUE = new String[]{"--bootstrap-server", "localhost:1002", "--topic", "t3", "--batch-size", "123", "--max-partition-memory-bytes", "456"};
    private static final String[] BATCH_SIZE_SET_AND_MAX_PARTITION_MEMORY_BYTES_NOT_SET = new String[]{"--bootstrap-server", "localhost:1002", "--topic", "t3", "--batch-size", "123"};
    private static final String[] BATCH_SIZE_NOT_SET_AND_MAX_PARTITION_MEMORY_BYTES_SET = new String[]{"--bootstrap-server", "localhost:1002", "--topic", "t3", "--max-partition-memory-bytes", "456"};
    private static final String[] BATCH_SIZE_DEFAULT = new String[]{"--bootstrap-server", "localhost:1002", "--topic", "t3"};
    private static final String[] TEST_RECORD_READER = new String[]{"--bootstrap-server", "localhost:1002", "--topic", "t3", "--line-reader", TestRecordReader.class.getName()};

    @Test
    public void testValidConfigsBootstrapServer() throws IOException {
        ConsoleProducer.ConsoleProducerOptions opts = new ConsoleProducer.ConsoleProducerOptions(BOOTSTRAP_SERVER_VALID_ARGS);
        ProducerConfig producerConfig = new ProducerConfig(opts.producerProps());
        Assertions.assertEquals(Arrays.asList("localhost:1003", "localhost:1004"), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test
    public void testInvalidConfigs() {
        Exit.setExitProcedure((statusCode, message) -> {
            throw new IllegalArgumentException(message);
        });
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleProducer.ConsoleProducerOptions(INVALID_ARGS));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testParseKeyProp() throws ReflectiveOperationException, IOException {
        ConsoleProducer.ConsoleProducerOptions opts = new ConsoleProducer.ConsoleProducerOptions(BOOTSTRAP_SERVER_VALID_ARGS);
        LineMessageReader reader = (LineMessageReader)Class.forName(opts.readerClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        reader.configure(opts.readerProps());
        Assertions.assertEquals((Object)"#", (Object)reader.keySeparator());
        Assertions.assertTrue((boolean)reader.parseKey());
    }

    @Test
    public void testParseReaderConfigFile() throws Exception {
        File propsFile = TestUtils.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("parse.key=true\n".getBytes());
        propsStream.write("key.separator=|".getBytes());
        propsStream.close();
        String[] args = new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--property", "key.separator=;", "--property", "parse.headers=true", "--reader-config", propsFile.getAbsolutePath()};
        ConsoleProducer.ConsoleProducerOptions opts = new ConsoleProducer.ConsoleProducerOptions(args);
        LineMessageReader reader = (LineMessageReader)Class.forName(opts.readerClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        reader.configure(opts.readerProps());
        Assertions.assertEquals((Object)";", (Object)reader.keySeparator());
        Assertions.assertTrue((boolean)reader.parseKey());
        Assertions.assertTrue((boolean)reader.parseHeaders());
    }

    @Test
    public void testBootstrapServerOverride() throws IOException {
        ConsoleProducer.ConsoleProducerOptions opts = new ConsoleProducer.ConsoleProducerOptions(BOOTSTRAP_SERVER_OVERRIDE);
        ProducerConfig producerConfig = new ProducerConfig(opts.producerProps());
        Assertions.assertEquals(Collections.singletonList("localhost:1002"), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test
    public void testClientIdOverride() throws IOException {
        ConsoleProducer.ConsoleProducerOptions opts = new ConsoleProducer.ConsoleProducerOptions(CLIENT_ID_OVERRIDE);
        ProducerConfig producerConfig = new ProducerConfig(opts.producerProps());
        Assertions.assertEquals((Object)"producer-1", (Object)producerConfig.getString("client.id"));
    }

    @Test
    public void testDefaultClientId() throws IOException {
        ConsoleProducer.ConsoleProducerOptions opts = new ConsoleProducer.ConsoleProducerOptions(BOOTSTRAP_SERVER_VALID_ARGS);
        ProducerConfig producerConfig = new ProducerConfig(opts.producerProps());
        Assertions.assertEquals((Object)"console-producer", (Object)producerConfig.getString("client.id"));
    }

    @Test
    public void testBatchSizeOverriddenByMaxPartitionMemoryBytesValue() throws IOException {
        ConsoleProducer.ConsoleProducerOptions opts = new ConsoleProducer.ConsoleProducerOptions(BATCH_SIZE_OVERRIDDEN_BY_MAX_PARTITION_MEMORY_BYTES_VALUE);
        ProducerConfig producerConfig = new ProducerConfig(opts.producerProps());
        Assertions.assertEquals((int)456, (Integer)producerConfig.getInt("batch.size"));
    }

    @Test
    public void testBatchSizeSetAndMaxPartitionMemoryBytesNotSet() throws IOException {
        ConsoleProducer.ConsoleProducerOptions opts = new ConsoleProducer.ConsoleProducerOptions(BATCH_SIZE_SET_AND_MAX_PARTITION_MEMORY_BYTES_NOT_SET);
        ProducerConfig producerConfig = new ProducerConfig(opts.producerProps());
        Assertions.assertEquals((int)123, (Integer)producerConfig.getInt("batch.size"));
    }

    @Test
    public void testDefaultBatchSize() throws IOException {
        ConsoleProducer.ConsoleProducerOptions opts = new ConsoleProducer.ConsoleProducerOptions(BATCH_SIZE_DEFAULT);
        ProducerConfig producerConfig = new ProducerConfig(opts.producerProps());
        Assertions.assertEquals((int)16384, (Integer)producerConfig.getInt("batch.size"));
    }

    @Test
    public void testBatchSizeNotSetAndMaxPartitionMemoryBytesSet() throws IOException {
        ConsoleProducer.ConsoleProducerOptions opts = new ConsoleProducer.ConsoleProducerOptions(BATCH_SIZE_NOT_SET_AND_MAX_PARTITION_MEMORY_BYTES_SET);
        ProducerConfig producerConfig = new ProducerConfig(opts.producerProps());
        Assertions.assertEquals((int)456, (Integer)producerConfig.getInt("batch.size"));
    }

    @Test
    public void testNewReader() throws Exception {
        ConsoleProducer producer = new ConsoleProducer();
        TestRecordReader reader = (TestRecordReader)producer.messageReader(new ConsoleProducer.ConsoleProducerOptions(TEST_RECORD_READER));
        Assertions.assertEquals((int)1, (int)reader.configureCount());
        Assertions.assertEquals((int)0, (int)reader.closeCount());
        reader.close();
        Assertions.assertEquals((int)1, (int)reader.closeCount());
    }

    @Test
    public void testLoopReader() throws Exception {
        ConsoleProducer producer = new ConsoleProducer();
        TestRecordReader reader = (TestRecordReader)producer.messageReader(new ConsoleProducer.ConsoleProducerOptions(TEST_RECORD_READER));
        producer.loopReader((Producer)Mockito.mock(Producer.class), (RecordReader)reader, false);
        Assertions.assertEquals((int)1, (int)reader.configureCount());
        Assertions.assertEquals((int)1, (int)reader.closeCount());
    }

    public static class TestRecordReader
    implements RecordReader {
        private int configureCount = 0;
        private int closeCount = 0;

        public void configure(Map<String, ?> configs) {
            ++this.configureCount;
        }

        public Iterator<ProducerRecord<byte[], byte[]>> readRecords(InputStream inputStream) {
            return Collections.emptyIterator();
        }

        public void close() {
            ++this.closeCount;
        }

        public int configureCount() {
            return this.configureCount;
        }

        public int closeCount() {
            return this.closeCount;
        }
    }
}

