/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.kafka.connect.runtime.isolation.ClassLoaderFactory;
import org.apache.kafka.connect.runtime.isolation.DelegatingClassLoader;
import org.apache.kafka.connect.runtime.isolation.PluginClassLoaderFactory;
import org.apache.kafka.connect.runtime.isolation.PluginDesc;
import org.apache.kafka.connect.runtime.isolation.PluginScanResult;
import org.apache.kafka.connect.runtime.isolation.PluginType;
import org.apache.kafka.connect.runtime.isolation.PluginUtils;
import org.apache.kafka.connect.runtime.isolation.ReflectionScanner;
import org.apache.kafka.connect.runtime.isolation.ServiceLoaderScanner;
import org.apache.kafka.connect.runtime.isolation.TestPlugins;
import org.apache.kafka.tools.ConnectPluginPath;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectPluginPathTest {
    private static final Logger log = LoggerFactory.getLogger(ConnectPluginPathTest.class);
    private static final int NAME_COL = 0;
    private static final int ALIAS1_COL = 1;
    private static final int ALIAS2_COL = 2;
    private static final int VERSION_COL = 3;
    private static final int TYPE_COL = 4;
    private static final int LOADABLE_COL = 5;
    private static final int MANIFEST_COL = 6;
    private static final int LOCATION_COL = 7;
    @TempDir
    public Path workspace;

    @Test
    public void testNoArguments() {
        CommandResult res = ConnectPluginPathTest.runCommand(new Object[0]);
        Assertions.assertNotEquals((int)0, (int)res.returnCode);
    }

    @Test
    public void testListNoArguments() {
        CommandResult res = ConnectPluginPathTest.runCommand("list");
        Assertions.assertNotEquals((int)0, (int)res.returnCode);
    }

    @ParameterizedTest
    @EnumSource
    public void testListOneLocation(PluginLocationType type) {
        CommandResult res = ConnectPluginPathTest.runCommand("list", "--plugin-location", ConnectPluginPathTest.setupLocation(this.workspace.resolve("location-a"), type, TestPlugins.TestPlugin.NON_MIGRATED_MULTI_PLUGIN));
        Map<String, List<String[]>> table = ConnectPluginPathTest.assertListSuccess(res);
        ConnectPluginPathTest.assertNonMigratedPluginsStatus(table, false);
    }

    @ParameterizedTest
    @EnumSource
    public void testListMultipleLocations(PluginLocationType type) {
        CommandResult res = ConnectPluginPathTest.runCommand("list", "--plugin-location", ConnectPluginPathTest.setupLocation(this.workspace.resolve("location-a"), type, TestPlugins.TestPlugin.NON_MIGRATED_MULTI_PLUGIN), "--plugin-location", ConnectPluginPathTest.setupLocation(this.workspace.resolve("location-b"), type, TestPlugins.TestPlugin.SAMPLING_CONFIGURABLE));
        Map<String, List<String[]>> table = ConnectPluginPathTest.assertListSuccess(res);
        ConnectPluginPathTest.assertNonMigratedPluginsStatus(table, false);
        ConnectPluginPathTest.assertPluginsAreCompatible(table, TestPlugins.TestPlugin.SAMPLING_CONFIGURABLE);
    }

    @ParameterizedTest
    @EnumSource
    public void testListOnePluginPath(PluginLocationType type) {
        CommandResult res = ConnectPluginPathTest.runCommand("list", "--plugin-path", this.setupPluginPathElement(this.workspace.resolve("path-a"), type, TestPlugins.TestPlugin.NON_MIGRATED_MULTI_PLUGIN, TestPlugins.TestPlugin.SAMPLING_CONFIGURABLE));
        Map<String, List<String[]>> table = ConnectPluginPathTest.assertListSuccess(res);
        ConnectPluginPathTest.assertPluginsAreCompatible(table, TestPlugins.TestPlugin.SAMPLING_CONFIGURABLE);
    }

    @ParameterizedTest
    @EnumSource
    public void testListMultiplePluginPaths(PluginLocationType type) {
        CommandResult res = ConnectPluginPathTest.runCommand("list", "--plugin-path", this.setupPluginPathElement(this.workspace.resolve("path-a"), type, TestPlugins.TestPlugin.NON_MIGRATED_MULTI_PLUGIN, TestPlugins.TestPlugin.SAMPLING_CONFIGURABLE), "--plugin-path", this.setupPluginPathElement(this.workspace.resolve("path-b"), type, TestPlugins.TestPlugin.SAMPLING_HEADER_CONVERTER, TestPlugins.TestPlugin.ALIASED_STATIC_FIELD));
        Map<String, List<String[]>> table = ConnectPluginPathTest.assertListSuccess(res);
        ConnectPluginPathTest.assertPluginsAreCompatible(table, TestPlugins.TestPlugin.SAMPLING_CONFIGURABLE, TestPlugins.TestPlugin.ALIASED_STATIC_FIELD);
    }

    @ParameterizedTest
    @EnumSource
    public void testListOneWorkerConfig(PluginLocationType type) {
        CommandResult res = ConnectPluginPathTest.runCommand("list", "--worker-config", ConnectPluginPathTest.setupWorkerConfig(this.workspace.resolve("worker.properties"), this.setupPluginPathElement(this.workspace.resolve("path-a"), type, TestPlugins.TestPlugin.BAD_PACKAGING_CO_LOCATED)));
        Map<String, List<String[]>> table = ConnectPluginPathTest.assertListSuccess(res);
        ConnectPluginPathTest.assertBadPackagingPluginsStatus(table, false);
    }

    @ParameterizedTest
    @EnumSource
    public void testListMultipleWorkerConfigs(PluginLocationType type) {
        CommandResult res = ConnectPluginPathTest.runCommand("list", "--worker-config", ConnectPluginPathTest.setupWorkerConfig(this.workspace.resolve("worker-a.properties"), this.setupPluginPathElement(this.workspace.resolve("path-a"), type, TestPlugins.TestPlugin.NON_MIGRATED_MULTI_PLUGIN)), "--worker-config", ConnectPluginPathTest.setupWorkerConfig(this.workspace.resolve("worker-b.properties"), this.setupPluginPathElement(this.workspace.resolve("path-b"), type, TestPlugins.TestPlugin.SERVICE_LOADER)));
        Map<String, List<String[]>> table = ConnectPluginPathTest.assertListSuccess(res);
        ConnectPluginPathTest.assertNonMigratedPluginsStatus(table, false);
        ConnectPluginPathTest.assertPluginsAreCompatible(table, TestPlugins.TestPlugin.SERVICE_LOADER);
    }

    @ParameterizedTest
    @EnumSource
    public void testSyncManifests(PluginLocationType type) {
        Object[] objectArray = new Object[5];
        objectArray[0] = "sync-manifests";
        objectArray[1] = "--plugin-location";
        PluginLocation locationA = ConnectPluginPathTest.setupLocation(this.workspace.resolve("location-a"), type, TestPlugins.TestPlugin.BAD_PACKAGING_STATIC_INITIALIZER_THROWS_REST_EXTENSION);
        objectArray[2] = locationA;
        objectArray[3] = "--plugin-location";
        PluginLocation locationB = ConnectPluginPathTest.setupLocation(this.workspace.resolve("location-b"), type, TestPlugins.TestPlugin.NON_MIGRATED_CONVERTER);
        objectArray[4] = locationB;
        CommandResult res = ConnectPluginPathTest.runCommand(objectArray);
        Assertions.assertEquals((int)0, (int)res.returnCode);
        ConnectPluginPathTest.assertScanResult(true, TestPlugins.TestPlugin.NON_MIGRATED_CONVERTER, res.reflective);
        ConnectPluginPathTest.assertScanResult(true, TestPlugins.TestPlugin.NON_MIGRATED_CONVERTER, res.serviceLoading);
        Map<String, List<String[]>> table = ConnectPluginPathTest.assertListSuccess(ConnectPluginPathTest.runCommand("list", "--plugin-location", locationA, "--plugin-location", locationB));
        ConnectPluginPathTest.assertNonMigratedPluginsStatus(table, true);
        ConnectPluginPathTest.assertBadPackagingPluginsStatus(table, true);
    }

    @ParameterizedTest
    @EnumSource
    public void testSyncManifestsDryRun(PluginLocationType type) {
        Object[] objectArray = new Object[6];
        objectArray[0] = "sync-manifests";
        objectArray[1] = "--plugin-location";
        PluginLocation locationA = ConnectPluginPathTest.setupLocation(this.workspace.resolve("location-a"), type, TestPlugins.TestPlugin.BAD_PACKAGING_STATIC_INITIALIZER_THROWS_REST_EXTENSION);
        objectArray[2] = locationA;
        objectArray[3] = "--plugin-location";
        PluginLocation locationB = ConnectPluginPathTest.setupLocation(this.workspace.resolve("location-b"), type, TestPlugins.TestPlugin.NON_MIGRATED_CONVERTER);
        objectArray[4] = locationB;
        objectArray[5] = "--dry-run";
        CommandResult res = ConnectPluginPathTest.runCommand(objectArray);
        Assertions.assertEquals((int)0, (int)res.returnCode);
        ConnectPluginPathTest.assertScanResult(true, TestPlugins.TestPlugin.NON_MIGRATED_CONVERTER, res.reflective);
        ConnectPluginPathTest.assertScanResult(false, TestPlugins.TestPlugin.NON_MIGRATED_CONVERTER, res.serviceLoading);
        Map<String, List<String[]>> table = ConnectPluginPathTest.assertListSuccess(ConnectPluginPathTest.runCommand("list", "--plugin-location", locationA, "--plugin-location", locationB));
        ConnectPluginPathTest.assertNonMigratedPluginsStatus(table, false);
        ConnectPluginPathTest.assertBadPackagingPluginsStatus(table, false);
    }

    @ParameterizedTest
    @EnumSource
    public void testSyncManifestsDryRunReadOnlyLocation(PluginLocationType type) {
        PluginLocation locationA = ConnectPluginPathTest.setupLocation(this.workspace.resolve("location-a"), type, TestPlugins.TestPlugin.NON_MIGRATED_MULTI_PLUGIN);
        Assertions.assertTrue((boolean)locationA.path.toFile().setReadOnly());
        CommandResult res = ConnectPluginPathTest.runCommand("sync-manifests", "--plugin-location", locationA, "--dry-run");
        Assertions.assertEquals((int)2, (int)res.returnCode);
    }

    @Test
    public void testSyncManifestsDryRunReadOnlyMetaInf() {
        PluginLocationType type = PluginLocationType.CLASS_HIERARCHY;
        PluginLocation locationA = ConnectPluginPathTest.setupLocation(this.workspace.resolve("location-a"), type, TestPlugins.TestPlugin.NON_MIGRATED_MULTI_PLUGIN);
        String subPath = "META-INF";
        Assertions.assertTrue((boolean)locationA.path.resolve(subPath).toFile().setReadOnly());
        CommandResult res = ConnectPluginPathTest.runCommand("sync-manifests", "--plugin-location", locationA, "--dry-run");
        Assertions.assertEquals((int)2, (int)res.returnCode);
    }

    @Test
    public void testSyncManifestsDryRunReadOnlyServices() {
        PluginLocationType type = PluginLocationType.CLASS_HIERARCHY;
        PluginLocation locationA = ConnectPluginPathTest.setupLocation(this.workspace.resolve("location-a"), type, TestPlugins.TestPlugin.NON_MIGRATED_MULTI_PLUGIN);
        String subPath = "META-INF/services";
        Assertions.assertTrue((boolean)locationA.path.resolve(subPath).toFile().setReadOnly());
        CommandResult res = ConnectPluginPathTest.runCommand("sync-manifests", "--plugin-location", locationA, "--dry-run");
        Assertions.assertEquals((int)2, (int)res.returnCode);
    }

    @Test
    public void testSyncManifestsDryRunReadOnlyManifest() {
        PluginLocationType type = PluginLocationType.CLASS_HIERARCHY;
        PluginLocation locationA = ConnectPluginPathTest.setupLocation(this.workspace.resolve("location-a"), type, TestPlugins.TestPlugin.NON_MIGRATED_MULTI_PLUGIN);
        String subPath = "META-INF/services/" + PluginType.CONNECTOR_CLIENT_CONFIG_OVERRIDE_POLICY.superClass().getName();
        Assertions.assertTrue((boolean)locationA.path.resolve(subPath).toFile().setReadOnly());
        CommandResult res = ConnectPluginPathTest.runCommand("sync-manifests", "--plugin-location", locationA, "--dry-run");
        Assertions.assertEquals((int)2, (int)res.returnCode);
    }

    @ParameterizedTest
    @EnumSource
    public void testSyncManifestsKeepNotFound(PluginLocationType type) {
        Object[] objectArray = new Object[6];
        objectArray[0] = "sync-manifests";
        objectArray[1] = "--plugin-location";
        PluginLocation locationA = ConnectPluginPathTest.setupLocation(this.workspace.resolve("location-a"), type, TestPlugins.TestPlugin.BAD_PACKAGING_STATIC_INITIALIZER_THROWS_REST_EXTENSION);
        objectArray[2] = locationA;
        objectArray[3] = "--plugin-location";
        PluginLocation locationB = ConnectPluginPathTest.setupLocation(this.workspace.resolve("location-b"), type, TestPlugins.TestPlugin.NON_MIGRATED_CONVERTER);
        objectArray[4] = locationB;
        objectArray[5] = "--keep-not-found";
        CommandResult res = ConnectPluginPathTest.runCommand(objectArray);
        Assertions.assertEquals((int)0, (int)res.returnCode);
        ConnectPluginPathTest.assertScanResult(true, TestPlugins.TestPlugin.NON_MIGRATED_CONVERTER, res.reflective);
        ConnectPluginPathTest.assertScanResult(true, TestPlugins.TestPlugin.NON_MIGRATED_CONVERTER, res.serviceLoading);
        ConnectPluginPathTest.assertScanResult(false, TestPlugins.TestPlugin.BAD_PACKAGING_STATIC_INITIALIZER_THROWS_REST_EXTENSION, res.reflective);
        ConnectPluginPathTest.assertScanResult(false, TestPlugins.TestPlugin.BAD_PACKAGING_STATIC_INITIALIZER_THROWS_REST_EXTENSION, res.serviceLoading);
        Map<String, List<String[]>> table = ConnectPluginPathTest.assertListSuccess(ConnectPluginPathTest.runCommand("list", "--plugin-location", locationA, "--plugin-location", locationB));
        ConnectPluginPathTest.assertNonMigratedPluginsStatus(table, true);
        ConnectPluginPathTest.assertBadPackagingPluginsStatus(table, false);
    }

    private static Map<String, List<String[]>> assertListSuccess(CommandResult result) {
        Assertions.assertEquals((int)0, (int)result.returnCode);
        Map<String, List<String[]>> table = ConnectPluginPathTest.parseTable(result.out);
        ConnectPluginPathTest.assertIsolatedPluginsInOutput(result.reflective, table);
        return table;
    }

    private static void assertPluginsAreCompatible(Map<String, List<String[]>> table, TestPlugins.TestPlugin ... plugins) {
        ConnectPluginPathTest.assertPluginMigrationStatus(table, true, true, plugins);
    }

    private static void assertNonMigratedPluginsStatus(Map<String, List<String[]>> table, boolean migrated) {
        ConnectPluginPathTest.assertPluginMigrationStatus(table, true, migrated, TestPlugins.TestPlugin.NON_MIGRATED_CONVERTER, TestPlugins.TestPlugin.NON_MIGRATED_HEADER_CONVERTER, TestPlugins.TestPlugin.NON_MIGRATED_PREDICATE, TestPlugins.TestPlugin.NON_MIGRATED_SINK_CONNECTOR, TestPlugins.TestPlugin.NON_MIGRATED_SOURCE_CONNECTOR, TestPlugins.TestPlugin.NON_MIGRATED_TRANSFORMATION);
        ConnectPluginPathTest.assertPluginMigrationStatus(table, true, migrated ? Boolean.valueOf(true) : null, TestPlugins.TestPlugin.NON_MIGRATED_MULTI_PLUGIN);
    }

    private static void assertBadPackagingPluginsStatus(Map<String, List<String[]>> table, boolean migrated) {
        ConnectPluginPathTest.assertPluginsAreCompatible(table, TestPlugins.TestPlugin.BAD_PACKAGING_CO_LOCATED, TestPlugins.TestPlugin.BAD_PACKAGING_VERSION_METHOD_THROWS_CONNECTOR);
        ConnectPluginPathTest.assertPluginMigrationStatus(table, false, !migrated, TestPlugins.TestPlugin.BAD_PACKAGING_MISSING_SUPERCLASS, TestPlugins.TestPlugin.BAD_PACKAGING_STATIC_INITIALIZER_THROWS_CONNECTOR, TestPlugins.TestPlugin.BAD_PACKAGING_DEFAULT_CONSTRUCTOR_THROWS_CONNECTOR, TestPlugins.TestPlugin.BAD_PACKAGING_DEFAULT_CONSTRUCTOR_PRIVATE_CONNECTOR, TestPlugins.TestPlugin.BAD_PACKAGING_NO_DEFAULT_CONSTRUCTOR_CONNECTOR, TestPlugins.TestPlugin.BAD_PACKAGING_NO_DEFAULT_CONSTRUCTOR_CONVERTER, TestPlugins.TestPlugin.BAD_PACKAGING_NO_DEFAULT_CONSTRUCTOR_OVERRIDE_POLICY, TestPlugins.TestPlugin.BAD_PACKAGING_INNER_CLASS_CONNECTOR, TestPlugins.TestPlugin.BAD_PACKAGING_STATIC_INITIALIZER_THROWS_REST_EXTENSION);
    }

    private static void assertIsolatedPluginsInOutput(PluginScanResult reflectiveResult, Map<String, List<String[]>> table) {
        reflectiveResult.forEach(pluginDesc -> {
            if (pluginDesc.location().equals("classpath")) {
                return;
            }
            Assertions.assertTrue((boolean)table.containsKey(pluginDesc.className()), (String)("Plugin " + pluginDesc.className() + " does not appear in list output"));
            boolean foundType = false;
            for (String[] row : (List)table.get(pluginDesc.className())) {
                if (!row[4].equals(pluginDesc.typeName())) continue;
                foundType = true;
                Assertions.assertTrue((row[1].equals("N/A") || row[1].equals(PluginUtils.simpleName((PluginDesc)pluginDesc)) ? 1 : 0) != 0);
                Assertions.assertTrue((row[2].equals("N/A") || row[2].equals(PluginUtils.prunedName((PluginDesc)pluginDesc)) ? 1 : 0) != 0);
                Assertions.assertEquals((Object)pluginDesc.version(), (Object)row[3]);
                try {
                    Path pluginLocation = Paths.get(row[7], new String[0]);
                    String pluginLocationUrl = pluginLocation.toUri().toURL().toString();
                    Assertions.assertEquals((Object)pluginDesc.location(), (Object)pluginLocationUrl);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            Assertions.assertTrue((boolean)foundType, (String)("Plugin " + pluginDesc.className() + " does not have row for " + pluginDesc.typeName()));
        });
    }

    private static void assertPluginMigrationStatus(Map<String, List<String[]>> table, Boolean loadable, Boolean compatible, TestPlugins.TestPlugin ... plugins) {
        for (TestPlugins.TestPlugin plugin : plugins) {
            if (loadable == null || loadable.booleanValue() || compatible == null || compatible.booleanValue()) {
                Assertions.assertTrue((boolean)table.containsKey(plugin.className()), (String)("Plugin " + plugin.className() + " does not appear in list output"));
                for (Object[] objectArray : table.get(plugin.className())) {
                    log.info("row" + Arrays.toString(objectArray));
                    if (loadable != null) {
                        Assertions.assertEquals((Object)loadable, (Object)Boolean.parseBoolean((String)objectArray[5]), (String)("Plugin loadable column for " + plugin.className() + " incorrect"));
                    }
                    if (compatible == null) continue;
                    Assertions.assertEquals((Object)compatible, (Object)Boolean.parseBoolean((String)objectArray[6]), (String)("Plugin hasManifest column for " + plugin.className() + " incorrect"));
                }
                continue;
            }
            Assertions.assertFalse((boolean)table.containsKey(plugin.className()), (String)("Plugin " + plugin.className() + " should not appear in list output"));
        }
    }

    private static void assertScanResult(boolean expectToBeDiscovered, TestPlugins.TestPlugin plugin, PluginScanResult result) {
        AtomicBoolean actuallyDiscovered = new AtomicBoolean();
        result.forEach(pluginDesc -> {
            if (pluginDesc.className().equals(plugin.className())) {
                actuallyDiscovered.set(true);
            }
        });
        if (expectToBeDiscovered && !actuallyDiscovered.get()) {
            Assertions.fail((String)("Expected plugin " + String.valueOf(plugin) + " to be discoverable, but it was not."));
        } else if (!expectToBeDiscovered && actuallyDiscovered.get()) {
            Assertions.fail((String)("Expected plugin " + String.valueOf(plugin) + " to not be discoverable, but it was."));
        }
    }

    private static PluginLocation setupLocation(Path path, PluginLocationType type, TestPlugins.TestPlugin plugin) {
        try {
            Path jarPath = (Path)TestPlugins.pluginPath((TestPlugins.TestPlugin[])new TestPlugins.TestPlugin[]{plugin}).stream().findFirst().get();
            switch (type.ordinal()) {
                case 0: {
                    try (JarFile jarFile = new JarFile(jarPath.toFile());){
                        jarFile.stream().forEach(jarEntry -> {
                            Path entryPath = path.resolve(jarEntry.getName());
                            try {
                                entryPath.getParent().toFile().mkdirs();
                                Files.copy(jarFile.getInputStream((ZipEntry)jarEntry), entryPath, StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException(e);
                            }
                        });
                    }
                    return new PluginLocation(path);
                }
                case 1: {
                    Path outputJar = path.resolveSibling(String.valueOf(path.getFileName()) + ".jar");
                    outputJar.getParent().toFile().mkdirs();
                    Files.copy(jarPath, outputJar, StandardCopyOption.REPLACE_EXISTING);
                    outputJar.toUri().toURL().openConnection().setDefaultUseCaches(false);
                    return new PluginLocation(outputJar);
                }
                case 2: {
                    Path outputJar = path.resolve(jarPath.getFileName());
                    outputJar.getParent().toFile().mkdirs();
                    Files.copy(jarPath, outputJar, StandardCopyOption.REPLACE_EXISTING);
                    return new PluginLocation(path);
                }
            }
            throw new IllegalArgumentException("Unknown PluginLocationType");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private PluginPathElement setupPluginPathElement(Path path, PluginLocationType type, TestPlugins.TestPlugin ... plugins) {
        ArrayList<PluginLocation> locations = new ArrayList<PluginLocation>();
        for (int i = 0; i < plugins.length; ++i) {
            TestPlugins.TestPlugin plugin = plugins[i];
            locations.add(ConnectPluginPathTest.setupLocation(path.resolve("plugin-" + i), type, plugin));
        }
        return new PluginPathElement(path, locations);
    }

    private static WorkerConfig setupWorkerConfig(Path path, PluginPathElement ... pluginPathElements) {
        path.getParent().toFile().mkdirs();
        Properties properties = new Properties();
        String pluginPath = Arrays.stream(pluginPathElements).map(Object::toString).collect(Collectors.joining(", "));
        properties.setProperty("plugin.path", pluginPath);
        try (OutputStream outputStream = Files.newOutputStream(path, new OpenOption[0]);){
            properties.store(outputStream, "dummy worker properties file");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new WorkerConfig(path, Arrays.asList(pluginPathElements));
    }

    private static CommandResult runCommand(Object ... args) {
        CommandResult commandResult;
        block8: {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            int returnCode = ConnectPluginPath.mainNoExit((String[])Arrays.stream(args).map(Object::toString).toList().toArray(new String[0]), (PrintStream)new PrintStream((OutputStream)out, true, StandardCharsets.UTF_8), (PrintStream)new PrintStream((OutputStream)err, true, StandardCharsets.UTF_8));
            Set<Path> pluginLocations = ConnectPluginPathTest.getPluginLocations(args);
            ClassLoader parent = ConnectPluginPath.class.getClassLoader();
            ClassLoaderFactory factory = new ClassLoaderFactory();
            DelegatingClassLoader delegatingClassLoader = factory.newDelegatingClassLoader(parent);
            try {
                Set sources = PluginUtils.pluginSources(pluginLocations, (ClassLoader)delegatingClassLoader, (PluginClassLoaderFactory)factory);
                String stdout = out.toString(StandardCharsets.UTF_8);
                String stderr = err.toString(StandardCharsets.UTF_8);
                log.info("STDOUT:\n{}", (Object)stdout);
                log.info("STDERR:\n{}", (Object)stderr);
                commandResult = new CommandResult(returnCode, stdout, stderr, new ReflectionScanner().discoverPlugins(sources), new ServiceLoaderScanner().discoverPlugins(sources));
                if (delegatingClassLoader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (delegatingClassLoader != null) {
                        try {
                            delegatingClassLoader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            delegatingClassLoader.close();
        }
        return commandResult;
    }

    private static Set<Path> getPluginLocations(Object[] args) {
        return Arrays.stream(args).flatMap(obj -> {
            if (obj instanceof WorkerConfig) {
                return ((WorkerConfig)obj).pluginPathElements.stream();
            }
            return Stream.of(obj);
        }).flatMap(obj -> {
            if (obj instanceof PluginPathElement) {
                return ((PluginPathElement)obj).locations.stream();
            }
            return Stream.of(obj);
        }).map(obj -> {
            if (obj instanceof PluginLocation) {
                return ((PluginLocation)obj).path;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static Map<String, List<String[]>> parseTable(String listOutput) {
        String[] sections = listOutput.split("\n\\s*\n");
        Assertions.assertTrue((sections.length > 1 ? 1 : 0) != 0, (String)"No empty line in list output");
        String[] rows = sections[0].split("\n");
        HashMap<String, List<String[]>> table = new HashMap<String, List<String[]>>();
        Assertions.assertArrayEquals((Object[])ConnectPluginPath.LIST_TABLE_COLUMNS, (Object[])rows[0].split("\t"), (String)"Table header doesn't have the right columns");
        for (int i = 1; i < rows.length; ++i) {
            String[] row = rows[i].split("\t");
            Assertions.assertEquals((int)ConnectPluginPath.LIST_TABLE_COLUMNS.length, (int)row.length, (String)"Table row is the wrong length");
            table.computeIfAbsent(row[0], ignored -> new ArrayList()).add(row);
        }
        return table;
    }

    private static class CommandResult {
        int returnCode;
        String out;
        String err;
        PluginScanResult reflective;
        PluginScanResult serviceLoading;

        public CommandResult(int returnCode, String out, String err, PluginScanResult reflective, PluginScanResult serviceLoading) {
            this.returnCode = returnCode;
            this.out = out;
            this.err = err;
            this.reflective = reflective;
            this.serviceLoading = serviceLoading;
        }
    }

    private static enum PluginLocationType {
        CLASS_HIERARCHY,
        SINGLE_JAR,
        MULTI_JAR;

    }

    private static class PluginLocation {
        private final Path path;

        private PluginLocation(Path path) {
            this.path = path;
        }

        public String toString() {
            return this.path.toString();
        }
    }

    private static class PluginPathElement {
        private final Path root;
        private final List<PluginLocation> locations;

        private PluginPathElement(Path root, List<PluginLocation> locations) {
            this.root = root;
            this.locations = locations;
        }

        public String toString() {
            return this.root.toString();
        }
    }

    private static class WorkerConfig {
        private final Path configFile;
        private final List<PluginPathElement> pluginPathElements;

        private WorkerConfig(Path configFile, List<PluginPathElement> pluginPathElements) {
            this.configFile = configFile;
            this.pluginPathElements = pluginPathElements;
        }

        public String toString() {
            return this.configFile.toString();
        }
    }
}

