/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.tools.ClusterTool;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClusterToolTest {
    @ClusterTest
    public void testClusterId(ClusterInstance clusterInstance) {
        String output = ToolsTestUtils.captureStandardOut(() -> Assertions.assertDoesNotThrow(() -> ClusterTool.execute((String[])new String[]{"cluster-id", "--bootstrap-server", clusterInstance.bootstrapServers()})));
        Assertions.assertTrue((boolean)output.contains("Cluster ID: " + clusterInstance.clusterId()));
    }

    @ClusterTest(brokers=3)
    public void testUnregister(ClusterInstance clusterInstance) {
        Set brokerIds = clusterInstance.brokerIds();
        brokerIds.removeAll(clusterInstance.controllerIds());
        int brokerId = (Integer)Assertions.assertDoesNotThrow(() -> (Integer)brokerIds.stream().findFirst().get());
        clusterInstance.shutdownBroker(brokerId);
        String output = ToolsTestUtils.captureStandardOut(() -> Assertions.assertDoesNotThrow(() -> ClusterTool.execute((String[])new String[]{"unregister", "--bootstrap-server", clusterInstance.bootstrapServers(), "--id", String.valueOf(brokerId)})));
        Assertions.assertTrue((boolean)output.contains("Broker " + brokerId + " is no longer registered."));
    }

    @ClusterTest(brokers=1, types={Type.KRAFT, Type.CO_KRAFT})
    public void testListEndpointsWithBootstrapServer(ClusterInstance clusterInstance) {
        String output = ToolsTestUtils.captureStandardOut(() -> Assertions.assertDoesNotThrow(() -> ClusterTool.execute((String[])new String[]{"list-endpoints", "--bootstrap-server", clusterInstance.bootstrapServers()})));
        String port = clusterInstance.bootstrapServers().split(":")[1];
        int id = (Integer)clusterInstance.brokerIds().iterator().next();
        String format = "%-10s %-9s %-10s %-10s %-10s %-15s%n%-10s %-9s %-10s %-10s %-10s %-6s";
        String expected = String.format(format, "ID", "HOST", "PORT", "RACK", "STATE", "ENDPOINT_TYPE", id, "localhost", port, "null", "unfenced", "broker");
        Assertions.assertEquals((Object)expected, (Object)output);
    }

    @ClusterTest(brokers=2, types={Type.KRAFT, Type.CO_KRAFT})
    public void testListEndpointsArgumentWithBootstrapServer(ClusterInstance clusterInstance) {
        List brokerIds = clusterInstance.brokerIds().stream().collect(Collectors.toList());
        clusterInstance.shutdownBroker(((Integer)brokerIds.get(0)).intValue());
        List ports = Arrays.stream(clusterInstance.bootstrapServers().split(",")).map(b -> b.split(":")[1]).collect(Collectors.toList());
        String format = "%-10s %-9s %-10s %-10s %-10s %-15s%n%-10s %-9s %-10s %-10s %-10s %-15s%n%-10s %-9s %-10s %-10s %-10s %-6s";
        String expected = String.format(format, "ID", "HOST", "PORT", "RACK", "STATE", "ENDPOINT_TYPE", brokerIds.get(0), "localhost", ports.get(0), "null", "fenced", "broker", brokerIds.get(1), "localhost", ports.get(1), "null", "unfenced", "broker");
        String output = ToolsTestUtils.captureStandardOut(() -> Assertions.assertDoesNotThrow(() -> ClusterTool.execute((String[])new String[]{"list-endpoints", "--bootstrap-server", clusterInstance.bootstrapServers(), "--include-fenced-brokers"})));
        Assertions.assertEquals((Object)expected, (Object)output);
    }

    @ClusterTest(types={Type.KRAFT, Type.CO_KRAFT})
    public void testClusterIdWithBootstrapController(ClusterInstance clusterInstance) {
        String output = ToolsTestUtils.captureStandardOut(() -> Assertions.assertDoesNotThrow(() -> ClusterTool.execute((String[])new String[]{"cluster-id", "--bootstrap-controller", clusterInstance.bootstrapControllers()})));
        Assertions.assertTrue((boolean)output.contains("Cluster ID: " + clusterInstance.clusterId()));
    }

    @ClusterTest(brokers=3, types={Type.KRAFT, Type.CO_KRAFT})
    public void testUnregisterWithBootstrapController(ClusterInstance clusterInstance) {
        Set brokerIds = clusterInstance.brokerIds();
        brokerIds.removeAll(clusterInstance.controllerIds());
        int brokerId = (Integer)Assertions.assertDoesNotThrow(() -> (Integer)brokerIds.stream().findFirst().get());
        clusterInstance.shutdownBroker(brokerId);
        Assertions.assertDoesNotThrow(() -> ClusterTool.execute((String[])new String[]{"unregister", "--bootstrap-controller", clusterInstance.bootstrapControllers(), "--id", String.valueOf(brokerId)}));
    }

    @ClusterTest(brokers=3, types={Type.KRAFT, Type.CO_KRAFT})
    public void testListEndpointsWithBootstrapController(ClusterInstance clusterInstance) {
        String output = ToolsTestUtils.captureStandardOut(() -> Assertions.assertDoesNotThrow(() -> ClusterTool.execute((String[])new String[]{"list-endpoints", "--bootstrap-controller", clusterInstance.bootstrapControllers()})));
        String port = clusterInstance.bootstrapControllers().split(":")[1];
        int id = (Integer)clusterInstance.controllerIds().iterator().next();
        String format = "%-10s %-9s %-10s %-10s %-15s%n%-10s %-9s %-10s %-10s %-10s";
        String expected = String.format(format, "ID", "HOST", "PORT", "RACK", "ENDPOINT_TYPE", id, "localhost", port, "null", "controller");
        Assertions.assertTrue((boolean)output.equals(expected));
    }

    @ClusterTest(brokers=3, types={Type.KRAFT, Type.CO_KRAFT})
    public void testListEndpointsArgumentWithBootstrapController(ClusterInstance clusterInstance) {
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ClusterTool.execute((String[])new String[]{"list-endpoints", "--bootstrap-controller", clusterInstance.bootstrapControllers(), "--include-fenced-brokers"}));
        Assertions.assertEquals((Object)"The option --include-fenced-brokers is only supported with --bootstrap-server option", (Object)exception.getMessage());
    }

    @Test
    public void testPrintClusterId() throws Exception {
        MockAdminClient adminClient = new MockAdminClient.Builder().clusterId("QtNwvtfVQ3GEFpzOmDEE-w").build();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ClusterTool.clusterIdCommand((PrintStream)new PrintStream(stream), (Admin)adminClient);
        Assertions.assertEquals((Object)"Cluster ID: QtNwvtfVQ3GEFpzOmDEE-w\n", (Object)stream.toString());
    }

    @Test
    public void testClusterTooOldToHaveId() throws Exception {
        MockAdminClient adminClient = new MockAdminClient.Builder().clusterId(null).build();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ClusterTool.clusterIdCommand((PrintStream)new PrintStream(stream), (Admin)adminClient);
        Assertions.assertEquals((Object)"No cluster ID found. The Kafka version is probably too old.\n", (Object)stream.toString());
    }

    @Test
    public void testUnregisterBroker() throws Exception {
        MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(3).usingRaftController(true).build();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ClusterTool.unregisterCommand((PrintStream)new PrintStream(stream), (Admin)adminClient, (int)0);
        Assertions.assertEquals((Object)"Broker 0 is no longer registered.\n", (Object)stream.toString());
    }

    @Test
    public void testLegacyModeClusterCannotUnregisterBroker() throws Exception {
        MockAdminClient adminClient = new MockAdminClient.Builder().numBrokers(3).usingRaftController(false).build();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ClusterTool.unregisterCommand((PrintStream)new PrintStream(stream), (Admin)adminClient, (int)0);
        Assertions.assertEquals((Object)"The target cluster does not support the broker unregistration API.\n", (Object)stream.toString());
    }
}

