/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.ListConfigResourcesOptions;
import org.apache.kafka.clients.admin.ListConfigResourcesResult;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.tools.ClientMetricsCommand;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ClientMetricsCommandTest {
    private final String bootstrapServer = "localhost:9092";
    private final String clientMetricsName = "cm";

    @Test
    public void testOptionsNoActionFails() {
        this.assertInitializeInvalidOptionsExitCode(1, new String[]{"--bootstrap-server", "localhost:9092"});
    }

    @Test
    public void testOptionsListSucceeds() {
        ClientMetricsCommand.ClientMetricsCommandOptions opts = new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--list"});
        Assertions.assertTrue((boolean)opts.hasListOption());
    }

    @Test
    public void testOptionsDescribeNoNameSucceeds() {
        ClientMetricsCommand.ClientMetricsCommandOptions opts = new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--describe"});
        Assertions.assertTrue((boolean)opts.hasDescribeOption());
    }

    @Test
    public void testOptionsDescribeWithNameSucceeds() {
        ClientMetricsCommand.ClientMetricsCommandOptions opts = new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--describe", "--name", "cm"});
        Assertions.assertTrue((boolean)opts.hasDescribeOption());
    }

    @Test
    public void testOptionsDeleteNoNameFails() {
        this.assertInitializeInvalidOptionsExitCode(1, new String[]{"--bootstrap-server", "localhost:9092", "--delete"});
    }

    @Test
    public void testOptionsDeleteWithNameSucceeds() {
        ClientMetricsCommand.ClientMetricsCommandOptions opts = new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--delete", "--name", "cm"});
        Assertions.assertTrue((boolean)opts.hasDeleteOption());
    }

    @Test
    public void testOptionsAlterNoNameFails() {
        this.assertInitializeInvalidOptionsExitCode(1, new String[]{"--bootstrap-server", "localhost:9092", "--alter"});
    }

    @Test
    public void testOptionsAlterGenerateNameSucceeds() {
        ClientMetricsCommand.ClientMetricsCommandOptions opts = new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--alter", "--generate-name"});
        Assertions.assertTrue((boolean)opts.hasAlterOption());
    }

    @Test
    public void testOptionsAlterWithNameSucceeds() {
        ClientMetricsCommand.ClientMetricsCommandOptions opts = new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--alter", "--name", "cm"});
        Assertions.assertTrue((boolean)opts.hasAlterOption());
    }

    @Test
    public void testOptionsAlterAllOptionsSucceeds() {
        ClientMetricsCommand.ClientMetricsCommandOptions opts = new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--alter", "--name", "cm", "--interval", "1000", "--match", "client_id=abc", "--metrics", "org.apache.kafka."});
        Assertions.assertTrue((boolean)opts.hasAlterOption());
    }

    @Test
    public void testOptionsAlterInvalidInterval() {
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--alter", "--name", "cm", "--interval", "abc"}));
        Assertions.assertEquals((Object)"Invalid interval value. Enter an integer, or leave empty to reset.", (Object)exception.getMessage());
    }

    @Test
    public void testAlter() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        ClientMetricsCommand.ClientMetricsService service = new ClientMetricsCommand.ClientMetricsService(adminClient);
        AlterConfigsResult result = AdminClientTestUtils.alterConfigsResult((ConfigResource)new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "cm"));
        Mockito.when((Object)adminClient.incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.alterClientMetrics(new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--alter", "--name", "cm", "--metrics", "org.apache.kafka.producer.", "--interval", "5000", "--match", "client_id=CLIENT1"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        Assertions.assertTrue((boolean)capturedOutput.contains("Altered client metrics config for cm."));
    }

    @Test
    public void testAlterGenerateName() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        ClientMetricsCommand.ClientMetricsService service = new ClientMetricsCommand.ClientMetricsService(adminClient);
        AlterConfigsResult result = AdminClientTestUtils.alterConfigsResult((ConfigResource)new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "whatever"));
        Mockito.when((Object)adminClient.incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.alterClientMetrics(new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--alter", "--generate-name", "--metrics", "org.apache.kafka.producer.", "--interval", "5000", "--match", "client_id=CLIENT1"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        Assertions.assertTrue((boolean)capturedOutput.contains("Altered client metrics config"));
    }

    @Test
    public void testAlterResetConfigs() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        ClientMetricsCommand.ClientMetricsService service = new ClientMetricsCommand.ClientMetricsService(adminClient);
        AlterConfigsResult result = AdminClientTestUtils.alterConfigsResult((ConfigResource)new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "cm"));
        ArgumentCaptor configCaptor = ArgumentCaptor.forClass(Map.class);
        Mockito.when((Object)adminClient.incrementalAlterConfigs((Map)configCaptor.capture(), (AlterConfigsOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.alterClientMetrics(new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--alter", "--name", "cm", "--metrics", "", "--interval", "", "--match", ""}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        Map alteredConfigOps = (Map)configCaptor.getValue();
        Assertions.assertNotNull((Object)alteredConfigOps, (String)"alteredConfigOps should not be null");
        Assertions.assertEquals((int)1, (int)alteredConfigOps.size(), (String)"Should have exactly one ConfigResource");
        Assertions.assertEquals((int)3, (int)((Collection)alteredConfigOps.values().iterator().next()).size(), (String)"Should have exactly 3 operations");
        for (Collection operations : alteredConfigOps.values()) {
            for (AlterConfigOp op : operations) {
                Assertions.assertEquals((Object)AlterConfigOp.OpType.DELETE, (Object)op.opType(), (String)("Expected DELETE operation for config: " + op.configEntry().name()));
            }
        }
        Assertions.assertTrue((boolean)capturedOutput.contains("Altered client metrics config for cm."));
    }

    @Test
    public void testDelete() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        ClientMetricsCommand.ClientMetricsService service = new ClientMetricsCommand.ClientMetricsService(adminClient);
        ConfigResource cr = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "cm");
        Config cfg = new Config(Collections.singleton(new ConfigEntry("metrics", "org.apache.kafka.producer.")));
        DescribeConfigsResult describeResult = AdminClientTestUtils.describeConfigsResult((ConfigResource)cr, (Config)cfg);
        Mockito.when((Object)adminClient.describeConfigs((Collection)ArgumentMatchers.any())).thenReturn((Object)describeResult);
        AlterConfigsResult alterResult = AdminClientTestUtils.alterConfigsResult((ConfigResource)cr);
        Mockito.when((Object)adminClient.incrementalAlterConfigs((Map)ArgumentMatchers.any(), (AlterConfigsOptions)ArgumentMatchers.any())).thenReturn((Object)alterResult);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.deleteClientMetrics(new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--delete", "--name", "cm"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        Assertions.assertTrue((boolean)capturedOutput.contains("Deleted client metrics config for cm."));
    }

    @Test
    public void testDescribe() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        ClientMetricsCommand.ClientMetricsService service = new ClientMetricsCommand.ClientMetricsService(adminClient);
        ConfigResource cr = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "cm");
        ListConfigResourcesResult listConfigResourcesResult = AdminClientTestUtils.listConfigResourcesResult(Map.of(ConfigResource.Type.CLIENT_METRICS, Set.of("cm")));
        Mockito.when((Object)adminClient.listConfigResources((Set)ArgumentMatchers.any(), (ListConfigResourcesOptions)ArgumentMatchers.any())).thenReturn((Object)listConfigResourcesResult);
        Config cfg = new Config(Collections.singleton(new ConfigEntry("metrics", "org.apache.kafka.producer.")));
        DescribeConfigsResult describeResult = AdminClientTestUtils.describeConfigsResult((ConfigResource)cr, (Config)cfg);
        Mockito.when((Object)adminClient.describeConfigs((Collection)ArgumentMatchers.any())).thenReturn((Object)describeResult);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.describeClientMetrics(new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--describe", "--name", "cm"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        Assertions.assertTrue((boolean)capturedOutput.contains("Client metrics configs for cm are:"));
        Assertions.assertTrue((boolean)capturedOutput.contains("metrics=org.apache.kafka.producer."));
    }

    @Test
    public void testDescribeNonExistentClientMetric() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        ClientMetricsCommand.ClientMetricsService service = new ClientMetricsCommand.ClientMetricsService(adminClient);
        ListConfigResourcesResult listConfigResourcesResult = AdminClientTestUtils.listConfigResourcesResult(Map.of(ConfigResource.Type.CLIENT_METRICS, Set.of()));
        Mockito.when((Object)adminClient.listConfigResources((Set)ArgumentMatchers.any(), (ListConfigResourcesOptions)ArgumentMatchers.any())).thenReturn((Object)listConfigResourcesResult);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.describeClientMetrics(new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--describe", "--name", "cm"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        Assertions.assertTrue((boolean)capturedOutput.contains("The client metric resource cm doesn't exist and doesn't have dynamic config."));
    }

    @Test
    public void testDescribeAll() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        ClientMetricsCommand.ClientMetricsService service = new ClientMetricsCommand.ClientMetricsService(adminClient);
        ListConfigResourcesResult result = AdminClientTestUtils.listConfigResourcesResult((String[])new String[]{"cm"});
        Mockito.when((Object)adminClient.listConfigResources((Set)ArgumentMatchers.any(), (ListConfigResourcesOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        ConfigResource cr = new ConfigResource(ConfigResource.Type.CLIENT_METRICS, "cm");
        Config cfg = new Config(Collections.singleton(new ConfigEntry("metrics", "org.apache.kafka.producer.")));
        DescribeConfigsResult describeResult = AdminClientTestUtils.describeConfigsResult((ConfigResource)cr, (Config)cfg);
        Mockito.when((Object)adminClient.describeConfigs((Collection)ArgumentMatchers.any())).thenReturn((Object)describeResult);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.describeClientMetrics(new ClientMetricsCommand.ClientMetricsCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--describe"}));
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        Assertions.assertTrue((boolean)capturedOutput.contains("Client metrics configs for cm are:"));
        Assertions.assertTrue((boolean)capturedOutput.contains("metrics=org.apache.kafka.producer."));
    }

    @Test
    public void testList() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        ClientMetricsCommand.ClientMetricsService service = new ClientMetricsCommand.ClientMetricsService(adminClient);
        ListConfigResourcesResult result = AdminClientTestUtils.listConfigResourcesResult((String[])new String[]{"one", "two"});
        Mockito.when((Object)adminClient.listConfigResources((Set)ArgumentMatchers.any(), (ListConfigResourcesOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        String capturedOutput = ToolsTestUtils.captureStandardOut(() -> {
            try {
                service.listClientMetrics();
            }
            catch (Throwable t) {
                Assertions.fail((Throwable)t);
            }
        });
        Assertions.assertEquals((Object)"one,two", (Object)String.join((CharSequence)",", capturedOutput.split("\n")));
    }

    @Test
    public void testListFailsWithUnsupportedVersionException() {
        Admin adminClient = (Admin)Mockito.mock(Admin.class);
        ClientMetricsCommand.ClientMetricsService service = new ClientMetricsCommand.ClientMetricsService(adminClient);
        ListConfigResourcesResult result = AdminClientTestUtils.listConfigResourcesResult((KafkaException)Errors.UNSUPPORTED_VERSION.exception());
        Mockito.when((Object)adminClient.listConfigResources((Set)ArgumentMatchers.any(), (ListConfigResourcesOptions)ArgumentMatchers.any())).thenReturn((Object)result);
        Assertions.assertThrows(ExecutionException.class, () -> service.listClientMetrics());
    }

    private void assertInitializeInvalidOptionsExitCode(int expected, String[] options) {
        Exit.setExitProcedure((exitCode, message) -> {
            Assertions.assertEquals((int)expected, (int)exitCode);
            throw new RuntimeException();
        });
        try {
            Assertions.assertThrows(RuntimeException.class, () -> new ClientMetricsCommand.ClientMetricsCommandOptions(options));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }
}

