/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.tools.BrokerApiVersionsCommand;
import org.apache.kafka.tools.ToolsTestUtils;
import org.junit.jupiter.api.Assertions;

@ClusterTestDefaults(serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})
public class BrokerApiVersionsCommandTest {
    @ClusterTest
    public void testBrokerApiVersionsCommandOutput(ClusterInstance clusterInstance) {
        String output = ToolsTestUtils.grabConsoleOutput(() -> BrokerApiVersionsCommand.mainNoExit((String[])new String[]{"--bootstrap-server", clusterInstance.bootstrapServers()}));
        Iterator lineIter = Arrays.stream(output.split("\n")).iterator();
        Assertions.assertTrue((boolean)lineIter.hasNext());
        Assertions.assertEquals((Object)(clusterInstance.bootstrapServers() + " (id: 0 rack: null isFenced: false) -> ("), lineIter.next());
        ApiMessageType.ListenerType listenerType = ApiMessageType.ListenerType.BROKER;
        NodeApiVersions nodeApiVersions = new NodeApiVersions((Collection)ApiVersionsResponse.filterApis((ApiMessageType.ListenerType)listenerType, (boolean)true, (boolean)true), Collections.emptyList());
        Iterator apiKeysIter = ApiKeys.clientApis().iterator();
        while (apiKeysIter.hasNext()) {
            ApiKeys apiKey = (ApiKeys)apiKeysIter.next();
            String terminator = apiKeysIter.hasNext() ? "," : "";
            StringBuilder lineBuilder = new StringBuilder().append("\t");
            if (apiKey.inScope(listenerType)) {
                ApiVersionsResponseData.ApiVersion apiVersion = nodeApiVersions.apiVersion(apiKey);
                Assertions.assertNotNull((Object)apiVersion, (String)("No apiVersion found for " + String.valueOf(apiKey)));
                String versionRangeStr = apiVersion.minVersion() == apiVersion.maxVersion() ? String.valueOf(apiVersion.minVersion()) : apiVersion.minVersion() + " to " + apiVersion.maxVersion();
                short usableVersion = nodeApiVersions.latestUsableVersion(apiKey);
                if (apiKey == ApiKeys.GET_TELEMETRY_SUBSCRIPTIONS || apiKey == ApiKeys.PUSH_TELEMETRY) {
                    lineBuilder.append(apiKey.name).append("(").append(apiKey.id).append("): UNSUPPORTED").append(terminator);
                } else {
                    lineBuilder.append(apiKey.name).append("(").append(apiKey.id).append("): ").append(versionRangeStr).append(" [usable: ").append(usableVersion).append("]").append(terminator);
                }
            } else {
                lineBuilder.append(apiKey.name).append("(").append(apiKey.id).append("): UNSUPPORTED").append(terminator);
            }
            Assertions.assertTrue((boolean)lineIter.hasNext());
            Assertions.assertEquals((Object)lineBuilder.toString(), lineIter.next());
        }
        Assertions.assertTrue((boolean)lineIter.hasNext());
        Assertions.assertEquals((Object)")", lineIter.next());
        Assertions.assertFalse((boolean)lineIter.hasNext());
    }

    @ClusterTest
    public void testAdminSendNoBlock(ClusterInstance clusterInstance) {
        Properties props = new Properties();
        props.put("bootstrap.servers", clusterInstance.bootstrapServers());
        try (BrokerApiVersionsCommand.AdminClient admin = BrokerApiVersionsCommand.AdminClient.create((Properties)props);){
            int brokerId = (Integer)clusterInstance.brokers().keySet().iterator().next();
            KafkaFuture future = admin.getNodeApiVersions(new Node(brokerId + 1, "localhost", 9093, null));
            Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        }
    }
}

