/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.management.InstanceAlreadyExistsException;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.test.ClusterInstance;
import org.apache.kafka.common.test.api.ClusterConfigProperty;
import org.apache.kafka.common.test.api.ClusterTest;
import org.apache.kafka.common.test.api.ClusterTestDefaults;
import org.apache.kafka.common.test.api.Type;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.LogCaptureAppender;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.test.TestUtils;
import org.apache.kafka.tools.AclCommand;
import org.apache.kafka.tools.ToolsTestUtils;
import org.apache.logging.log4j.Level;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@ClusterTestDefaults(types={Type.KRAFT}, serverProperties={@ClusterConfigProperty(key="super.users", value="User:ANONYMOUS"), @ClusterConfigProperty(key="authorizer.class.name", value="org.apache.kafka.metadata.authorizer.StandardAuthorizer")})
public class AclCommandTest {
    public static final String STANDARD_AUTHORIZER = "org.apache.kafka.metadata.authorizer.StandardAuthorizer";
    private static final String LOCALHOST = "localhost:9092";
    private static final String ADD = "--add";
    private static final String BOOTSTRAP_SERVER = "--bootstrap-server";
    private static final String BOOTSTRAP_CONTROLLER = "--bootstrap-controller";
    private static final String COMMAND_CONFIG = "--command-config";
    private static final String CONSUMER = "--consumer";
    private static final String IDEMPOTENT = "--idempotent";
    private static final String GROUP = "--group";
    private static final String LIST = "--list";
    private static final String REMOVE = "--remove";
    private static final String PRODUCER = "--producer";
    private static final String OPERATION = "--operation";
    private static final String TOPIC = "--topic";
    private static final String RESOURCE_PATTERN_TYPE = "--resource-pattern-type";
    private static final KafkaPrincipal PRINCIPAL = SecurityUtils.parseKafkaPrincipal((String)"User:test2");
    private static final Set<KafkaPrincipal> USERS = Set.of(SecurityUtils.parseKafkaPrincipal((String)"User:CN=writeuser,OU=Unknown,O=Unknown,L=Unknown,ST=Unknown,C=Unknown"), PRINCIPAL, SecurityUtils.parseKafkaPrincipal((String)"User:CN=\\#User with special chars in CN : (\\, \\+ \" \\ \\< \\> \\; ')"));
    private static final Set<String> HOSTS = Set.of("host1", "host2");
    private static final List<String> ALLOW_HOST_COMMAND = List.of("--allow-host", "host1", "--allow-host", "host2");
    private static final List<String> DENY_HOST_COMMAND = List.of("--deny-host", "host1", "--deny-host", "host2");
    private static final ResourcePattern CLUSTER_RESOURCE = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
    private static final Set<ResourcePattern> TOPIC_RESOURCES = Set.of(new ResourcePattern(ResourceType.TOPIC, "test-1", PatternType.LITERAL), new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL));
    private static final Set<ResourcePattern> GROUP_RESOURCES = Set.of(new ResourcePattern(ResourceType.GROUP, "testGroup-1", PatternType.LITERAL), new ResourcePattern(ResourceType.GROUP, "testGroup-2", PatternType.LITERAL));
    private static final Set<ResourcePattern> TRANSACTIONAL_ID_RESOURCES = Set.of(new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t0", PatternType.LITERAL), new ResourcePattern(ResourceType.TRANSACTIONAL_ID, "t1", PatternType.LITERAL));
    private static final Set<ResourcePattern> TOKEN_RESOURCES = Set.of(new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token1", PatternType.LITERAL), new ResourcePattern(ResourceType.DELEGATION_TOKEN, "token2", PatternType.LITERAL));
    private static final Set<ResourcePattern> USER_RESOURCES = Set.of(new ResourcePattern(ResourceType.USER, "User:test-user1", PatternType.LITERAL), new ResourcePattern(ResourceType.USER, "User:test-user2", PatternType.LITERAL));
    private static final Map<Set<ResourcePattern>, List<String>> RESOURCE_TO_COMMAND = Map.of(TOPIC_RESOURCES, List.of("--topic", "test-1", "--topic", "test-2"), Set.of(CLUSTER_RESOURCE), List.of("--cluster"), GROUP_RESOURCES, List.of("--group", "testGroup-1", "--group", "testGroup-2"), TRANSACTIONAL_ID_RESOURCES, List.of("--transactional-id", "t0", "--transactional-id", "t1"), TOKEN_RESOURCES, List.of("--delegation-token", "token1", "--delegation-token", "token2"), USER_RESOURCES, List.of("--user-principal", "User:test-user1", "--user-principal", "User:test-user2"));
    private static final Map<Set<ResourcePattern>, Map.Entry<Set<AclOperation>, List<String>>> RESOURCE_TO_OPERATIONS = Map.of(TOPIC_RESOURCES, Map.entry(Set.of(AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.ALTER), List.of("--operation", "Read", "--operation", "Write", "--operation", "Create", "--operation", "Describe", "--operation", "Delete", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "Alter")), Set.of(CLUSTER_RESOURCE), Map.entry(Set.of(AclOperation.CREATE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.ALTER, AclOperation.DESCRIBE), List.of("--operation", "Create", "--operation", "ClusterAction", "--operation", "DescribeConfigs", "--operation", "AlterConfigs", "--operation", "IdempotentWrite", "--operation", "Alter", "--operation", "Describe")), GROUP_RESOURCES, Map.entry(Set.of(AclOperation.READ, AclOperation.DESCRIBE, AclOperation.DELETE), List.of("--operation", "Read", "--operation", "Describe", "--operation", "Delete")), TRANSACTIONAL_ID_RESOURCES, Map.entry(Set.of(AclOperation.DESCRIBE, AclOperation.WRITE, AclOperation.TWO_PHASE_COMMIT), List.of("--operation", "Describe", "--operation", "Write", "--operation", "TwoPhaseCommit")), TOKEN_RESOURCES, Map.entry(Set.of(AclOperation.DESCRIBE), List.of("--operation", "Describe")), USER_RESOURCES, Map.entry(Set.of(AclOperation.CREATE_TOKENS, AclOperation.DESCRIBE_TOKENS), List.of("--operation", "CreateTokens", "--operation", "DescribeTokens")));
    private static final Map<Set<ResourcePattern>, Set<AccessControlEntry>> CONSUMER_RESOURCE_TO_ACLS = Map.of(TOPIC_RESOURCES, AclCommand.getAcls(USERS, (AclPermissionType)AclPermissionType.ALLOW, Set.of(AclOperation.READ, AclOperation.DESCRIBE), HOSTS), GROUP_RESOURCES, AclCommand.getAcls(USERS, (AclPermissionType)AclPermissionType.ALLOW, Set.of(AclOperation.READ), HOSTS));
    private static final Map<List<String>, Map<Set<ResourcePattern>, Set<AccessControlEntry>>> CMD_TO_RESOURCES_TO_ACL = Map.of(List.of("--producer"), AclCommandTest.producerResourceToAcls(false), List.of("--producer", "--idempotent"), AclCommandTest.producerResourceToAcls(true), List.of("--consumer"), CONSUMER_RESOURCE_TO_ACLS, List.of("--producer", "--consumer"), CONSUMER_RESOURCE_TO_ACLS.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
        HashSet value = new HashSet((Collection)entry.getValue());
        value.addAll(AclCommandTest.producerResourceToAcls(false).getOrDefault(entry.getKey(), Set.of()));
        return value;
    })), List.of("--producer", "--idempotent", "--consumer"), CONSUMER_RESOURCE_TO_ACLS.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
        HashSet value = new HashSet((Collection)entry.getValue());
        value.addAll(AclCommandTest.producerResourceToAcls(true).getOrDefault(entry.getKey(), Set.of()));
        return value;
    })));

    @ClusterTest
    public void testAclCliWithAdminAPI(ClusterInstance cluster) throws InterruptedException {
        this.testAclCli(cluster, this.adminArgs(cluster.bootstrapServers(), Optional.empty()));
    }

    @ClusterTest
    public void testAclCliWithAdminAPIAndBootstrapController(ClusterInstance cluster) throws InterruptedException {
        this.testAclCli(cluster, this.adminArgsWithBootstrapController(cluster.bootstrapControllers(), Optional.empty()));
    }

    @ClusterTest
    public void testAclCliWithMisusingBootstrapServerToController(ClusterInstance cluster) {
        Assertions.assertThrows(RuntimeException.class, () -> this.testAclCli(cluster, this.adminArgsWithBootstrapController(cluster.bootstrapServers(), Optional.empty())));
    }

    @ClusterTest
    public void testAclCliWithMisusingBootstrapControllerToServer(ClusterInstance cluster) {
        Assertions.assertThrows(RuntimeException.class, () -> this.testAclCli(cluster, this.adminArgs(cluster.bootstrapControllers(), Optional.empty())));
    }

    @ClusterTest
    public void testProducerConsumerCliWithAdminAPI(ClusterInstance cluster) throws InterruptedException {
        this.testProducerConsumerCli(cluster, this.adminArgs(cluster.bootstrapServers(), Optional.empty()));
    }

    @ClusterTest
    public void testProducerConsumerCliWithAdminAPIAndBootstrapController(ClusterInstance cluster) throws InterruptedException {
        this.testProducerConsumerCli(cluster, this.adminArgsWithBootstrapController(cluster.bootstrapControllers(), Optional.empty()));
    }

    @ClusterTest
    public void testAclCliWithClientId(ClusterInstance cluster) throws IOException, InterruptedException {
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister();){
            appender.setClassLogger(AppInfoParser.class, Level.WARN);
            this.testAclCli(cluster, this.adminArgs(cluster.bootstrapServers(), Optional.of(TestUtils.tempFile((String)"client.id=my-client"))));
            Assertions.assertEquals((long)0L, (long)appender.getEvents().stream().filter(e -> e.getLevel().equals(Level.WARN.toString())).filter(e -> e.getThrowableClassName().filter(name -> name.equals(InstanceAlreadyExistsException.class.getName())).isPresent()).count(), (String)"There should be no warnings about multiple registration of mbeans");
        }
    }

    @ClusterTest
    public void testAclCliWithClientIdAndBootstrapController(ClusterInstance cluster) throws IOException, InterruptedException {
        try (LogCaptureAppender appender = LogCaptureAppender.createAndRegister();){
            appender.setClassLogger(AppInfoParser.class, Level.WARN);
            this.testAclCli(cluster, this.adminArgsWithBootstrapController(cluster.bootstrapControllers(), Optional.of(TestUtils.tempFile((String)"client.id=my-client"))));
            Assertions.assertEquals((long)0L, (long)appender.getEvents().stream().filter(e -> e.getLevel().equals(Level.WARN.toString())).filter(e -> e.getThrowableClassName().filter(name -> name.equals(InstanceAlreadyExistsException.class.getName())).isPresent()).count(), (String)"There should be no warnings about multiple registration of mbeans");
        }
    }

    @ClusterTest
    public void testAclsOnPrefixedResourcesWithAdminAPI(ClusterInstance cluster) throws InterruptedException {
        this.testAclsOnPrefixedResources(cluster, this.adminArgs(cluster.bootstrapServers(), Optional.empty()));
    }

    @ClusterTest
    public void testAclsOnPrefixedResourcesWithAdminAPIAndBootstrapController(ClusterInstance cluster) throws InterruptedException {
        this.testAclsOnPrefixedResources(cluster, this.adminArgsWithBootstrapController(cluster.bootstrapControllers(), Optional.empty()));
    }

    @ClusterTest
    public void testPatternTypesWithAdminAPI(ClusterInstance cluster) {
        this.testPatternTypes(this.adminArgs(cluster.bootstrapServers(), Optional.empty()));
    }

    @ClusterTest
    public void testPatternTypesWithAdminAPIAndBootstrapController(ClusterInstance cluster) {
        this.testPatternTypes(this.adminArgsWithBootstrapController(cluster.bootstrapControllers(), Optional.empty()));
    }

    @Test
    public void testUseBootstrapServerOptWithBootstrapControllerOpt() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(List.of(BOOTSTRAP_SERVER, LOCALHOST, BOOTSTRAP_CONTROLLER, LOCALHOST), "Only one of --bootstrap-server or --bootstrap-controller must be specified");
    }

    @Test
    public void testUseWithoutBootstrapServerOptAndBootstrapControllerOpt() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(List.of(ADD), "One of --bootstrap-server or --bootstrap-controller must be specified");
    }

    @Test
    public void testExactlyOneAction() {
        String errMsg = "Command must include exactly one action: --list, --add, --remove. ";
        this.assertInitializeInvalidOptionsExitCodeAndMsg(List.of(BOOTSTRAP_SERVER, LOCALHOST, ADD, LIST), errMsg);
        this.assertInitializeInvalidOptionsExitCodeAndMsg(List.of(BOOTSTRAP_SERVER, LOCALHOST, ADD, LIST, REMOVE), errMsg);
    }

    @Test
    public void testUseListPrincipalsOptWithoutListOpt() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(List.of(BOOTSTRAP_SERVER, LOCALHOST, ADD, "--principal", "User:CN=client"), "The --principal option is only available if --list is set");
    }

    @Test
    public void testUseProducerOptWithoutTopicOpt() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(List.of(BOOTSTRAP_SERVER, LOCALHOST, ADD, PRODUCER), "With --producer you must specify a --topic");
    }

    @Test
    public void testUseIdempotentOptWithoutProducerOpt() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(List.of(BOOTSTRAP_SERVER, LOCALHOST, ADD, IDEMPOTENT), "The --idempotent option is only available if --producer is set");
    }

    @Test
    public void testUseConsumerOptWithoutRequiredOpt() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(List.of(BOOTSTRAP_SERVER, LOCALHOST, ADD, CONSUMER), "With --consumer you must specify a --topic and a --group and no --cluster or --transactional-id option should be specified.");
        this.checkNotThrow(List.of(BOOTSTRAP_SERVER, LOCALHOST, ADD, CONSUMER, TOPIC, "test-topic", GROUP, "test-group"));
    }

    @Test
    public void testInvalidArgs() {
        this.assertInitializeInvalidOptionsExitCodeAndMsg(List.of(BOOTSTRAP_SERVER, LOCALHOST, LIST, PRODUCER), "Option \"[list]\" can't be used with option \"[producer]\"");
        this.assertInitializeInvalidOptionsExitCodeAndMsg(List.of(BOOTSTRAP_SERVER, LOCALHOST, ADD, PRODUCER, OPERATION, "all"), "Option \"[producer]\" can't be used with option \"[operation]\"");
        this.assertInitializeInvalidOptionsExitCodeAndMsg(List.of(BOOTSTRAP_SERVER, LOCALHOST, ADD, CONSUMER, OPERATION, TOPIC, "test-topic", GROUP, "test-group"), "Option \"[consumer]\" can't be used with option \"[operation]\"");
    }

    private void testProducerConsumerCli(ClusterInstance cluster, List<String> cmdArgs) throws InterruptedException {
        for (Map.Entry<List<String>, Map<Set<ResourcePattern>, Set<AccessControlEntry>>> entry : CMD_TO_RESOURCES_TO_ACL.entrySet()) {
            List<String> cmd = entry.getKey();
            Map<Set<ResourcePattern>, Set<AccessControlEntry>> resourcesToAcls = entry.getValue();
            List resourceCommand = resourcesToAcls.keySet().stream().map(RESOURCE_TO_COMMAND::get).reduce(new ArrayList(), (list, commands) -> {
                list.addAll(commands);
                return list;
            });
            ArrayList<String> args = new ArrayList<String>(cmdArgs);
            args.addAll(this.getCmd(AclPermissionType.ALLOW));
            args.addAll(resourceCommand);
            args.addAll(cmd);
            args.add(ADD);
            this.callMain(args);
            for (Map.Entry<Set<ResourcePattern>, Set<AccessControlEntry>> resourcesToAclsEntry : resourcesToAcls.entrySet()) {
                for (ResourcePattern resource : resourcesToAclsEntry.getKey()) {
                    cluster.waitAcls(new AclBindingFilter(resource.toFilter(), AccessControlEntryFilter.ANY), (Collection)resourcesToAclsEntry.getValue());
                }
            }
            ArrayList<String> resourceCmd = new ArrayList<String>(resourceCommand);
            resourceCmd.addAll(cmd);
            this.testRemove(cluster, cmdArgs, resourcesToAcls.keySet().stream().flatMap(Collection::stream).collect(Collectors.toSet()), resourceCmd);
        }
    }

    private void testAclsOnPrefixedResources(ClusterInstance cluster, List<String> cmdArgs) throws InterruptedException {
        List<String> cmd = List.of("--allow-principal", PRINCIPAL.toString(), PRODUCER, TOPIC, "Test-", RESOURCE_PATTERN_TYPE, "Prefixed");
        ArrayList<String> args = new ArrayList<String>(cmdArgs);
        args.addAll(cmd);
        args.add(ADD);
        this.callMain(args);
        AccessControlEntry writeAcl = new AccessControlEntry(PRINCIPAL.toString(), "*", AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry describeAcl = new AccessControlEntry(PRINCIPAL.toString(), "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry createAcl = new AccessControlEntry(PRINCIPAL.toString(), "*", AclOperation.CREATE, AclPermissionType.ALLOW);
        cluster.waitAcls(new AclBindingFilter(new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED).toFilter(), AccessControlEntryFilter.ANY), List.of(writeAcl, describeAcl, createAcl));
        args = new ArrayList<String>(cmdArgs);
        args.addAll(cmd);
        args.add(REMOVE);
        args.add("--force");
        this.callMain(args);
        cluster.waitAcls(new AclBindingFilter(new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.PREFIXED).toFilter(), AccessControlEntryFilter.ANY), Set.of());
        cluster.waitAcls(new AclBindingFilter(new ResourcePattern(ResourceType.TOPIC, "Test-", PatternType.PREFIXED).toFilter(), AccessControlEntryFilter.ANY), Set.of());
    }

    private static Map<Set<ResourcePattern>, Set<AccessControlEntry>> producerResourceToAcls(boolean enableIdempotence) {
        return Map.of(TOPIC_RESOURCES, AclCommand.getAcls(USERS, (AclPermissionType)AclPermissionType.ALLOW, Set.of(AclOperation.WRITE, AclOperation.DESCRIBE, AclOperation.CREATE), HOSTS), TRANSACTIONAL_ID_RESOURCES, AclCommand.getAcls(USERS, (AclPermissionType)AclPermissionType.ALLOW, Set.of(AclOperation.WRITE, AclOperation.DESCRIBE), HOSTS), Set.of(CLUSTER_RESOURCE), AclCommand.getAcls(USERS, (AclPermissionType)AclPermissionType.ALLOW, enableIdempotence ? Set.of(AclOperation.IDEMPOTENT_WRITE) : Set.of(), HOSTS));
    }

    private List<String> adminArgs(String bootstrapServer, Optional<File> commandConfig) {
        ArrayList<String> adminArgs = new ArrayList<String>(List.of(BOOTSTRAP_SERVER, bootstrapServer));
        commandConfig.ifPresent(file -> adminArgs.addAll(List.of(COMMAND_CONFIG, file.getAbsolutePath())));
        return adminArgs;
    }

    private List<String> adminArgsWithBootstrapController(String bootstrapController, Optional<File> commandConfig) {
        ArrayList<String> adminArgs = new ArrayList<String>(List.of(BOOTSTRAP_CONTROLLER, bootstrapController));
        commandConfig.ifPresent(file -> adminArgs.addAll(List.of(COMMAND_CONFIG, file.getAbsolutePath())));
        return adminArgs;
    }

    private Map.Entry<String, String> callMain(List<String> args) {
        return ToolsTestUtils.grabConsoleOutputAndError(() -> AclCommand.main((String[])args.toArray(new String[0])));
    }

    private void testAclCli(ClusterInstance cluster, List<String> cmdArgs) throws InterruptedException {
        for (Map.Entry<Set<ResourcePattern>, List<String>> entry : RESOURCE_TO_COMMAND.entrySet()) {
            Set<ResourcePattern> resources = entry.getKey();
            List<String> resourceCmd = entry.getValue();
            Set<AclPermissionType> permissionTypes = Set.of(AclPermissionType.ALLOW, AclPermissionType.DENY);
            for (AclPermissionType permissionType : permissionTypes) {
                Map.Entry<Set<AclOperation>, List<String>> operationToCmd = RESOURCE_TO_OPERATIONS.get(resources);
                Map.Entry<Set<AccessControlEntry>, List<String>> aclToCommand = this.getAclToCommand(permissionType, operationToCmd.getKey());
                ArrayList<String> resultArgs = new ArrayList<String>(cmdArgs);
                resultArgs.addAll((Collection<String>)aclToCommand.getValue());
                resultArgs.addAll(resourceCmd);
                resultArgs.addAll((Collection<String>)operationToCmd.getValue());
                resultArgs.add(ADD);
                Map.Entry<String, String> out = this.callMain(resultArgs);
                this.assertOutputContains("Adding ACLs", resources, resourceCmd, out.getKey());
                Assertions.assertEquals((Object)"", (Object)out.getValue());
                for (ResourcePattern resource : resources) {
                    cluster.waitAcls(new AclBindingFilter(resource.toFilter(), AccessControlEntryFilter.ANY), (Collection)aclToCommand.getKey());
                }
                resultArgs = new ArrayList<String>(cmdArgs);
                resultArgs.add(LIST);
                out = this.callMain(resultArgs);
                this.assertOutputContains("Current ACLs", resources, resourceCmd, out.getKey());
                Assertions.assertEquals((Object)"", (Object)out.getValue());
                this.testRemove(cluster, cmdArgs, resources, resourceCmd);
            }
        }
    }

    private void assertOutputContains(String prefix, Set<ResourcePattern> resources, List<String> resourceCmd, String output) {
        resources.forEach(resource -> {
            String resourceType = resource.resourceType().toString();
            List<String> cmd = resource == CLUSTER_RESOURCE ? List.of("kafka-cluster") : resourceCmd.stream().filter(s -> !s.startsWith("--")).toList();
            cmd.forEach(name -> {
                String expected = String.format("%s for resource `ResourcePattern(resourceType=%s, name=%s, patternType=LITERAL)`:", prefix, resourceType, name);
                Assertions.assertTrue((boolean)output.contains(expected), (String)("Substring " + expected + " not in output:\n" + output));
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPatternTypes(List<String> cmdArgs) {
        Exit.setExitProcedure((status, message) -> {
            if (status == 1) {
                throw new RuntimeException("Exiting command");
            }
            throw new AssertionError((Object)("Unexpected exit with status " + status));
        });
        try {
            for (PatternType patternType : PatternType.values()) {
                ArrayList<String> addCmd = new ArrayList<String>(cmdArgs);
                addCmd.addAll(List.of("--allow-principal", PRINCIPAL.toString(), PRODUCER, TOPIC, "Test", ADD, RESOURCE_PATTERN_TYPE, patternType.toString()));
                this.verifyPatternType(addCmd, patternType.isSpecific());
                ArrayList<String> listCmd = new ArrayList<String>(cmdArgs);
                listCmd.addAll(List.of(TOPIC, "Test", LIST, RESOURCE_PATTERN_TYPE, patternType.toString()));
                this.verifyPatternType(listCmd, patternType != PatternType.UNKNOWN);
                ArrayList<String> removeCmd = new ArrayList<String>(cmdArgs);
                removeCmd.addAll(List.of(TOPIC, "Test", "--force", REMOVE, RESOURCE_PATTERN_TYPE, patternType.toString()));
                this.verifyPatternType(removeCmd, patternType != PatternType.UNKNOWN);
            }
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    private void verifyPatternType(List<String> cmd, boolean isValid) {
        if (isValid) {
            this.callMain(cmd);
        } else {
            Assertions.assertThrows(RuntimeException.class, () -> this.callMain(cmd));
        }
    }

    private void testRemove(ClusterInstance cluster, List<String> cmdArgs, Set<ResourcePattern> resources, List<String> resourceCmd) throws InterruptedException {
        ArrayList<String> args = new ArrayList<String>(cmdArgs);
        args.addAll(resourceCmd);
        args.add(REMOVE);
        args.add("--force");
        Map.Entry<String, String> out = this.callMain(args);
        Assertions.assertEquals((Object)"", (Object)out.getValue());
        for (ResourcePattern resource : resources) {
            cluster.waitAcls(new AclBindingFilter(resource.toFilter(), AccessControlEntryFilter.ANY), Set.of());
        }
    }

    private Map.Entry<Set<AccessControlEntry>, List<String>> getAclToCommand(AclPermissionType permissionType, Set<AclOperation> operations) {
        return Map.entry(AclCommand.getAcls(USERS, (AclPermissionType)permissionType, operations, HOSTS), this.getCmd(permissionType));
    }

    private List<String> getCmd(AclPermissionType permissionType) {
        String principalCmd = permissionType == AclPermissionType.ALLOW ? "--allow-principal" : "--deny-principal";
        List<String> cmd = permissionType == AclPermissionType.ALLOW ? ALLOW_HOST_COMMAND : DENY_HOST_COMMAND;
        ArrayList<String> fullCmd = new ArrayList<String>();
        for (KafkaPrincipal user : USERS) {
            fullCmd.addAll(cmd);
            fullCmd.addAll(List.of(principalCmd, user.toString()));
        }
        return fullCmd;
    }

    private void assertInitializeInvalidOptionsExitCodeAndMsg(List<String> args, String expectedMsg) {
        Exit.setExitProcedure((exitCode, message) -> {
            Assertions.assertEquals((int)1, (int)exitCode);
            Assertions.assertTrue((boolean)message.contains(expectedMsg));
            throw new RuntimeException();
        });
        try {
            Assertions.assertThrows(RuntimeException.class, () -> new AclCommand.AclCommandOptions(args.toArray(new String[0])).checkArgs());
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    private void checkNotThrow(List<String> args) {
        AtomicReference exitStatus = new AtomicReference();
        Exit.setExitProcedure((status, __) -> {
            exitStatus.set(status);
            throw new RuntimeException();
        });
        try {
            Assertions.assertDoesNotThrow(() -> new AclCommand.AclCommandOptions(args.toArray(new String[0])).checkArgs());
            Assertions.assertNull(exitStatus.get());
        }
        finally {
            Exit.resetExitProcedure();
        }
    }
}

