/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.test.junit;

import org.apache.kafka.common.test.junit.CatalogTestFilter;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestTag;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPostDiscoveryFilter
implements PostDiscoveryFilter {
    private static final TestTag FLAKY_TEST_TAG = TestTag.create((String)"flaky");
    public static final String RUN_NEW_PROP = "kafka.test.run.new";
    public static final String RUN_FLAKY_PROP = "kafka.test.run.flaky";
    public static final String CATALOG_FILE_PROP = "kafka.test.catalog.file";
    public static final String VERBOSE_PROP = "kafka.test.verbose";
    private static final Logger log = LoggerFactory.getLogger(KafkaPostDiscoveryFilter.class);
    private final Filter<TestDescriptor> catalogFilter;
    private final boolean runNew;
    private final boolean runFlaky;
    private final boolean verbose;

    public KafkaPostDiscoveryFilter() {
        this.runNew = System.getProperty(RUN_NEW_PROP, "false").equalsIgnoreCase("true");
        this.runFlaky = System.getProperty(RUN_FLAKY_PROP, "false").equalsIgnoreCase("true");
        this.verbose = System.getProperty(VERBOSE_PROP, "false").equalsIgnoreCase("true");
        String testCatalogFileName = System.getProperty(CATALOG_FILE_PROP);
        this.catalogFilter = CatalogTestFilter.create(testCatalogFileName);
    }

    KafkaPostDiscoveryFilter(Filter<TestDescriptor> catalogFilter, boolean runNew, boolean runFlaky) {
        this.catalogFilter = catalogFilter;
        this.runNew = runNew;
        this.runFlaky = runFlaky;
        this.verbose = false;
    }

    public FilterResult apply(TestDescriptor testDescriptor) {
        boolean hasFlakyTag = testDescriptor.getTags().contains(FLAKY_TEST_TAG);
        FilterResult catalogFilterResult = this.catalogFilter.apply((Object)testDescriptor);
        FilterResult result = this.runFlaky && this.runNew ? (hasFlakyTag ? FilterResult.included((String)"flaky") : catalogFilterResult) : (this.runFlaky ? (hasFlakyTag ? FilterResult.included((String)"flaky") : FilterResult.excluded((String)"non-flaky")) : (this.runNew ? (catalogFilterResult.included() && hasFlakyTag ? FilterResult.excluded((String)"flaky") : catalogFilterResult) : (hasFlakyTag ? FilterResult.excluded((String)"flaky") : (catalogFilterResult.included() ? FilterResult.excluded((String)"new") : FilterResult.included(null)))));
        if (this.verbose) {
            log.info("{} Test '{}' with reason '{}'. Flaky tag is {}, catalog filter has {} this test.", new Object[]{result.included() ? "Including" : "Excluding", testDescriptor.getDisplayName(), result.getReason().orElse("null"), hasFlakyTag ? "present" : "not present", catalogFilterResult.included() ? "included" : "not included"});
        }
        return result;
    }
}

