/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.test.junit;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogTestFilter
implements Filter<TestDescriptor> {
    private static final Filter<TestDescriptor> EXCLUDE_ALL_TESTS = testDescriptor -> FilterResult.excluded((String)"missing catalog");
    private static final Logger log = LoggerFactory.getLogger(CatalogTestFilter.class);
    private final Set<TestAndMethod> testCatalog;

    CatalogTestFilter(Set<TestAndMethod> testCatalog) {
        this.testCatalog = Collections.unmodifiableSet(testCatalog);
    }

    public FilterResult apply(TestDescriptor testDescriptor) {
        Optional sourceOpt = testDescriptor.getSource();
        if (sourceOpt.isEmpty()) {
            return FilterResult.included(null);
        }
        TestSource source = (TestSource)sourceOpt.get();
        if (!(source instanceof MethodSource)) {
            return FilterResult.included(null);
        }
        MethodSource methodSource = (MethodSource)source;
        TestAndMethod testAndMethod = new TestAndMethod(methodSource.getClassName(), methodSource.getMethodName());
        if (this.testCatalog.contains(testAndMethod)) {
            return FilterResult.excluded(null);
        }
        return FilterResult.included((String)"new test");
    }

    public static Filter<TestDescriptor> create(String testCatalogFileName) {
        if (testCatalogFileName == null || testCatalogFileName.isEmpty()) {
            log.debug("No test catalog specified, will not select any tests with this filter.");
            return EXCLUDE_ALL_TESTS;
        }
        Path path = Paths.get(testCatalogFileName, new String[0]);
        log.debug("Loading test catalog file {}.", (Object)path);
        if (!Files.exists(path, new LinkOption[0])) {
            log.error("Test catalog file {} does not exist, will not select any tests with this filter.", (Object)path);
            return EXCLUDE_ALL_TESTS;
        }
        HashSet<TestAndMethod> allTests = new HashSet<TestAndMethod>();
        try (BufferedReader reader = Files.newBufferedReader(path, Charset.defaultCharset());){
            String line = reader.readLine();
            while (line != null) {
                String[] toks = line.split("#", 2);
                allTests.add(new TestAndMethod(toks[0], toks[1]));
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            log.error("Error while reading test catalog file, will not select any tests with this filter.", (Throwable)e);
            return EXCLUDE_ALL_TESTS;
        }
        if (allTests.isEmpty()) {
            log.error("Loaded an empty test catalog, will not select any tests with this filter.");
            return EXCLUDE_ALL_TESTS;
        }
        log.debug("Loaded {} test methods from test catalog file {}.", (Object)allTests.size(), (Object)path);
        return new CatalogTestFilter(allTests);
    }

    public static class TestAndMethod {
        private final String testClass;
        private final String testMethod;

        public TestAndMethod(String testClass, String testMethod) {
            this.testClass = testClass;
            this.testMethod = testMethod;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestAndMethod that = (TestAndMethod)o;
            return Objects.equals(this.testClass, that.testClass) && Objects.equals(this.testMethod, that.testMethod);
        }

        public int hashCode() {
            return Objects.hash(this.testClass, this.testMethod);
        }

        public String toString() {
            return "TestAndMethod{testClass='" + this.testClass + "', testMethod='" + this.testMethod + "'}";
        }
    }
}

