/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.test.junit;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.test.junit.CatalogTestFilter;
import org.apache.kafka.common.test.junit.KafkaPostDiscoveryFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.MethodSource;

public class KafkaPostDiscoveryFilterTest {
    KafkaPostDiscoveryFilter setupFilter(boolean runNew, boolean runFlaky) {
        HashSet<CatalogTestFilter.TestAndMethod> testCatalog = new HashSet<CatalogTestFilter.TestAndMethod>();
        testCatalog.add(new CatalogTestFilter.TestAndMethod("o.a.k.Foo", "testBar1"));
        testCatalog.add(new CatalogTestFilter.TestAndMethod("o.a.k.Foo", "testBar2"));
        testCatalog.add(new CatalogTestFilter.TestAndMethod("o.a.k.Spam", "testEggs"));
        CatalogTestFilter catalogTestFilter = new CatalogTestFilter(testCatalog);
        return new KafkaPostDiscoveryFilter((Filter)catalogTestFilter, runNew, runFlaky);
    }

    @Test
    public void testExcludeExistingNonFlaky() {
        KafkaPostDiscoveryFilter filter = this.setupFilter(false, true);
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar1", new String[0])).excluded());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar2", new String[0])).excluded());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Spam", "testEggs", new String[0])).excluded());
    }

    @Test
    public void testIncludeExistingFlaky() {
        KafkaPostDiscoveryFilter filter = this.setupFilter(false, true);
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar1", "flaky")).included());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar2", "flaky")).included());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Spam", "testEggs", "flaky", "integration")).included());
    }

    @Test
    public void testIncludeAutoQuarantinedAndFlaky() {
        KafkaPostDiscoveryFilter filter = this.setupFilter(true, true);
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar3", new String[0])).included());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Spam", "testEggz", "flaky")).included());
    }

    @Test
    public void testIncludeAutoQuarantinedNoFlaky() {
        KafkaPostDiscoveryFilter filter = this.setupFilter(true, false);
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar3", new String[0])).included());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Spam", "testEggz", "flaky")).excluded());
    }

    @Test
    public void testExcludeFlakyAndNew() {
        KafkaPostDiscoveryFilter filter = this.setupFilter(false, false);
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar3", new String[0])).excluded());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Spam", "testEggz", "flaky")).excluded());
    }

    @Test
    public void testExcludeFlaky() {
        KafkaPostDiscoveryFilter filter = this.setupFilter(false, false);
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar1", "flaky")).excluded());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar2", "flaky")).excluded());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Spam", "testEggs", "flaky", "integration")).excluded());
    }

    @Test
    public void testExistingTestNonFlaky() {
        KafkaPostDiscoveryFilter filter = this.setupFilter(false, false);
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar1", new String[0])).included());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar2", new String[0])).included());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Spam", "testEggs", new String[0])).included());
    }

    @Test
    public void testNoCatalogRunFlakyTests() {
        KafkaPostDiscoveryFilter filter = new KafkaPostDiscoveryFilter(CatalogTestFilter.create(null), false, true);
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar1", "flaky")).included());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar2", "flaky")).included());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Spam", "testEggs", new String[0])).excluded());
    }

    @Test
    public void testNoCatalogRunNewTest() {
        KafkaPostDiscoveryFilter filter = new KafkaPostDiscoveryFilter(CatalogTestFilter.create(null), true, false);
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar1", "flaky")).excluded());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar2", "flaky")).excluded());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Spam", "testEggs", new String[0])).excluded());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Spam", "testNew", new String[0])).excluded(), (String)"Should not select a new test because there is no catalog loaded");
    }

    @Test
    public void testNoCatalogRunMainTests() {
        KafkaPostDiscoveryFilter filter = new KafkaPostDiscoveryFilter(CatalogTestFilter.create(null), false, false);
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar1", "flaky")).excluded());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Foo", "testBar2", "flaky")).excluded());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Spam", "testEggs", new String[0])).included());
        Assertions.assertTrue((boolean)filter.apply((TestDescriptor)new MockTestDescriptor("o.a.k.Spam", "testNew", new String[0])).included());
    }

    static class MockTestDescriptor
    implements TestDescriptor {
        private final MethodSource methodSource;
        private final Set<TestTag> testTags;

        MockTestDescriptor(String className, String methodName, String ... tags) {
            this.methodSource = MethodSource.from((String)className, (String)methodName);
            this.testTags = new HashSet<TestTag>();
            Arrays.stream(tags).forEach(tag -> this.testTags.add(TestTag.create((String)tag)));
        }

        public UniqueId getUniqueId() {
            return null;
        }

        public String getDisplayName() {
            return "";
        }

        public Set<TestTag> getTags() {
            return this.testTags;
        }

        public Optional<TestSource> getSource() {
            return Optional.of(this.methodSource);
        }

        public Optional<TestDescriptor> getParent() {
            return Optional.empty();
        }

        public void setParent(TestDescriptor testDescriptor) {
        }

        public Set<? extends TestDescriptor> getChildren() {
            return Set.of();
        }

        public void addChild(TestDescriptor testDescriptor) {
        }

        public void removeChild(TestDescriptor testDescriptor) {
        }

        public void removeFromHierarchy() {
        }

        public TestDescriptor.Type getType() {
            return null;
        }

        public Optional<? extends TestDescriptor> findByUniqueId(UniqueId uniqueId) {
            return Optional.empty();
        }
    }
}

