/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.test.junit;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.test.junit.CatalogTestFilter;
import org.apache.kafka.common.test.junit.KafkaPostDiscoveryFilterTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;

public class CatalogTestFilterTest {
    private TestDescriptor descriptor(String className, String methodName) {
        return new KafkaPostDiscoveryFilterTest.MockTestDescriptor(className, methodName, new String[0]);
    }

    @Test
    public void testLoadCatalog(@TempDir Path tempDir) throws IOException {
        Path catalog = tempDir.resolve("catalog.txt");
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("o.a.k.Foo#testBar1");
        lines.add("o.a.k.Foo#testBar2");
        lines.add("o.a.k.Spam#testEggs");
        Files.write(catalog, lines, new OpenOption[0]);
        Filter filter = CatalogTestFilter.create((String)catalog.toString());
        Assertions.assertTrue((boolean)filter.apply((Object)this.descriptor("o.a.k.Foo", "testBar1")).excluded());
        Assertions.assertTrue((boolean)filter.apply((Object)this.descriptor("o.a.k.Foo", "testBar2")).excluded());
        Assertions.assertTrue((boolean)filter.apply((Object)this.descriptor("o.a.k.Spam", "testEggs")).excluded());
        Assertions.assertTrue((boolean)filter.apply((Object)this.descriptor("o.a.k.Spam", "testNew")).included());
    }

    @Test
    public void testEmptyCatalog(@TempDir Path tempDir) throws IOException {
        Path catalog = tempDir.resolve("catalog.txt");
        Files.write(catalog, List.of(), new OpenOption[0]);
        Filter filter = CatalogTestFilter.create((String)catalog.toString());
        Assertions.assertTrue((boolean)filter.apply((Object)this.descriptor("o.a.k.Foo", "testBar1")).excluded());
        Assertions.assertTrue((boolean)filter.apply((Object)this.descriptor("o.a.k.Foo", "testBar2")).excluded());
        Assertions.assertTrue((boolean)filter.apply((Object)this.descriptor("o.a.k.Spam", "testEggs")).excluded());
        Assertions.assertTrue((boolean)filter.apply((Object)this.descriptor("o.a.k.Spam", "testNew")).excluded());
    }

    @Test
    public void testMissingCatalog() {
        Filter filter = CatalogTestFilter.create((String)"does-not-exist.txt");
        Assertions.assertTrue((boolean)filter.apply((Object)this.descriptor("o.a.k.Foo", "testBar1")).excluded());
        Assertions.assertTrue((boolean)filter.apply((Object)this.descriptor("o.a.k.Foo", "testBar2")).excluded());
        Assertions.assertTrue((boolean)filter.apply((Object)this.descriptor("o.a.k.Spam", "testEggs")).excluded());
        Assertions.assertTrue((boolean)filter.apply((Object)this.descriptor("o.a.k.Spam", "testNew")).excluded());
    }
}

