/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.test.api;

import org.apache.kafka.common.test.api.DetectThreadLeak;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DetectThreadLeakTest {
    @Test
    public void testThreadLeak() throws InterruptedException {
        DetectThreadLeak detectThreadLeak = DetectThreadLeak.of(thread -> true);
        Thread leakThread = new Thread(new LeakThread());
        try {
            leakThread.start();
            Assertions.assertTrue((boolean)detectThreadLeak.newThreads().contains(leakThread));
            leakThread.interrupt();
        }
        finally {
            leakThread.join();
        }
        Assertions.assertFalse((boolean)leakThread.isAlive(), (String)"Can't interrupt the thread");
        Assertions.assertFalse((boolean)detectThreadLeak.newThreads().contains(leakThread));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDetectThreadLeakWithOverrideExpectedThreadNames() throws InterruptedException {
        String threadName = "test-thread";
        DetectThreadLeak detectThreadLeak = DetectThreadLeak.of(thread -> !thread.getName().equals(threadName));
        Thread leakThread = new Thread((Runnable)new LeakThread(), threadName);
        try {
            leakThread.start();
            Assertions.assertFalse((boolean)detectThreadLeak.newThreads().contains(leakThread));
            leakThread.interrupt();
        }
        finally {
            leakThread.join();
        }
        Assertions.assertFalse((boolean)leakThread.isAlive(), (String)"Can't interrupt the thread");
    }

    private static class LeakThread
    implements Runnable {
        private LeakThread() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

