/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.processor.internals.assignment.AssignorConfiguration;
import org.apache.kafka.streams.processor.internals.assignment.ClientTagAwareStandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.DefaultStandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignorFactory;
import org.junit.Assert;
import org.junit.Test;

public class StandbyTaskAssignorFactoryTest {
    private static final long ACCEPTABLE_RECOVERY_LAG = 0L;
    private static final int MAX_WARMUP_REPLICAS = 1;
    private static final int NUMBER_OF_STANDBY_REPLICAS = 1;
    private static final long PROBING_REBALANCE_INTERVAL_MS = 60000L;

    @Test
    public void shouldReturnClientTagAwareStandbyTaskAssignorWhenRackAwareAssignmentTagsIsSet() {
        StandbyTaskAssignor standbyTaskAssignor = StandbyTaskAssignorFactory.create((AssignorConfiguration.AssignmentConfigs)StandbyTaskAssignorFactoryTest.newAssignmentConfigs(Collections.singletonList("az")));
        Assert.assertTrue((boolean)(standbyTaskAssignor instanceof ClientTagAwareStandbyTaskAssignor));
    }

    @Test
    public void shouldReturnDefaultStandbyTaskAssignorWhenRackAwareAssignmentTagsIsEmpty() {
        StandbyTaskAssignor standbyTaskAssignor = StandbyTaskAssignorFactory.create((AssignorConfiguration.AssignmentConfigs)StandbyTaskAssignorFactoryTest.newAssignmentConfigs(Collections.emptyList()));
        Assert.assertTrue((boolean)(standbyTaskAssignor instanceof DefaultStandbyTaskAssignor));
    }

    private static AssignorConfiguration.AssignmentConfigs newAssignmentConfigs(List<String> rackAwareAssignmentTags) {
        return new AssignorConfiguration.AssignmentConfigs(Long.valueOf(0L), Integer.valueOf(1), Integer.valueOf(1), Long.valueOf(60000L), rackAwareAssignmentTags);
    }
}

