/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.TimestampedCacheFlushListener;
import org.apache.kafka.streams.kstream.internals.TimestampedTupleForwarder;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.easymock.EasyMock;
import org.junit.Test;

public class TimestampedTupleForwarderTest {
    @Test
    public void shouldSetFlushListenerOnWrappedStateStore() {
        this.setFlushListener(true);
        this.setFlushListener(false);
    }

    private void setFlushListener(boolean sendOldValues) {
        WrappedStateStore store = (WrappedStateStore)EasyMock.mock(WrappedStateStore.class);
        TimestampedCacheFlushListener flushListener = (TimestampedCacheFlushListener)EasyMock.mock(TimestampedCacheFlushListener.class);
        EasyMock.expect((Object)store.setFlushListener((CacheFlushListener)flushListener, sendOldValues)).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{store});
        new TimestampedTupleForwarder((StateStore)store, (ProcessorContext)null, (CacheFlushListener)flushListener, sendOldValues);
        EasyMock.verify((Object[])new Object[]{store});
    }

    @Test
    public void shouldForwardRecordsIfWrappedStateStoreDoesNotCache() {
        this.shouldForwardRecordsIfWrappedStateStoreDoesNotCache(false);
        this.shouldForwardRecordsIfWrappedStateStoreDoesNotCache(true);
    }

    private void shouldForwardRecordsIfWrappedStateStoreDoesNotCache(boolean sendOldValues) {
        WrappedStateStore store = (WrappedStateStore)EasyMock.mock(WrappedStateStore.class);
        InternalProcessorContext context = (InternalProcessorContext)EasyMock.mock(InternalProcessorContext.class);
        EasyMock.expect((Object)store.setFlushListener(null, sendOldValues)).andReturn((Object)false);
        if (sendOldValues) {
            context.forward(new Record((Object)"key1", (Object)new Change((Object)"newValue1", (Object)"oldValue1", true), 0L));
            context.forward(new Record((Object)"key2", (Object)new Change((Object)"newValue2", (Object)"oldValue2", false), 42L));
        } else {
            context.forward(new Record((Object)"key1", (Object)new Change((Object)"newValue1", null, true), 0L));
            context.forward(new Record((Object)"key2", (Object)new Change((Object)"newValue2", null, false), 42L));
        }
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{store, context});
        TimestampedTupleForwarder forwarder = new TimestampedTupleForwarder((StateStore)store, (ProcessorContext)context, null, sendOldValues);
        forwarder.maybeForward(new Record((Object)"key1", (Object)new Change((Object)"newValue1", (Object)"oldValue1", true), 0L));
        forwarder.maybeForward(new Record((Object)"key2", (Object)new Change((Object)"newValue2", (Object)"oldValue2", false), 42L));
        EasyMock.verify((Object[])new Object[]{store, context});
    }

    @Test
    public void shouldNotForwardRecordsIfWrappedStateStoreDoesCache() {
        WrappedStateStore store = (WrappedStateStore)EasyMock.mock(WrappedStateStore.class);
        InternalProcessorContext context = (InternalProcessorContext)EasyMock.mock(InternalProcessorContext.class);
        EasyMock.expect((Object)store.setFlushListener(null, false)).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{store, context});
        TimestampedTupleForwarder forwarder = new TimestampedTupleForwarder((StateStore)store, (ProcessorContext)context, null, false);
        forwarder.maybeForward(new Record((Object)"key", (Object)new Change((Object)"newValue", (Object)"oldValue", true), 0L));
        forwarder.maybeForward(new Record((Object)"key", (Object)new Change((Object)"newValue", (Object)"oldValue", true), 42L));
        EasyMock.verify((Object[])new Object[]{store, context});
    }
}

