/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.KeyValueTimestamp;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KeyValueMapper;
import org.apache.kafka.streams.kstream.internals.KStreamFlatMap;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.test.MockApiProcessorSupplier;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class KStreamFlatMapTest {
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.Integer(), Serdes.String());

    @Test
    public void testFlatMap() {
        StreamsBuilder builder = new StreamsBuilder();
        String topicName = "topic";
        KeyValueMapper mapper = (key, value) -> {
            ArrayList<KeyValue> result = new ArrayList<KeyValue>();
            for (int i = 0; i < key.intValue(); ++i) {
                result.add(KeyValue.pair((Object)Integer.toString(key.intValue() * 10 + i), (Object)value.toString()));
            }
            return result;
        };
        int[] expectedKeys = new int[]{0, 1, 2, 3};
        MockApiProcessorSupplier supplier = new MockApiProcessorSupplier();
        KStream stream = builder.stream("topic", Consumed.with((Serde)Serdes.Integer(), (Serde)Serdes.String()));
        stream.flatMap(mapper).process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(builder.build(), this.props);){
            TestInputTopic inputTopic = driver.createInputTopic("topic", (Serializer)new IntegerSerializer(), (Serializer)new StringSerializer(), Instant.ofEpochMilli(0L), Duration.ZERO);
            for (int expectedKey : expectedKeys) {
                inputTopic.pipeInput((Object)expectedKey, (Object)("V" + expectedKey));
            }
        }
        Assert.assertEquals((long)6L, (long)supplier.theCapturedProcessor().processed().size());
        KeyValueTimestamp[] expected = new KeyValueTimestamp[]{new KeyValueTimestamp<String, String>("10", "V1", 0L), new KeyValueTimestamp<String, String>("20", "V2", 0L), new KeyValueTimestamp<String, String>("21", "V2", 0L), new KeyValueTimestamp<String, String>("30", "V3", 0L), new KeyValueTimestamp<String, String>("31", "V3", 0L), new KeyValueTimestamp<String, String>("32", "V3", 0L)};
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], supplier.theCapturedProcessor().processed().get(i));
        }
    }

    @Test
    public void testKeyValueMapperResultNotNull() {
        KStreamFlatMap supplier = new KStreamFlatMap((key, value) -> null);
        Throwable throwable = Assert.assertThrows(NullPointerException.class, () -> supplier.get().process(new Record((Object)"K", (Object)0, 0L)));
        MatcherAssert.assertThat((Object)throwable.getMessage(), (Matcher)Is.is((Object)"The provided KeyValueMapper returned null which is not allowed."));
    }
}

