/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TestOutputTopic;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.integration.KTableKTableForeignKeyJoinIntegrationTest;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.test.IntegrationTest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={IntegrationTest.class})
public class KTableKTableForeignKeyVersionedJoinIntegrationTest
extends KTableKTableForeignKeyJoinIntegrationTest {
    public KTableKTableForeignKeyVersionedJoinIntegrationTest(boolean leftJoin, boolean materialized, boolean leftVersioned, boolean rightVersioned) {
        super(leftJoin, "none", materialized, false, leftVersioned, rightVersioned);
    }

    @Parameterized.Parameters(name="leftJoin={0}, materialized={1}, leftVersioned={2}, rightVersioned={3}")
    public static Collection<Object[]> data() {
        List<Boolean> booleans = Arrays.asList(true, false);
        return KTableKTableForeignKeyVersionedJoinIntegrationTest.buildParameters(booleans, booleans, booleans, booleans);
    }

    @Test
    public void shouldIgnoreOutOfOrderRecordsIffVersioned() {
        Topology topology = KTableKTableForeignKeyVersionedJoinIntegrationTest.getTopology(this.streamsConfig, this.materialized ? "store" : null, this.leftJoin, this.rejoin, this.leftVersioned, this.rightVersioned);
        try (TopologyTestDriver driver = new TopologyTestDriver(topology, this.streamsConfig);){
            TestInputTopic right = driver.createInputTopic("right_table", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestInputTopic left = driver.createInputTopic("left_table", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
            TestOutputTopic outputTopic = driver.createOutputTopic("output-topic", (Deserializer)new StringDeserializer(), (Deserializer)new StringDeserializer());
            KeyValueStore store = driver.getKeyValueStore("store");
            right.pipeInput((Object)"rhs1", (Object)"rhsValue1", this.baseTimestamp + 4L);
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            if (this.materialized) {
                MatcherAssert.assertThat(KTableKTableForeignKeyVersionedJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(Collections.emptyMap()));
            }
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1|rhs1", this.baseTimestamp + 3L);
            left.pipeInput((Object)"lhs2", (Object)"lhsValue2|rhs1", this.baseTimestamp + 5L);
            Map expected = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2|rhs1,rhsValue1)")});
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)expected));
            if (this.materialized) {
                MatcherAssert.assertThat(KTableKTableForeignKeyVersionedJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)expected));
            }
            left.pipeInput((Object)"lhs2", null, this.baseTimestamp + 6L);
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs2", null)})));
            if (this.materialized) {
                MatcherAssert.assertThat(KTableKTableForeignKeyVersionedJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)")})));
            }
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1_ooo|rhs1", this.baseTimestamp + 2L);
            left.pipeInput((Object)"lhs2", (Object)"lhsValue2_ooo|rhs1", this.baseTimestamp + 2L);
            if (this.leftVersioned) {
                MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
                if (this.materialized) {
                    MatcherAssert.assertThat(KTableKTableForeignKeyVersionedJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)")})));
                }
            } else {
                expected = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1_ooo|rhs1,rhsValue1)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2_ooo|rhs1,rhsValue1)")});
                MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)expected));
                if (this.materialized) {
                    MatcherAssert.assertThat(KTableKTableForeignKeyVersionedJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)expected));
                }
            }
            left.pipeInput((Object)"lhs1", null, this.baseTimestamp + 2L);
            if (this.leftVersioned) {
                MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
                if (this.materialized) {
                    MatcherAssert.assertThat(KTableKTableForeignKeyVersionedJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1|rhs1,rhsValue1)")})));
                }
            } else {
                MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", null)})));
                if (this.materialized) {
                    MatcherAssert.assertThat(KTableKTableForeignKeyVersionedJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2_ooo|rhs1,rhsValue1)")})));
                }
            }
            left.pipeInput((Object)"lhs1", (Object)"lhsValue1_new|rhs1", this.baseTimestamp + 8L);
            left.pipeInput((Object)"lhs2", (Object)"lhsValue2_new|rhs1", this.baseTimestamp + 8L);
            expected = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1_new|rhs1,rhsValue1)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2_new|rhs1,rhsValue1)")});
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)expected));
            if (this.materialized) {
                MatcherAssert.assertThat(KTableKTableForeignKeyVersionedJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)expected));
            }
            right.pipeInput((Object)"rhs1", (Object)"rhsValue1_ooo", this.baseTimestamp + 1L);
            if (this.rightVersioned) {
                MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
                if (this.materialized) {
                    MatcherAssert.assertThat(KTableKTableForeignKeyVersionedJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1_new|rhs1,rhsValue1)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2_new|rhs1,rhsValue1)")})));
                }
            } else {
                MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1_new|rhs1,rhsValue1_ooo)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2_new|rhs1,rhsValue1_ooo)")})));
                if (this.materialized) {
                    MatcherAssert.assertThat(KTableKTableForeignKeyVersionedJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1_new|rhs1,rhsValue1_ooo)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2_new|rhs1,rhsValue1_ooo)")})));
                }
            }
            right.pipeInput((Object)"rhs1", null, this.baseTimestamp + 1L);
            if (this.rightVersioned) {
                MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is(Collections.emptyMap()));
                if (this.materialized) {
                    MatcherAssert.assertThat(KTableKTableForeignKeyVersionedJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1_new|rhs1,rhsValue1)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2_new|rhs1,rhsValue1)")})));
                }
            } else if (this.leftJoin) {
                MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1_new|rhs1,null)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2_new|rhs1,null)")})));
                if (this.materialized) {
                    MatcherAssert.assertThat(KTableKTableForeignKeyVersionedJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1_new|rhs1,null)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2_new|rhs1,null)")})));
                }
            } else {
                MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", null), Utils.mkEntry((Object)"lhs2", null)})));
                if (this.materialized) {
                    MatcherAssert.assertThat(KTableKTableForeignKeyVersionedJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is(Collections.emptyMap()));
                }
            }
            right.pipeInput((Object)"rhs1", (Object)"rhsValue1_new", this.baseTimestamp + 6L);
            MatcherAssert.assertThat((Object)outputTopic.readKeyValuesToMap(), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1_new|rhs1,rhsValue1_new)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2_new|rhs1,rhsValue1_new)")})));
            if (this.materialized) {
                MatcherAssert.assertThat(KTableKTableForeignKeyVersionedJoinIntegrationTest.asMap((KeyValueStore<String, String>)store), (Matcher)CoreMatchers.is((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"lhs1", (Object)"(lhsValue1_new|rhs1,rhsValue1_new)"), Utils.mkEntry((Object)"lhs2", (Object)"(lhsValue2_new|rhs1,rhsValue1_new)")})));
            }
        }
    }
}

