/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;

public class PendingUpdateAction {
    private final Set<TopicPartition> inputPartitions;
    private final Action action;

    private PendingUpdateAction(Action action, Set<TopicPartition> inputPartitions) {
        this.action = action;
        this.inputPartitions = inputPartitions;
    }

    private PendingUpdateAction(Action action) {
        this(action, null);
    }

    public static PendingUpdateAction createUpdateInputPartition(Set<TopicPartition> inputPartitions) {
        Objects.requireNonNull(inputPartitions, "Set of input partitions to update is null!");
        return new PendingUpdateAction(Action.UPDATE_INPUT_PARTITIONS, inputPartitions);
    }

    public static PendingUpdateAction createRecycleTask(Set<TopicPartition> inputPartitions) {
        Objects.requireNonNull(inputPartitions, "Set of input partitions to update is null!");
        return new PendingUpdateAction(Action.RECYCLE, inputPartitions);
    }

    public static PendingUpdateAction createSuspend() {
        return new PendingUpdateAction(Action.SUSPEND);
    }

    public static PendingUpdateAction createCloseDirty() {
        return new PendingUpdateAction(Action.CLOSE_DIRTY);
    }

    public static PendingUpdateAction createCloseClean() {
        return new PendingUpdateAction(Action.CLOSE_CLEAN);
    }

    public Set<TopicPartition> getInputPartitions() {
        if (this.action != Action.UPDATE_INPUT_PARTITIONS && this.action != Action.RECYCLE) {
            throw new IllegalStateException("Action type " + (Object)((Object)this.action) + " does not have a set of input partitions!");
        }
        return this.inputPartitions;
    }

    public Action getAction() {
        return this.action;
    }

    static enum Action {
        UPDATE_INPUT_PARTITIONS,
        RECYCLE,
        SUSPEND,
        CLOSE_DIRTY,
        CLOSE_CLEAN;

    }
}

