/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Window;

public class TimeWindow
extends Window {
    public TimeWindow(long startMs, long endMs) throws IllegalArgumentException {
        super(startMs, endMs);
        if (startMs == endMs) {
            throw new IllegalArgumentException("Window endMs must be greater than window startMs.");
        }
    }

    @Override
    public boolean overlap(Window other) throws IllegalArgumentException {
        if (this.getClass() != other.getClass()) {
            throw new IllegalArgumentException("Cannot compare windows of different type. Other window has type " + other.getClass() + ".");
        }
        TimeWindow otherWindow = (TimeWindow)other;
        return this.startMs < otherWindow.endMs && otherWindow.startMs < this.endMs;
    }
}

