/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.state.internals.CacheFlushListener;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class SessionTupleForwarder<K, V> {
    private final ProcessorContext context;
    private final boolean sendOldValues;
    private final boolean cachingEnabled;

    SessionTupleForwarder(StateStore store, ProcessorContext context, CacheFlushListener<Windowed<K>, V> flushListener, boolean sendOldValues) {
        this.context = context;
        this.sendOldValues = sendOldValues;
        this.cachingEnabled = ((WrappedStateStore)store).setFlushListener(flushListener, sendOldValues);
    }

    public void maybeForward(Windowed<K> key, V newValue, V oldValue) {
        if (!this.cachingEnabled) {
            this.context.forward(key, new Change<V>(newValue, this.sendOldValues ? oldValue : null), To.all().withTimestamp(key.window().end()));
        }
    }
}

