/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;

public class ContextualRecord {
    private final byte[] value;
    private final ProcessorRecordContext recordContext;

    public ContextualRecord(byte[] value, ProcessorRecordContext recordContext) {
        this.value = value;
        this.recordContext = Objects.requireNonNull(recordContext);
    }

    public ProcessorRecordContext recordContext() {
        return this.recordContext;
    }

    public byte[] value() {
        return this.value;
    }

    long sizeBytes() {
        return (long)(this.value == null ? 0 : this.value.length) + this.recordContext.sizeBytes();
    }

    ByteBuffer serialize(int endPadding) {
        byte[] serializedContext = this.recordContext.serialize();
        int sizeOfContext = serializedContext.length;
        int sizeOfValueLength = 4;
        int sizeOfValue = this.value == null ? 0 : this.value.length;
        ByteBuffer buffer = ByteBuffer.allocate(sizeOfContext + 4 + sizeOfValue + endPadding);
        buffer.put(serializedContext);
        if (this.value == null) {
            buffer.putInt(-1);
        } else {
            buffer.putInt(this.value.length);
            buffer.put(this.value);
        }
        return buffer;
    }

    static ContextualRecord deserialize(ByteBuffer buffer) {
        ProcessorRecordContext context = ProcessorRecordContext.deserialize(buffer);
        int valueLength = buffer.getInt();
        if (valueLength == -1) {
            return new ContextualRecord(null, context);
        }
        byte[] value = new byte[valueLength];
        buffer.get(value);
        return new ContextualRecord(value, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextualRecord that = (ContextualRecord)o;
        return Arrays.equals(this.value, that.value) && Objects.equals(this.recordContext, that.recordContext);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.recordContext);
    }

    public String toString() {
        return "ContextualRecord{recordContext=" + this.recordContext + ", value=" + Arrays.toString(this.value) + '}';
    }
}

