/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.StateStoreContext;
import org.apache.kafka.streams.processor.internals.MockStreamsMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.ChangeLoggingKeyValueBytesStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.MockRecordCollector;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ChangeLoggingKeyValueBytesStoreTest {
    private final MockRecordCollector collector = new MockRecordCollector();
    private final InMemoryKeyValueStore inner = new InMemoryKeyValueStore("kv");
    private final ChangeLoggingKeyValueBytesStore store = new ChangeLoggingKeyValueBytesStore((KeyValueStore)this.inner);
    private final Bytes hi = Bytes.wrap((byte[])"hi".getBytes());
    private final Bytes hello = Bytes.wrap((byte[])"hello".getBytes());
    private final byte[] there = "there".getBytes();
    private final byte[] world = "world".getBytes();

    @Before
    public void before() {
        InternalMockProcessorContext context = this.mockContext();
        context.setTime(0L);
        this.store.init((StateStoreContext)context, (StateStore)this.store);
    }

    private InternalMockProcessorContext mockContext() {
        return new InternalMockProcessorContext(TestUtils.tempDirectory(), Serdes.String(), Serdes.Long(), this.collector, new ThreadCache(new LogContext("testCache "), 0L, (StreamsMetricsImpl)new MockStreamsMetrics(new Metrics())));
    }

    @After
    public void after() {
        this.store.close();
    }

    @Test
    public void shouldDelegateDeprecatedInit() {
        InternalMockProcessorContext context = this.mockContext();
        KeyValueStore innerMock = (KeyValueStore)EasyMock.mock(InMemoryKeyValueStore.class);
        ChangeLoggingKeyValueBytesStore outer = new ChangeLoggingKeyValueBytesStore(innerMock);
        innerMock.init((ProcessorContext)context, (StateStore)outer);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{innerMock});
        outer.init((ProcessorContext)context, (StateStore)outer);
        EasyMock.verify((Object[])new Object[]{innerMock});
    }

    @Test
    public void shouldDelegateInit() {
        InternalMockProcessorContext context = this.mockContext();
        KeyValueStore innerMock = (KeyValueStore)EasyMock.mock(InMemoryKeyValueStore.class);
        ChangeLoggingKeyValueBytesStore outer = new ChangeLoggingKeyValueBytesStore(innerMock);
        innerMock.init((StateStoreContext)context, (StateStore)outer);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{innerMock});
        outer.init((StateStoreContext)context, (StateStore)outer);
        EasyMock.verify((Object[])new Object[]{innerMock});
    }

    @Test
    public void shouldWriteKeyValueBytesToInnerStoreOnPut() {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldWriteAllKeyValueToInnerStoreOnPutAll() {
        this.store.putAll(Arrays.asList(KeyValue.pair((Object)this.hi, (Object)this.there), KeyValue.pair((Object)this.hello, (Object)this.world)));
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
        MatcherAssert.assertThat((Object)this.inner.get(this.hello), (Matcher)CoreMatchers.equalTo((Object)this.world));
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).key(), (Matcher)CoreMatchers.equalTo((Object)this.hello));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).value(), (Matcher)CoreMatchers.equalTo((Object)this.world));
    }

    @Test
    public void shouldPropagateDelete() {
        this.store.put(this.hi, this.there);
        this.store.delete(this.hi);
        MatcherAssert.assertThat((Object)this.inner.approximateNumEntries(), (Matcher)CoreMatchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldReturnOldValueOnDelete() {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.store.delete(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldLogKeyNullOnDelete() {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.store.delete(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(1).value(), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldWriteToInnerOnPutIfAbsentNoPreviousValue() {
        this.store.putIfAbsent(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldNotWriteToInnerOnPutIfAbsentWhenValueForKeyExists() {
        this.store.put(this.hi, this.there);
        this.store.putIfAbsent(this.hi, this.world);
        MatcherAssert.assertThat((Object)this.inner.get(this.hi), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldWriteToChangelogOnPutIfAbsentWhenNoPreviousValue() {
        this.store.putIfAbsent(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldNotWriteToChangeLogOnPutIfAbsentWhenValueForKeyExists() {
        this.store.put(this.hi, this.there);
        this.store.putIfAbsent(this.hi, this.world);
        MatcherAssert.assertThat((Object)this.collector.collected().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).key(), (Matcher)CoreMatchers.equalTo((Object)this.hi));
        MatcherAssert.assertThat((Object)this.collector.collected().get(0).value(), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldReturnCurrentValueOnPutIfAbsent() {
        this.store.put(this.hi, this.there);
        MatcherAssert.assertThat((Object)this.store.putIfAbsent(this.hi, this.world), (Matcher)CoreMatchers.equalTo((Object)this.there));
    }

    @Test
    public void shouldReturnNullOnPutIfAbsentWhenNoPreviousValue() {
        MatcherAssert.assertThat((Object)this.store.putIfAbsent(this.hi, this.there), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldReturnValueOnGetWhenExists() {
        this.store.put(this.hello, this.world);
        MatcherAssert.assertThat((Object)this.store.get(this.hello), (Matcher)CoreMatchers.equalTo((Object)this.world));
    }

    @Test
    public void shouldGetRecordsWithPrefixKey() {
        this.store.put(this.hi, this.there);
        this.store.put(Bytes.increment((Bytes)this.hi), this.world);
        KeyValueIterator keysWithPrefix = this.store.prefixScan((Object)this.hi.toString(), (Serializer)new StringSerializer());
        ArrayList<Object> keys = new ArrayList<Object>();
        ArrayList<Bytes> values = new ArrayList<Bytes>();
        int numberOfKeysReturned = 0;
        while (keysWithPrefix.hasNext()) {
            KeyValue next = (KeyValue)keysWithPrefix.next();
            keys.add(next.key);
            values.add(Bytes.wrap((byte[])((byte[])next.value)));
            ++numberOfKeysReturned;
        }
        MatcherAssert.assertThat((Object)numberOfKeysReturned, (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(keys, (Matcher)CoreMatchers.is(Collections.singletonList(this.hi)));
        MatcherAssert.assertThat(values, (Matcher)CoreMatchers.is(Collections.singletonList(Bytes.wrap((byte[])this.there))));
    }

    @Test
    public void shouldReturnNullOnGetWhenDoesntExist() {
        MatcherAssert.assertThat((Object)this.store.get(this.hello), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

