/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.junit.Assert;
import org.junit.Test;

public class SessionWindowTest {
    private long start = 50L;
    private long end = 100L;
    private final SessionWindow window = new SessionWindow(this.start, this.end);
    private final TimeWindow timeWindow = new TimeWindow(this.start, this.end);

    @Test
    public void shouldNotOverlapIfOtherWindowIsBeforeThisWindow() {
        Assert.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(0L, 25L)));
        Assert.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(0L, this.start - 1L)));
        Assert.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(this.start - 1L, this.start - 1L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowEndIsWithinThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, this.start)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, this.start + 1L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 75L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, this.end - 1L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, this.end)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start - 1L, this.start)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start - 1L, this.start + 1L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start - 1L, 75L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start - 1L, this.end - 1L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start - 1L, this.end)));
    }

    @Test
    public void shouldOverlapIfOtherWindowContainsThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, this.end)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, this.end + 1L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 150L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start - 1L, this.end)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start - 1L, this.end + 1L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start - 1L, 150L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start, this.end)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start, this.end + 1L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start, 150L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowIsWithinThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start, this.start)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start, 75L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start, this.end)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(75L, this.end)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.end, this.end)));
    }

    @Test
    public void shouldOverlapIfOtherWindowStartIsWithinThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start, this.end + 1L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.start, 150L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(75L, this.end + 1L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(75L, 150L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.end, this.end + 1L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(this.end, 150L)));
    }

    @Test
    public void shouldNotOverlapIsOtherWindowIsAfterThisWindow() {
        Assert.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(this.end + 1L, this.end + 1L)));
        Assert.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(this.end + 1L, 150L)));
        Assert.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(125L, 150L)));
    }

    @Test
    public void cannotCompareSessionWindowWithDifferentWindowType() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.window.overlap((Window)this.timeWindow));
    }
}

