/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.integration.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.KafkaStreams;

public class CompositeStateListener
implements KafkaStreams.StateListener {
    private final List<KafkaStreams.StateListener> listeners;

    public CompositeStateListener(KafkaStreams.StateListener ... listeners) {
        this(Arrays.asList(listeners));
    }

    public CompositeStateListener(Collection<KafkaStreams.StateListener> stateListeners) {
        this.listeners = Collections.unmodifiableList(new ArrayList<KafkaStreams.StateListener>(stateListeners));
    }

    public void onChange(KafkaStreams.State newState, KafkaStreams.State oldState) {
        for (KafkaStreams.StateListener listener : this.listeners) {
            listener.onChange(newState, oldState);
        }
    }
}

