/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Properties;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public abstract class GraphNode {
    private final Collection<GraphNode> childNodes = new LinkedHashSet<GraphNode>();
    private final Collection<GraphNode> parentNodes = new LinkedHashSet<GraphNode>();
    private final String nodeName;
    private boolean keyChangingOperation;
    private boolean valueChangingOperation;
    private boolean mergeNode;
    private Integer buildPriority;
    private boolean hasWrittenToTopology = false;

    public GraphNode(String nodeName) {
        this.nodeName = nodeName;
    }

    public Collection<GraphNode> parentNodes() {
        return this.parentNodes;
    }

    String[] parentNodeNames() {
        String[] parentNames = new String[this.parentNodes.size()];
        int index = 0;
        for (GraphNode parentNode : this.parentNodes) {
            parentNames[index++] = parentNode.nodeName();
        }
        return parentNames;
    }

    public boolean allParentsWrittenToTopology() {
        for (GraphNode parentNode : this.parentNodes) {
            if (parentNode.hasWrittenToTopology()) continue;
            return false;
        }
        return true;
    }

    public Collection<GraphNode> children() {
        return new LinkedHashSet<GraphNode>(this.childNodes);
    }

    public void clearChildren() {
        for (GraphNode childNode : this.childNodes) {
            childNode.parentNodes.remove(this);
        }
        this.childNodes.clear();
    }

    public boolean removeChild(GraphNode child) {
        return this.childNodes.remove(child) && child.parentNodes.remove(this);
    }

    public void addChild(GraphNode childNode) {
        this.childNodes.add(childNode);
        childNode.parentNodes.add(this);
    }

    public String nodeName() {
        return this.nodeName;
    }

    public boolean isKeyChangingOperation() {
        return this.keyChangingOperation;
    }

    public boolean isValueChangingOperation() {
        return this.valueChangingOperation;
    }

    public boolean isMergeNode() {
        return this.mergeNode;
    }

    public void setMergeNode(boolean mergeNode) {
        this.mergeNode = mergeNode;
    }

    public void setValueChangingOperation(boolean valueChangingOperation) {
        this.valueChangingOperation = valueChangingOperation;
    }

    public void keyChangingOperation(boolean keyChangingOperation) {
        this.keyChangingOperation = keyChangingOperation;
    }

    public void setBuildPriority(int buildPriority) {
        this.buildPriority = buildPriority;
    }

    public Integer buildPriority() {
        return this.buildPriority;
    }

    public abstract void writeToTopology(InternalTopologyBuilder var1, Properties var2);

    public boolean hasWrittenToTopology() {
        return this.hasWrittenToTopology;
    }

    public void setHasWrittenToTopology(boolean hasWrittenToTopology) {
        this.hasWrittenToTopology = hasWrittenToTopology;
    }

    public String toString() {
        Object[] parentNames = this.parentNodeNames();
        return "StreamsGraphNode{nodeName='" + this.nodeName + '\'' + ", buildPriority=" + this.buildPriority + ", hasWrittenToTopology=" + this.hasWrittenToTopology + ", keyChangingOperation=" + this.keyChangingOperation + ", valueChangingOperation=" + this.valueChangingOperation + ", mergeNode=" + this.mergeNode + ", parentNodes=" + Arrays.toString(parentNames) + '}';
    }
}

