/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.state.internals.KeyAndJoinSide;
import org.apache.kafka.streams.state.internals.KeyAndJoinSideSerde;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class KeyAndJoinSideSerializerTest {
    private static final String TOPIC = "some-topic";
    private static final KeyAndJoinSideSerde<String> STRING_SERDE = new KeyAndJoinSideSerde(Serdes.String());

    @Test
    public void shouldSerializeKeyWithJoinSideAsTrue() {
        String value = "some-string";
        KeyAndJoinSide keyAndJoinSide = KeyAndJoinSide.make((boolean)true, (Object)"some-string");
        byte[] serialized = STRING_SERDE.serializer().serialize(TOPIC, (Object)keyAndJoinSide);
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        KeyAndJoinSide deserialized = (KeyAndJoinSide)STRING_SERDE.deserializer().deserialize(TOPIC, serialized);
        MatcherAssert.assertThat((Object)deserialized, (Matcher)Matchers.is((Object)keyAndJoinSide));
    }

    @Test
    public void shouldSerializeKeyWithJoinSideAsFalse() {
        String value = "some-string";
        KeyAndJoinSide keyAndJoinSide = KeyAndJoinSide.make((boolean)false, (Object)"some-string");
        byte[] serialized = STRING_SERDE.serializer().serialize(TOPIC, (Object)keyAndJoinSide);
        MatcherAssert.assertThat((Object)serialized, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        KeyAndJoinSide deserialized = (KeyAndJoinSide)STRING_SERDE.deserializer().deserialize(TOPIC, serialized);
        MatcherAssert.assertThat((Object)deserialized, (Matcher)Matchers.is((Object)keyAndJoinSide));
    }

    @Test
    public void shouldThrowIfSerializeNullData() {
        Assert.assertThrows(NullPointerException.class, () -> STRING_SERDE.serializer().serialize(TOPIC, (Object)KeyAndJoinSide.make((boolean)true, null)));
    }
}

