/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.test.InternalMockProcessorContext;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class ProcessorNodeTest {
    @Test
    public void shouldThrowStreamsExceptionIfExceptionCaughtDuringInit() {
        ProcessorNode node = new ProcessorNode("name", (Processor)new ExceptionalProcessor(), Collections.emptySet());
        Assert.assertThrows(StreamsException.class, () -> node.init(null));
    }

    @Test
    public void shouldThrowStreamsExceptionIfExceptionCaughtDuringClose() {
        ProcessorNode node = new ProcessorNode("name", (Processor)new ExceptionalProcessor(), Collections.emptySet());
        Assert.assertThrows(StreamsException.class, () -> node.init(null));
    }

    @Test
    public void testMetricsWithBuiltInMetricsVersionLatest() {
        Metrics metrics = new Metrics();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, "test-client", "latest", (Time)new MockTime());
        InternalMockProcessorContext context = new InternalMockProcessorContext(streamsMetrics);
        ProcessorNode node = new ProcessorNode("name", (Processor)new NoOpProcessor(), Collections.emptySet());
        node.init(context);
        String threadId = Thread.currentThread().getName();
        String[] latencyOperations = new String[]{"process", "punctuate", "create", "destroy"};
        String groupName = "stream-processor-node-metrics";
        LinkedHashMap<String, String> metricTags = new LinkedHashMap<String, String>();
        String threadIdTagKey = "client-id";
        metricTags.put("processor-node-id", node.name());
        metricTags.put("task-id", context.taskId().toString());
        metricTags.put("client-id", threadId);
        for (String opName : latencyOperations) {
            Assert.assertFalse((boolean)StreamsTestUtils.containsMetric(metrics, opName + "-latency-avg", "stream-processor-node-metrics", metricTags));
            Assert.assertFalse((boolean)StreamsTestUtils.containsMetric(metrics, opName + "-latency-max", "stream-processor-node-metrics", metricTags));
            Assert.assertFalse((boolean)StreamsTestUtils.containsMetric(metrics, opName + "-rate", "stream-processor-node-metrics", metricTags));
            Assert.assertFalse((boolean)StreamsTestUtils.containsMetric(metrics, opName + "-total", "stream-processor-node-metrics", metricTags));
        }
        metricTags.put("processor-node-id", "all");
        for (String opName : latencyOperations) {
            Assert.assertFalse((boolean)StreamsTestUtils.containsMetric(metrics, opName + "-latency-avg", "stream-processor-node-metrics", metricTags));
            Assert.assertFalse((boolean)StreamsTestUtils.containsMetric(metrics, opName + "-latency-max", "stream-processor-node-metrics", metricTags));
            Assert.assertFalse((boolean)StreamsTestUtils.containsMetric(metrics, opName + "-rate", "stream-processor-node-metrics", metricTags));
            Assert.assertFalse((boolean)StreamsTestUtils.containsMetric(metrics, opName + "-total", "stream-processor-node-metrics", metricTags));
        }
    }

    @Test
    public void testTopologyLevelClassCastException() {
        StreamsBuilder builder = new StreamsBuilder();
        builder.stream("streams-plaintext-input").flatMapValues(value -> Collections.singletonList(""));
        Topology topology = builder.build();
        Properties config = new Properties();
        config.put("default.key.serde", Serdes.ByteArraySerde.class);
        config.put("default.value.serde", Serdes.ByteArraySerde.class);
        TopologyTestDriver testDriver = new TopologyTestDriver(topology, config);
        TestInputTopic topic = testDriver.createInputTopic("streams-plaintext-input", (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        StreamsException se = (StreamsException)Assert.assertThrows(StreamsException.class, () -> topic.pipeInput((Object)"a-key", (Object)"a value"));
        String msg = se.getMessage();
        Assert.assertTrue((String)"Error about class cast with serdes", (boolean)msg.contains("ClassCastException"));
        Assert.assertTrue((String)"Error about class cast with serdes", (boolean)msg.contains("Serdes"));
    }

    @Test
    public void testTopologyLevelConfigException() {
        StreamsBuilder builder = new StreamsBuilder();
        builder.stream("streams-plaintext-input").flatMapValues(value -> Collections.singletonList(""));
        Topology topology = builder.build();
        ConfigException se = (ConfigException)Assert.assertThrows(ConfigException.class, () -> new TopologyTestDriver(topology));
        String msg = se.getMessage();
        Assert.assertTrue((String)"Error about class cast with serdes", (boolean)msg.contains("StreamsConfig#DEFAULT_KEY_SERDE_CLASS_CONFIG"));
        Assert.assertTrue((String)"Error about class cast with serdes", (boolean)msg.contains("specify a key serde"));
    }

    @Test
    public void testTopologyLevelClassCastExceptionDirect() {
        Metrics metrics = new Metrics();
        StreamsMetricsImpl streamsMetrics = new StreamsMetricsImpl(metrics, "test-client", "latest", (Time)new MockTime());
        InternalMockProcessorContext context = new InternalMockProcessorContext(streamsMetrics);
        ProcessorNode node = new ProcessorNode("name", (Processor)new ClassCastProcessor(), Collections.emptySet());
        node.init(context);
        StreamsException se = (StreamsException)Assert.assertThrows(StreamsException.class, () -> node.process(new Record((Object)"aKey", (Object)"aValue", 0L)));
        MatcherAssert.assertThat((Object)se.getCause(), (Matcher)CoreMatchers.instanceOf(ClassCastException.class));
        MatcherAssert.assertThat((Object)se.getMessage(), (Matcher)CoreMatchers.containsString((String)"default Serdes"));
        MatcherAssert.assertThat((Object)se.getMessage(), (Matcher)CoreMatchers.containsString((String)"input types"));
    }

    private static class ClassCastProcessor
    extends ExceptionalProcessor {
        private ClassCastProcessor() {
        }

        @Override
        public void init(ProcessorContext context) {
        }

        @Override
        public void process(Object key, Object value) {
            throw new ClassCastException("Incompatible types simulation exception.");
        }
    }

    private static class NoOpProcessor
    implements Processor<Object, Object> {
        private NoOpProcessor() {
        }

        public void init(ProcessorContext context) {
        }

        public void process(Object key, Object value) {
        }

        public void close() {
        }
    }

    private static class ExceptionalProcessor
    implements Processor<Object, Object> {
        private ExceptionalProcessor() {
        }

        public void init(ProcessorContext context) {
            throw new RuntimeException();
        }

        public void process(Object key, Object value) {
            throw new RuntimeException();
        }

        public void close() {
            throw new RuntimeException();
        }
    }
}

