/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.TestInputTopic;
import org.apache.kafka.streams.TopologyTestDriver;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Grouped;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Merger;
import org.apache.kafka.streams.kstream.Named;
import org.apache.kafka.streams.kstream.SessionWindowedKStream;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.test.MockAggregator;
import org.apache.kafka.test.MockInitializer;
import org.apache.kafka.test.MockProcessorSupplier;
import org.apache.kafka.test.MockReducer;
import org.apache.kafka.test.StreamsTestUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SessionWindowedKStreamImplTest {
    private static final String TOPIC = "input";
    private final StreamsBuilder builder = new StreamsBuilder();
    private final Properties props = StreamsTestUtils.getStreamsConfig(Serdes.String(), Serdes.String());
    private final Merger<String, String> sessionMerger = (aggKey, aggOne, aggTwo) -> aggOne + "+" + aggTwo;
    private SessionWindowedKStream<String, String> stream;

    @Before
    public void before() {
        KStream stream = this.builder.stream(TOPIC, Consumed.with((Serde)Serdes.String(), (Serde)Serdes.String()));
        this.stream = stream.groupByKey(Grouped.with((Serde)Serdes.String(), (Serde)Serdes.String())).windowedBy(SessionWindows.with((Duration)Duration.ofMillis(500L)));
    }

    @Test
    public void shouldCountSessionWindowedWithCachingDisabled() {
        this.props.put("cache.max.bytes.buffering", (Object)0);
        this.shouldCountSessionWindowed();
    }

    @Test
    public void shouldCountSessionWindowedWithCachingEnabled() {
        this.shouldCountSessionWindowed();
    }

    private void shouldCountSessionWindowed() {
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        this.stream.count().toStream().process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
        }
        Map result = supplier.theCapturedProcessor().lastValueAndTimestampPerKey();
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat(result.get(new Windowed((Object)"1", (Window)new SessionWindow(10L, 15L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)2L, (long)15L)));
        MatcherAssert.assertThat(result.get(new Windowed((Object)"2", (Window)new SessionWindow(599L, 600L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)2L, (long)600L)));
        MatcherAssert.assertThat(result.get(new Windowed((Object)"1", (Window)new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)1L, (long)600L)));
    }

    @Test
    public void shouldReduceWindowed() {
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        this.stream.reduce(MockReducer.STRING_ADDER).toStream().process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
        }
        Map result = supplier.theCapturedProcessor().lastValueAndTimestampPerKey();
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat(result.get(new Windowed((Object)"1", (Window)new SessionWindow(10L, 15L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"1+2", (long)15L)));
        MatcherAssert.assertThat(result.get(new Windowed((Object)"2", (Window)new SessionWindow(599L, 600L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"1+2", (long)600L)));
        MatcherAssert.assertThat(result.get(new Windowed((Object)"1", (Window)new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"3", (long)600L)));
    }

    @Test
    public void shouldAggregateSessionWindowed() {
        MockProcessorSupplier supplier = new MockProcessorSupplier();
        this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, this.sessionMerger, Materialized.with((Serde)Serdes.String(), (Serde)Serdes.String())).toStream().process(supplier, new String[0]);
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
        }
        Map result = supplier.theCapturedProcessor().lastValueAndTimestampPerKey();
        MatcherAssert.assertThat((Object)result.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat(result.get(new Windowed((Object)"1", (Window)new SessionWindow(10L, 15L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"0+0+1+2", (long)15L)));
        MatcherAssert.assertThat(result.get(new Windowed((Object)"2", (Window)new SessionWindow(599L, 600L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"0+0+1+2", (long)600L)));
        MatcherAssert.assertThat(result.get(new Windowed((Object)"1", (Window)new SessionWindow(600L, 600L))), (Matcher)CoreMatchers.equalTo((Object)ValueAndTimestamp.make((Object)"0+3", (long)600L)));
    }

    @Test
    public void shouldMaterializeCount() {
        this.stream.count(Materialized.as((String)"count-store"));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
            SessionStore store = driver.getSessionStore("count-store");
            List data = StreamsTestUtils.toList(store.fetch((Object)"1", (Object)"2"));
            MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new SessionWindow(10L, 15L)), (Object)2L), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new SessionWindow(600L, 600L)), (Object)1L), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new SessionWindow(599L, 600L)), (Object)2L))));
        }
    }

    @Test
    public void shouldMaterializeReduced() {
        this.stream.reduce(MockReducer.STRING_ADDER, Materialized.as((String)"reduced"));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
            SessionStore sessionStore = driver.getSessionStore("reduced");
            List data = StreamsTestUtils.toList(sessionStore.fetch((Object)"1", (Object)"2"));
            MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new SessionWindow(10L, 15L)), (Object)"1+2"), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new SessionWindow(600L, 600L)), (Object)"3"), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new SessionWindow(599L, 600L)), (Object)"1+2"))));
        }
    }

    @Test
    public void shouldMaterializeAggregated() {
        this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, this.sessionMerger, Materialized.as((String)"aggregated").withValueSerde(Serdes.String()));
        try (TopologyTestDriver driver = new TopologyTestDriver(this.builder.build(), this.props);){
            this.processData(driver);
            SessionStore sessionStore = driver.getSessionStore("aggregated");
            List data = StreamsTestUtils.toList(sessionStore.fetch((Object)"1", (Object)"2"));
            MatcherAssert.assertThat(data, (Matcher)CoreMatchers.equalTo(Arrays.asList(KeyValue.pair((Object)new Windowed((Object)"1", (Window)new SessionWindow(10L, 15L)), (Object)"0+0+1+2"), KeyValue.pair((Object)new Windowed((Object)"1", (Window)new SessionWindow(600L, 600L)), (Object)"0+3"), KeyValue.pair((Object)new Windowed((Object)"2", (Window)new SessionWindow(599L, 600L)), (Object)"0+0+1+2"))));
        }
    }

    @Test
    public void shouldThrowNullPointerOnAggregateIfInitializerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.stream.aggregate(null, MockAggregator.TOSTRING_ADDER, this.sessionMerger));
    }

    @Test
    public void shouldThrowNullPointerOnAggregateIfAggregatorIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.stream.aggregate(MockInitializer.STRING_INIT, null, this.sessionMerger));
    }

    @Test
    public void shouldThrowNullPointerOnAggregateIfMergerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, null));
    }

    @Test
    public void shouldThrowNullPointerOnReduceIfReducerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.stream.reduce(null));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedAggregateIfInitializerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.stream.aggregate(null, MockAggregator.TOSTRING_ADDER, this.sessionMerger, Materialized.as((String)"store")));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedAggregateIfAggregatorIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.stream.aggregate(MockInitializer.STRING_INIT, null, this.sessionMerger, Materialized.as((String)"store")));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedAggregateIfMergerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, null, Materialized.as((String)"store")));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedAggregateIfMaterializedIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.stream.aggregate(MockInitializer.STRING_INIT, MockAggregator.TOSTRING_ADDER, this.sessionMerger, (Materialized)null));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedReduceIfReducerIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.stream.reduce(null, Materialized.as((String)"store")));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedReduceIfMaterializedIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.stream.reduce(MockReducer.STRING_ADDER, (Materialized)null));
    }

    @Test
    public void shouldThrowNullPointerOnMaterializedReduceIfNamedIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.stream.reduce(MockReducer.STRING_ADDER, (Named)null));
    }

    @Test
    public void shouldThrowNullPointerOnCountIfMaterializedIsNull() {
        Assert.assertThrows(NullPointerException.class, () -> this.stream.count((Materialized)null));
    }

    private void processData(TopologyTestDriver driver) {
        TestInputTopic inputTopic = driver.createInputTopic(TOPIC, (Serializer)new StringSerializer(), (Serializer)new StringSerializer());
        inputTopic.pipeInput((Object)"1", (Object)"1", 10L);
        inputTopic.pipeInput((Object)"1", (Object)"2", 15L);
        inputTopic.pipeInput((Object)"1", (Object)"3", 600L);
        inputTopic.pipeInput((Object)"2", (Object)"1", 600L);
        inputTopic.pipeInput((Object)"2", (Object)"2", 599L);
    }
}

