/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.SourceNode;

public class MockSourceNode<KIn, VIn, KOut, VOut>
extends SourceNode<KIn, VIn, KOut, VOut> {
    private static final String NAME = "MOCK-SOURCE-";
    private static final AtomicInteger INDEX = new AtomicInteger(1);
    public int numReceived = 0;
    public final ArrayList<KIn> keys = new ArrayList();
    public final ArrayList<VIn> values = new ArrayList();
    public boolean initialized;
    public boolean closed;

    public MockSourceNode(Deserializer<KIn> keyDeserializer, Deserializer<VIn> valDeserializer) {
        super(NAME + INDEX.getAndIncrement(), keyDeserializer, valDeserializer);
    }

    public void process(Record<KIn, VIn> record) {
        ++this.numReceived;
        this.keys.add(record.key());
        this.values.add(record.value());
    }

    public void init(InternalProcessorContext context) {
        super.init(context);
        this.initialized = true;
    }

    public void close() {
        super.close();
        this.closed = true;
    }
}

