/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.MockConsumer;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.internals.InternalTopicConfig;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.test.MockClientSupplier;

public class MockInternalTopicManager
extends InternalTopicManager {
    public final Map<String, Integer> readyTopics = new HashMap<String, Integer>();
    private final MockConsumer<byte[], byte[]> restoreConsumer;
    private final boolean mockCreateInternalTopics;

    public MockInternalTopicManager(Time time, StreamsConfig streamsConfig, MockConsumer<byte[], byte[]> restoreConsumer, boolean mockCreateInternalTopics) {
        super(time, new MockClientSupplier().getAdmin(streamsConfig.originals()), streamsConfig);
        this.restoreConsumer = restoreConsumer;
        this.mockCreateInternalTopics = mockCreateInternalTopics;
    }

    public Set<String> makeReady(Map<String, InternalTopicConfig> topics) {
        for (InternalTopicConfig topic : topics.values()) {
            String topicName = topic.name();
            int numberOfPartitions = (Integer)topic.numberOfPartitions().get();
            this.readyTopics.put(topicName, numberOfPartitions);
            ArrayList<PartitionInfo> partitions = new ArrayList<PartitionInfo>();
            for (int i = 0; i < numberOfPartitions; ++i) {
                partitions.add(new PartitionInfo(topicName, i, null, null, null));
            }
            this.restoreConsumer.updatePartitions(topicName, partitions);
        }
        return this.mockCreateInternalTopics ? topics.keySet() : Collections.emptySet();
    }

    protected Map<String, Integer> getNumPartitions(Set<String> topics, Set<String> tempUnknownTopics) {
        HashMap<String, Integer> partitions = new HashMap<String, Integer>();
        for (String topic : topics) {
            partitions.put(topic, this.restoreConsumer.partitionsFor(topic) == null ? null : Integer.valueOf(this.restoreConsumer.partitionsFor(topic).size()));
        }
        return partitions;
    }
}

