/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.internals.InMemoryTimeOrderedKeyValueBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class InMemoryTimeOrderedKeyValueBufferTest {
    @Test
    public void bufferShouldAllowCacheEnablement() {
        new InMemoryTimeOrderedKeyValueBuffer.Builder(null, null, null).withCachingEnabled();
    }

    @Test
    public void bufferShouldAllowCacheDisablement() {
        new InMemoryTimeOrderedKeyValueBuffer.Builder(null, null, null).withCachingDisabled();
    }

    @Test
    public void bufferShouldAllowLoggingEnablement() {
        String expect = "3";
        HashMap<String, String> logConfig = new HashMap<String, String>();
        logConfig.put("min.insync.replicas", "3");
        StoreBuilder builder = new InMemoryTimeOrderedKeyValueBuffer.Builder(null, null, null).withLoggingEnabled(logConfig);
        MatcherAssert.assertThat((Object)builder.logConfig(), (Matcher)Matchers.is(Collections.singletonMap("min.insync.replicas", "3")));
        MatcherAssert.assertThat((Object)builder.loggingEnabled(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void bufferShouldAllowLoggingDisablement() {
        StoreBuilder builder = new InMemoryTimeOrderedKeyValueBuffer.Builder(null, null, null).withLoggingDisabled();
        MatcherAssert.assertThat((Object)builder.logConfig(), (Matcher)Matchers.is(Collections.emptyMap()));
        MatcherAssert.assertThat((Object)builder.loggingEnabled(), (Matcher)Matchers.is((Object)false));
    }
}

