/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.metrics;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.streams.processor.internals.metrics.ProcessorNodeMetrics;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.modules.junit4.PowerMockRunnerDelegate;

@RunWith(value=PowerMockRunner.class)
@PowerMockRunnerDelegate(value=Parameterized.class)
@PrepareForTest(value={StreamsMetricsImpl.class, Sensor.class})
public class ProcessorNodeMetricsTest {
    private static final String THREAD_ID = "test-thread";
    private static final String TASK_ID = "test-task";
    private static final String PROCESSOR_NODE_ID = "test-processor";
    private final Sensor expectedSensor = (Sensor)EasyMock.mock(Sensor.class);
    private final Sensor expectedParentSensor = (Sensor)EasyMock.mock(Sensor.class);
    private final StreamsMetricsImpl streamsMetrics = (StreamsMetricsImpl)PowerMock.createMock(StreamsMetricsImpl.class);
    private final Map<String, String> tagMap = Collections.singletonMap("hello", "world");
    private final Map<String, String> parentTagMap = Collections.singletonMap("hi", "universe");
    @Parameterized.Parameter
    public StreamsMetricsImpl.Version builtInMetricsVersion;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({StreamsMetricsImpl.Version.LATEST}, {StreamsMetricsImpl.Version.FROM_0100_TO_24});
    }

    @Before
    public void setUp() {
        EasyMock.expect((Object)this.streamsMetrics.version()).andReturn((Object)this.builtInMetricsVersion).anyTimes();
        PowerMock.mockStatic(StreamsMetricsImpl.class);
    }

    @Test
    public void shouldGetSuppressionEmitSensor() {
        String metricNamePrefix = "suppression-emit";
        String descriptionOfCount = "The total number of emitted records from the suppression buffer";
        String descriptionOfRate = "The average number of emitted records from the suppression buffer per second";
        EasyMock.expect((Object)this.streamsMetrics.nodeLevelSensor(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID, "suppression-emit", Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.nodeLevelTagMap(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-processor-node-metrics", this.tagMap, (String)"suppression-emit", (String)"The average number of emitted records from the suppression buffer per second", (String)"The total number of emitted records from the suppression buffer");
        this.verifySensor(() -> ProcessorNodeMetrics.suppressionEmitSensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetIdempotentUpdateSkipSensor() {
        String metricNamePrefix = "idempotent-update-skip";
        String descriptionOfCount = "The total number of skipped idempotent updates";
        String descriptionOfRate = "The average number of skipped idempotent updates per second";
        EasyMock.expect((Object)this.streamsMetrics.nodeLevelSensor(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID, "idempotent-update-skip", Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.nodeLevelTagMap(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-processor-node-metrics", this.tagMap, (String)"idempotent-update-skip", (String)"The average number of skipped idempotent updates per second", (String)"The total number of skipped idempotent updates");
        this.verifySensor(() -> ProcessorNodeMetrics.skippedIdempotentUpdatesSensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetProcessSensor() {
        String metricNamePrefix = "process";
        String descriptionOfCount = "The total number of calls to process";
        String descriptionOfRate = "The average number of calls to process per second";
        String descriptionOfAvgLatency = "The average latency of calls to process";
        String descriptionOfMaxLatency = "The maximum latency of calls to process";
        this.shouldGetThroughputAndLatencySensorWithParentOrEmptySensor("process", "The average number of calls to process per second", "The total number of calls to process", "The average latency of calls to process", "The maximum latency of calls to process", () -> ProcessorNodeMetrics.processSensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetProcessAtSourceSensor() {
        String metricNamePrefix = "process";
        String descriptionOfCount = "The total number of calls to process";
        String descriptionOfRate = "The average number of calls to process per second";
        EasyMock.expect((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, "process", Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedParentSensor);
        EasyMock.expect((Object)this.streamsMetrics.taskLevelTagMap(THREAD_ID, TASK_ID)).andReturn(this.parentTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedParentSensor, (String)"stream-task-metrics", this.parentTagMap, (String)"process", (String)"The average number of calls to process per second", (String)"The total number of calls to process");
        this.setUpThroughputSensor("process", "The average number of calls to process per second", "The total number of calls to process", Sensor.RecordingLevel.DEBUG, this.expectedParentSensor);
        this.verifySensor(() -> ProcessorNodeMetrics.processAtSourceSensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetPunctuateSensor() {
        String metricNamePrefix = "punctuate";
        String descriptionOfCount = "The total number of calls to punctuate";
        String descriptionOfRate = "The average number of calls to punctuate per second";
        String descriptionOfAvgLatency = "The average latency of calls to punctuate";
        String descriptionOfMaxLatency = "The maximum latency of calls to punctuate";
        this.shouldGetThroughputAndLatencySensorWithParentOrEmptySensor("punctuate", "The average number of calls to punctuate per second", "The total number of calls to punctuate", "The average latency of calls to punctuate", "The maximum latency of calls to punctuate", () -> ProcessorNodeMetrics.punctuateSensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetCreateSensor() {
        String metricNamePrefix = "create";
        String descriptionOfCount = "The total number of processor nodes created";
        String descriptionOfRate = "The average number of processor nodes created per second";
        String descriptionOfAvgLatency = "The average latency of creations of processor nodes";
        String descriptionOfMaxLatency = "The maximum latency of creations of processor nodes";
        this.shouldGetThroughputAndLatencySensorWithParentOrEmptySensor("create", "The average number of processor nodes created per second", "The total number of processor nodes created", "The average latency of creations of processor nodes", "The maximum latency of creations of processor nodes", () -> ProcessorNodeMetrics.createSensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetDestroySensor() {
        String metricNamePrefix = "destroy";
        String descriptionOfCount = "The total number of destructions of processor nodes";
        String descriptionOfRate = "The average number of destructions of processor nodes per second";
        String descriptionOfAvgLatency = "The average latency of destructions of processor nodes";
        String descriptionOfMaxLatency = "The maximum latency of destructions of processor nodes";
        this.shouldGetThroughputAndLatencySensorWithParentOrEmptySensor("destroy", "The average number of destructions of processor nodes per second", "The total number of destructions of processor nodes", "The average latency of destructions of processor nodes", "The maximum latency of destructions of processor nodes", () -> ProcessorNodeMetrics.destroySensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetForwardSensor() {
        String metricNamePrefix = "forward";
        String descriptionOfCount = "The total number of calls to forward";
        String descriptionOfRate = "The average number of calls to forward per second";
        this.setUpThroughputParentSensor("forward", "The average number of calls to forward per second", "The total number of calls to forward");
        this.setUpThroughputSensor("forward", "The average number of calls to forward per second", "The total number of calls to forward", Sensor.RecordingLevel.DEBUG, this.expectedParentSensor);
        this.verifySensor(() -> ProcessorNodeMetrics.forwardSensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetLateRecordDropSensor() {
        String metricNamePrefix = "late-record-drop";
        String descriptionOfCount = "The total number of dropped late records";
        String descriptionOfRate = "The average number of dropped late records per second";
        this.setUpThroughputSensor("late-record-drop", "The average number of dropped late records per second", "The total number of dropped late records", Sensor.RecordingLevel.INFO, new Sensor[0]);
        this.verifySensor(() -> ProcessorNodeMetrics.lateRecordDropSensor((String)THREAD_ID, (String)TASK_ID, (String)PROCESSOR_NODE_ID, (StreamsMetricsImpl)this.streamsMetrics));
    }

    @Test
    public void shouldGetProcessAtSourceSensorOrForwardSensor() {
        if (this.builtInMetricsVersion == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            this.shouldGetForwardSensor();
        } else {
            this.shouldGetProcessAtSourceSensor();
        }
    }

    private void shouldGetThroughputAndLatencySensorWithParentOrEmptySensor(String metricNamePrefix, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvgLatency, String descriptionOfMaxLatency, Supplier<Sensor> sensorSupplier) {
        if (this.builtInMetricsVersion == StreamsMetricsImpl.Version.FROM_0100_TO_24) {
            this.setUpThroughputAndLatencySensorWithParent(metricNamePrefix, descriptionOfRate, descriptionOfCount, descriptionOfAvgLatency, descriptionOfMaxLatency);
        } else {
            EasyMock.expect((Object)this.streamsMetrics.nodeLevelSensor(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID, metricNamePrefix, Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedSensor);
        }
        this.verifySensor(sensorSupplier);
    }

    private void setUpThroughputAndLatencySensorWithParent(String metricNamePrefix, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvgLatency, String descriptionOfMaxLatency) {
        this.setUpThroughputAndLatencyParentSensor(metricNamePrefix, descriptionOfRate, descriptionOfCount, descriptionOfAvgLatency, descriptionOfMaxLatency);
        this.setUpThroughputAndLatencySensor(metricNamePrefix, descriptionOfRate, descriptionOfCount, descriptionOfAvgLatency, descriptionOfMaxLatency, this.expectedParentSensor);
    }

    private void setUpThroughputAndLatencyParentSensor(String metricNamePrefix, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvg, String descriptionOfMax) {
        EasyMock.expect((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, metricNamePrefix, Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedParentSensor);
        EasyMock.expect((Object)this.streamsMetrics.nodeLevelTagMap(THREAD_ID, TASK_ID, "all")).andReturn(this.parentTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedParentSensor, (String)"stream-processor-node-metrics", this.parentTagMap, (String)metricNamePrefix, (String)descriptionOfRate, (String)descriptionOfCount);
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedParentSensor, (String)"stream-processor-node-metrics", this.parentTagMap, (String)(metricNamePrefix + "-latency"), (String)descriptionOfAvg, (String)descriptionOfMax);
    }

    private void setUpThroughputParentSensor(String metricNamePrefix, String descriptionOfRate, String descriptionOfCount) {
        EasyMock.expect((Object)this.streamsMetrics.taskLevelSensor(THREAD_ID, TASK_ID, metricNamePrefix, Sensor.RecordingLevel.DEBUG, new Sensor[0])).andReturn((Object)this.expectedParentSensor);
        EasyMock.expect((Object)this.streamsMetrics.nodeLevelTagMap(THREAD_ID, TASK_ID, "all")).andReturn(this.parentTagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedParentSensor, (String)"stream-processor-node-metrics", this.parentTagMap, (String)metricNamePrefix, (String)descriptionOfRate, (String)descriptionOfCount);
    }

    private void setUpThroughputAndLatencySensor(String metricNamePrefix, String descriptionOfRate, String descriptionOfCount, String descriptionOfAvgLatency, String descriptionOfMaxLatency, Sensor ... parentSensors) {
        this.setUpThroughputSensor(metricNamePrefix, descriptionOfRate, descriptionOfCount, Sensor.RecordingLevel.DEBUG, parentSensors);
        StreamsMetricsImpl.addAvgAndMaxToSensor((Sensor)this.expectedSensor, (String)"stream-processor-node-metrics", this.tagMap, (String)(metricNamePrefix + "-latency"), (String)descriptionOfAvgLatency, (String)descriptionOfMaxLatency);
    }

    private void setUpThroughputSensor(String metricNamePrefix, String descriptionOfRate, String descriptionOfCount, Sensor.RecordingLevel recordingLevel, Sensor ... parentSensors) {
        EasyMock.expect((Object)this.streamsMetrics.nodeLevelSensor(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID, metricNamePrefix, recordingLevel, parentSensors)).andReturn((Object)this.expectedSensor);
        EasyMock.expect((Object)this.streamsMetrics.nodeLevelTagMap(THREAD_ID, TASK_ID, PROCESSOR_NODE_ID)).andReturn(this.tagMap);
        StreamsMetricsImpl.addInvocationRateAndCountToSensor((Sensor)this.expectedSensor, (String)"stream-processor-node-metrics", this.tagMap, (String)metricNamePrefix, (String)descriptionOfRate, (String)descriptionOfCount);
    }

    private void verifySensor(Supplier<Sensor> sensorSupplier) {
        PowerMock.replay((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        Sensor sensor = sensorSupplier.get();
        PowerMock.verify((Object[])new Object[]{StreamsMetricsImpl.class, this.streamsMetrics});
        MatcherAssert.assertThat((Object)sensor, (Matcher)CoreMatchers.is((Object)this.expectedSensor));
    }
}

