/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.LockException;
import org.apache.kafka.streams.errors.ProcessorStateException;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.AbstractTask;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StateManagerUtil;
import org.apache.kafka.streams.processor.internals.Task;
import org.apache.kafka.test.MockKeyValueStore;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.easymock.Mock;
import org.easymock.MockType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.slf4j.Logger;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={Utils.class})
public class StateManagerUtilTest {
    @Mock(type=MockType.NICE)
    private ProcessorStateManager stateManager;
    @Mock(type=MockType.NICE)
    private StateDirectory stateDirectory;
    @Mock(type=MockType.NICE)
    private ProcessorTopology topology;
    @Mock(type=MockType.NICE)
    private InternalProcessorContext processorContext;
    private IMocksControl ctrl;
    private Logger logger = new LogContext("test").logger(AbstractTask.class);
    private final TaskId taskId = new TaskId(0, 0);

    @Before
    public void setup() {
        this.ctrl = EasyMock.createStrictControl();
        this.topology = (ProcessorTopology)this.ctrl.createMock(ProcessorTopology.class);
        this.processorContext = (InternalProcessorContext)this.ctrl.createMock(InternalProcessorContext.class);
        this.stateManager = (ProcessorStateManager)this.ctrl.createMock(ProcessorStateManager.class);
        this.stateDirectory = (StateDirectory)this.ctrl.createMock(StateDirectory.class);
    }

    @Test
    public void testRegisterStateStoreWhenTopologyEmpty() {
        EasyMock.expect((Object)this.topology.stateStores()).andReturn(Collections.emptyList());
        this.ctrl.checkOrder(true);
        this.ctrl.replay();
        StateManagerUtil.registerStateStores((Logger)this.logger, (String)"logPrefix:", (ProcessorTopology)this.topology, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (InternalProcessorContext)this.processorContext);
        this.ctrl.verify();
    }

    @Test
    public void testRegisterStateStoreFailToLockStateDirectory() throws IOException {
        EasyMock.expect((Object)this.topology.stateStores()).andReturn(Collections.singletonList(new MockKeyValueStore("store", false)));
        EasyMock.expect((Object)this.stateManager.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.stateDirectory.lock(this.taskId)).andReturn((Object)false);
        this.ctrl.checkOrder(true);
        this.ctrl.replay();
        LockException thrown = (LockException)Assert.assertThrows(LockException.class, () -> StateManagerUtil.registerStateStores((Logger)this.logger, (String)"logPrefix:", (ProcessorTopology)this.topology, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (InternalProcessorContext)this.processorContext));
        Assert.assertEquals((Object)"logPrefix:Failed to lock the state directory for task 0_0", (Object)thrown.getMessage());
        this.ctrl.verify();
    }

    @Test
    public void testRegisterStateStoreLockThrowIOExceptionWrappedAsStreamException() throws IOException {
        EasyMock.expect((Object)this.topology.stateStores()).andReturn(Collections.singletonList(new MockKeyValueStore("store", false)));
        EasyMock.expect((Object)this.stateManager.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.stateDirectory.lock(this.taskId)).andThrow((Throwable)new IOException("Fail to lock state dir"));
        this.ctrl.checkOrder(true);
        this.ctrl.replay();
        StreamsException thrown = (StreamsException)Assert.assertThrows(StreamsException.class, () -> StateManagerUtil.registerStateStores((Logger)this.logger, (String)"logPrefix:", (ProcessorTopology)this.topology, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (InternalProcessorContext)this.processorContext));
        Assert.assertEquals((Object)"logPrefix:Fatal error while trying to lock the state directory for task 0_0", (Object)thrown.getMessage());
        Assert.assertEquals(IOException.class, thrown.getCause().getClass());
        Assert.assertEquals((Object)"Fail to lock state dir", (Object)thrown.getCause().getMessage());
        this.ctrl.verify();
    }

    @Test
    public void testRegisterStateStores() throws IOException {
        MockKeyValueStore store1 = new MockKeyValueStore("store1", false);
        MockKeyValueStore store2 = new MockKeyValueStore("store2", false);
        List<StateStore> stateStores = Arrays.asList(store1, store2);
        EasyMock.expect((Object)this.topology.stateStores()).andReturn(stateStores);
        EasyMock.expect((Object)this.stateManager.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.stateDirectory.lock(this.taskId)).andReturn((Object)true);
        EasyMock.expect((Object)this.stateDirectory.directoryForTaskIsEmpty(this.taskId)).andReturn((Object)true);
        EasyMock.expect((Object)this.topology.stateStores()).andReturn(stateStores);
        this.stateManager.registerStateStores(stateStores, this.processorContext);
        this.stateManager.initializeStoreOffsetsFromCheckpoint(true);
        EasyMock.expectLastCall();
        this.ctrl.checkOrder(true);
        this.ctrl.replay();
        StateManagerUtil.registerStateStores((Logger)this.logger, (String)"logPrefix:", (ProcessorTopology)this.topology, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (InternalProcessorContext)this.processorContext);
        this.ctrl.verify();
    }

    @Test
    public void testCloseStateManagerClean() throws IOException {
        EasyMock.expect((Object)this.stateManager.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.stateDirectory.lock(this.taskId)).andReturn((Object)true);
        this.stateManager.close();
        EasyMock.expectLastCall();
        this.stateDirectory.unlock(this.taskId);
        EasyMock.expectLastCall();
        this.ctrl.checkOrder(true);
        this.ctrl.replay();
        StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)true, (boolean)false, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE);
        this.ctrl.verify();
    }

    @Test
    public void testCloseStateManagerThrowsExceptionWhenClean() throws IOException {
        EasyMock.expect((Object)this.stateManager.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.stateDirectory.lock(this.taskId)).andReturn((Object)true);
        this.stateManager.close();
        EasyMock.expectLastCall();
        this.stateDirectory.unlock(this.taskId);
        EasyMock.expectLastCall().andThrow((Throwable)new IOException("Timeout"));
        this.ctrl.checkOrder(true);
        this.ctrl.replay();
        ProcessorStateException thrown = (ProcessorStateException)Assert.assertThrows(ProcessorStateException.class, () -> StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)true, (boolean)false, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE));
        Assert.assertEquals(IOException.class, thrown.getCause().getClass());
        this.ctrl.verify();
    }

    @Test
    public void testCloseStateManagerOnlyThrowsFirstExceptionWhenClean() throws IOException {
        EasyMock.expect((Object)this.stateManager.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.stateDirectory.lock(this.taskId)).andReturn((Object)true);
        this.stateManager.close();
        EasyMock.expectLastCall().andThrow((Throwable)new ProcessorStateException("state manager failed to close"));
        this.stateDirectory.unlock(this.taskId);
        EasyMock.expectLastCall().andThrow((Throwable)new IOException("Timeout"));
        this.ctrl.checkOrder(true);
        this.ctrl.replay();
        ProcessorStateException thrown = (ProcessorStateException)Assert.assertThrows(ProcessorStateException.class, () -> StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)true, (boolean)false, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE));
        Assert.assertEquals((Object)"state manager failed to close", (Object)thrown.getMessage());
        this.ctrl.verify();
    }

    @Test
    public void testCloseStateManagerThrowsExceptionWhenDirty() throws IOException {
        EasyMock.expect((Object)this.stateManager.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.stateDirectory.lock(this.taskId)).andReturn((Object)true);
        this.stateManager.close();
        EasyMock.expectLastCall();
        this.stateDirectory.unlock(this.taskId);
        EasyMock.expectLastCall().andThrow((Throwable)new IOException("Timeout"));
        this.ctrl.checkOrder(true);
        this.ctrl.replay();
        ProcessorStateException thrown = (ProcessorStateException)Assert.assertThrows(ProcessorStateException.class, () -> StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)false, (boolean)false, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE));
        Assert.assertEquals(IOException.class, thrown.getCause().getClass());
        this.ctrl.verify();
    }

    @Test
    public void testCloseStateManagerWithStateStoreWipeOut() throws IOException {
        EasyMock.expect((Object)this.stateManager.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.stateDirectory.lock(this.taskId)).andReturn((Object)true);
        this.stateManager.close();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.stateManager.baseDir()).andReturn((Object)TestUtils.tempDirectory((String)"state_store"));
        this.stateDirectory.unlock(this.taskId);
        EasyMock.expectLastCall();
        this.ctrl.checkOrder(true);
        this.ctrl.replay();
        StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)false, (boolean)true, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE);
        this.ctrl.verify();
    }

    @Test
    public void shouldStillWipeStateStoresIfCloseThrowsException() throws IOException {
        File randomFile = new File("/random/path");
        PowerMock.mockStatic(Utils.class);
        EasyMock.expect((Object)this.stateManager.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.stateDirectory.lock(this.taskId)).andReturn((Object)true);
        this.stateManager.close();
        EasyMock.expectLastCall().andThrow((Throwable)new ProcessorStateException("Close failed"));
        EasyMock.expect((Object)this.stateManager.baseDir()).andReturn((Object)randomFile);
        Utils.delete((File)randomFile);
        this.stateDirectory.unlock(this.taskId);
        EasyMock.expectLastCall();
        this.ctrl.checkOrder(true);
        this.ctrl.replay();
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertThrows(ProcessorStateException.class, () -> StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)false, (boolean)true, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE));
        this.ctrl.verify();
    }

    @Test
    public void testCloseStateManagerWithStateStoreWipeOutRethrowWrappedIOException() throws IOException {
        File unknownFile = new File("/unknown/path");
        PowerMock.mockStatic(Utils.class);
        EasyMock.expect((Object)this.stateManager.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.stateDirectory.lock(this.taskId)).andReturn((Object)true);
        this.stateManager.close();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.stateManager.baseDir()).andReturn((Object)unknownFile);
        Utils.delete((File)unknownFile);
        EasyMock.expectLastCall().andThrow((Throwable)new IOException("Deletion failed"));
        this.stateDirectory.unlock(this.taskId);
        EasyMock.expectLastCall();
        this.ctrl.checkOrder(true);
        this.ctrl.replay();
        PowerMock.replayAll((Object[])new Object[0]);
        ProcessorStateException thrown = (ProcessorStateException)Assert.assertThrows(ProcessorStateException.class, () -> StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)false, (boolean)true, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE));
        Assert.assertEquals(IOException.class, thrown.getCause().getClass());
        this.ctrl.verify();
    }

    @Test
    public void shouldNotCloseStateManagerIfUnableToLockTaskDirectory() throws IOException {
        EasyMock.expect((Object)this.stateManager.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.stateDirectory.lock(this.taskId)).andReturn((Object)false);
        this.stateManager.close();
        EasyMock.expectLastCall().andThrow((Throwable)((Object)new AssertionError((Object)"Should not be trying to close state you don't own!")));
        this.ctrl.checkOrder(true);
        this.ctrl.replay();
        PowerMock.replayAll((Object[])new Object[0]);
        StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)true, (boolean)false, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE);
    }

    @Test
    public void shouldNotWipeStateStoresIfUnableToLockTaskDirectory() throws IOException {
        File unknownFile = new File("/unknown/path");
        EasyMock.expect((Object)this.stateManager.taskId()).andReturn((Object)this.taskId);
        EasyMock.expect((Object)this.stateDirectory.lock(this.taskId)).andReturn((Object)false);
        EasyMock.expect((Object)this.stateManager.baseDir()).andReturn((Object)unknownFile);
        Utils.delete((File)unknownFile);
        EasyMock.expectLastCall().andThrow((Throwable)((Object)new AssertionError((Object)"Should not be trying to wipe state you don't own!")));
        this.ctrl.checkOrder(true);
        this.ctrl.replay();
        PowerMock.replayAll((Object[])new Object[0]);
        StateManagerUtil.closeStateManager((Logger)this.logger, (String)"logPrefix:", (boolean)false, (boolean)true, (ProcessorStateManager)this.stateManager, (StateDirectory)this.stateDirectory, (Task.TaskType)Task.TaskType.ACTIVE);
    }
}

