/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.streams.processor.internals.ChangelogReader;
import org.apache.kafka.streams.processor.internals.ProcessorStateManager;

public class MockChangelogReader
implements ChangelogReader {
    private final Set<TopicPartition> restoringPartitions = new HashSet<TopicPartition>();
    private Map<TopicPartition, Long> restoredOffsets = Collections.emptyMap();

    public boolean isPartitionRegistered(TopicPartition partition) {
        return this.restoringPartitions.contains(partition);
    }

    public void register(TopicPartition partition, ProcessorStateManager stateManager) {
        this.restoringPartitions.add(partition);
    }

    public void restore() {
    }

    public void enforceRestoreActive() {
    }

    public void transitToUpdateStandby() {
    }

    public Set<TopicPartition> completedChangelogs() {
        return this.restoringPartitions;
    }

    public void clear() {
        this.restoringPartitions.clear();
    }

    public void unregister(Collection<TopicPartition> partitions) {
        this.restoringPartitions.removeAll(partitions);
        for (TopicPartition partition : partitions) {
            this.restoredOffsets.remove(partition);
        }
    }

    public boolean isEmpty() {
        return this.restoredOffsets.isEmpty() && this.restoringPartitions.isEmpty();
    }
}

