/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

public final class EqualityCheck {
    private EqualityCheck() {
    }

    public static <T> void verifyEquality(T o1, T o2) {
        if (o1 == null && o2 == null) {
            return;
        }
        if (o1 == null) {
            throw new AssertionError((Object)String.format("o1 was null, but o2[%s] was not.", o2));
        }
        if (o2 == null) {
            throw new AssertionError((Object)String.format("o1[%s] was not null, but o2 was.", o1));
        }
        EqualityCheck.verifyGeneralEqualityProperties(o1, o2);
        if (!o1.equals(o2)) {
            throw new AssertionError((Object)String.format("o1[%s] was not equal to o2[%s].", o1, o2));
        }
        if (!o2.equals(o1)) {
            throw new AssertionError((Object)String.format("o2[%s] was not equal to o1[%s].", o2, o1));
        }
        EqualityCheck.verifyHashCodeConsistency(o1, o2);
        if (o1.hashCode() != o2.hashCode()) {
            throw new AssertionError((Object)String.format("o1[%s].hash[%d] was not equal to o2[%s].hash[%d].", o1, o1.hashCode(), o2, o2.hashCode()));
        }
    }

    public static <T> void verifyInEquality(T o1, T o2) {
        if (o1 == null && o2 == null) {
            throw new AssertionError((Object)"Both o1 and o2 were null.");
        }
        if (o1 == null) {
            return;
        }
        if (o2 == null) {
            return;
        }
        EqualityCheck.verifyGeneralEqualityProperties(o1, o2);
        if (o1.equals(o2)) {
            throw new AssertionError((Object)String.format("o1[%s] was equal to o2[%s].", o1, o2));
        }
        if (o2.equals(o1)) {
            throw new AssertionError((Object)String.format("o2[%s] was equal to o1[%s].", o2, o1));
        }
        EqualityCheck.verifyHashCodeConsistency(o1, o2);
        if (o1.hashCode() == o2.hashCode()) {
            throw new AssertionError((Object)String.format("o1[%s].hash[%d] was equal to o2[%s].hash[%d], even though !o1.equals(o2). This is NOT A BUG, but it is undesirable for hash collection performance.", o1, o1.hashCode(), o2, o2.hashCode()));
        }
    }

    private static <T> void verifyGeneralEqualityProperties(T o1, T o2) {
        if (!o1.equals(o1)) {
            throw new AssertionError((Object)String.format("o1[%s] was not equal to itself.", o1));
        }
        if (!o2.equals(o2)) {
            throw new AssertionError((Object)String.format("o2[%s] was not equal to itself.", o2));
        }
        if (o1.equals(null)) {
            throw new AssertionError((Object)String.format("o1[%s] was equal to null.", o1));
        }
        if (o2.equals(null)) {
            throw new AssertionError((Object)String.format("o2[%s] was equal to null.", o2));
        }
        if (o1.equals(new Object())) {
            throw new AssertionError((Object)String.format("o1[%s] was equal to an anonymous Object.", o1));
        }
        if (o2.equals(new Object())) {
            throw new AssertionError((Object)String.format("o2[%s] was equal to an anonymous Object.", o2));
        }
    }

    private static <T> void verifyHashCodeConsistency(T o1, T o2) {
        int second;
        int first = o1.hashCode();
        if (first != (second = o1.hashCode())) {
            throw new AssertionError((Object)String.format("o1[%s]'s hashcode was not consistent: [%d]!=[%d].", o1, first, second));
        }
        first = o2.hashCode();
        if (first != (second = o2.hashCode())) {
            throw new AssertionError((Object)String.format("o2[%s]'s hashcode was not consistent: [%d]!=[%d].", o2, first, second));
        }
    }
}

