/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.NoOpWindowStore;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.QueryableStoreTypes;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.internals.GlobalStateStoreProvider;
import org.apache.kafka.streams.state.internals.QueryableStoreProvider;
import org.apache.kafka.test.NoOpReadOnlyStore;
import org.apache.kafka.test.StateStoreProviderStub;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryableStoreProviderTest {
    private final String keyValueStore = "key-value";
    private final String windowStore = "window-store";
    private QueryableStoreProvider storeProvider;
    private HashMap<String, StateStore> globalStateStores;
    private final int numStateStorePartitions = 2;

    @Before
    public void before() {
        StateStoreProviderStub theStoreProvider = new StateStoreProviderStub(false);
        for (int partition = 0; partition < 2; ++partition) {
            theStoreProvider.addStore("key-value", partition, new NoOpReadOnlyStore());
            theStoreProvider.addStore("window-store", partition, new NoOpWindowStore());
        }
        this.globalStateStores = new HashMap();
        this.storeProvider = new QueryableStoreProvider(Collections.singletonList(theStoreProvider), new GlobalStateStoreProvider(this.globalStateStores));
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowExceptionIfKVStoreDoesntExist() {
        ((ReadOnlyKeyValueStore)this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"not-a-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore()))).get((Object)"1");
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowExceptionIfWindowStoreDoesntExist() {
        ((ReadOnlyWindowStore)this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"not-a-store", (QueryableStoreType)QueryableStoreTypes.windowStore()))).fetch((Object)"1", System.currentTimeMillis());
    }

    @Test
    public void shouldReturnKVStoreWhenItExists() {
        Assert.assertNotNull((Object)this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"key-value", (QueryableStoreType)QueryableStoreTypes.keyValueStore())));
    }

    @Test
    public void shouldReturnWindowStoreWhenItExists() {
        Assert.assertNotNull((Object)this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"window-store", (QueryableStoreType)QueryableStoreTypes.windowStore())));
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowExceptionWhenLookingForWindowStoreWithDifferentType() {
        ((ReadOnlyKeyValueStore)this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"window-store", (QueryableStoreType)QueryableStoreTypes.keyValueStore()))).get((Object)"1");
    }

    @Test(expected=InvalidStateStoreException.class)
    public void shouldThrowExceptionWhenLookingForKVStoreWithDifferentType() {
        ((ReadOnlyWindowStore)this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"key-value", (QueryableStoreType)QueryableStoreTypes.windowStore()))).fetch((Object)"1", System.currentTimeMillis());
    }

    @Test
    public void shouldFindGlobalStores() {
        this.globalStateStores.put("global", new NoOpReadOnlyStore());
        Assert.assertNotNull((Object)this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"global", (QueryableStoreType)QueryableStoreTypes.keyValueStore())));
    }

    @Test
    public void shouldReturnKVStoreWithPartitionWhenItExists() {
        Assert.assertNotNull((Object)this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"key-value", (QueryableStoreType)QueryableStoreTypes.keyValueStore()).withPartition(Integer.valueOf(1))));
    }

    @Test
    public void shouldThrowExceptionWhenKVStoreWithPartitionDoesntExists() {
        int partition = 3;
        InvalidStateStoreException thrown = (InvalidStateStoreException)Assert.assertThrows(InvalidStateStoreException.class, () -> ((ReadOnlyKeyValueStore)this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"key-value", (QueryableStoreType)QueryableStoreTypes.keyValueStore()).withPartition(Integer.valueOf(3)))).get((Object)"1"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)IsEqual.equalTo((Object)String.format("The specified partition %d for store %s does not exist.", 3, "key-value")));
    }

    @Test
    public void shouldReturnWindowStoreWithPartitionWhenItExists() {
        Assert.assertNotNull((Object)this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"window-store", (QueryableStoreType)QueryableStoreTypes.windowStore()).withPartition(Integer.valueOf(1))));
    }

    @Test
    public void shouldThrowExceptionWhenWindowStoreWithPartitionDoesntExists() {
        int partition = 3;
        InvalidStateStoreException thrown = (InvalidStateStoreException)Assert.assertThrows(InvalidStateStoreException.class, () -> ((ReadOnlyWindowStore)this.storeProvider.getStore(StoreQueryParameters.fromNameAndType((String)"window-store", (QueryableStoreType)QueryableStoreTypes.windowStore()).withPartition(Integer.valueOf(3)))).fetch((Object)"1", System.currentTimeMillis()));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)IsEqual.equalTo((Object)String.format("The specified partition %d for store %s does not exist.", 3, "window-store")));
    }
}

